%{/* $Date: 92/02/16 08:46:32 $    $Revision: 1.2 $  by $Author: joe $*/
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

*/  
%}

%p 5000
%start screen_text model_text quoted_string group comment

%%

\\CDS_Version return(VERSION_TOKEN);

\\begin_outline return(BEGIN_OUTLINE);
\\end_outline return(END_OUTLINE);

\\begin_page return (BEGIN_PAGE);
\\end_page return (END_PAGE);

\\begin_node return (BEGIN_PAGE);
\\end_node return(END_PAGE);

\\begin_screen {BEGIN screen_text;
		string_token = "";
}

<screen_text>\\end_screen\n {
  BEGIN 0;			//return to normal state
  yytext[yyleng - 12] = '\0';	//chop off \end_screen\n
  string_token += yytext;
  return (SCREEN_TEXT);		//send back the screen text
}

<screen_text>.* string_token += yytext;
<screen_text>\n string_token += yytext;

\{ BEGIN group;

<group>[^\}]*\} {
   cmdebug << "Found group token: " << yytext << "\n";
        if (yytext[yyleng-2] == '\\')
          yymore();
        else {
            yytext[yyleng-1] = '\0';
            BEGIN 0;
            string_token = yytext;
            return (GROUP);
        }
}

\\name return(NAME_TOKEN);
\\title return(TITLE_TOKEN);

\\page_constructor_text return(PAGE_CONSTRUCTOR_TEXT_TOKEN);
\\page_entry_text return(PAGE_ENTRY_TEXT_TOKEN);
\\page_exit_text return(PAGE_EXIT_TEXT_TOKEN);

\\keywords return(KEYWORD_TOKEN);

<quoted_string>\\\" {
       cmdebug << "Got quote" << yytext << "\n";
       string_token += yytext;
}

<quoted_string>\" {
     yytext[yyleng-1] = '\0';
     string_token += yytext;
     BEGIN 0;
     cmdebug << "Token:" << string_token << "\n";
     return (STRING_TOKEN);
}


<quoted_string>[^\\\"\n]* string_token += yytext;
<quoted_string>[\n]+ string_token += yytext;
<quoted_string>\\ string_token += yytext;

\" {
	string_token = "";
	BEGIN quoted_string;
}

[0-9A-Za-z\_]+ {
        cmdebug << "Found string token: " << yytext << "\n";
        string_token = yytext;
        return (STRING_TOKEN);
}

[ \n\t] ;

