/* $Date: 92/01/26 23:03:49 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
#ifndef _CM_PARSER_H
#define _CM_PARSER_H

#include <stream.h>

class CmParser {
 private:
 protected:
  int yymorfg;
  int yychar;
  int yynerrs;
  short yyerrflag;
  int yylineno;
  int yytchar;
  FILE *yyin;
  FILE *yyout;
  virtual void yyerror(char *);
  virtual int yywrap();
  char *yysptr;
  int yyback(int *, int);
  int yyinput();
  void yyoutput(int);
  void yyunput(int);
 public:
  CmParser();
  ~CmParser();
  char yytext[2000];
  char yysbuf[2000];
  int yyleng;
  int SetParserInput(FILE *);
  int SetParserOutput(FILE *);
};

#ifdef DEBUG
#define debug_output(x) cout << x
#else
#define debug_output(x)
#endif

#endif










