\CDS_Version "b6"

\begin_outline
"adding_independent_rv_with_convolution"
"design_philosophy"
"preliminary_explanation"
"adding_independent_rvs"
"defining_independent_rvs"
"convolution_at_work"
"play_time"
"development_issues"
"final_word"
\end_outline


\begin_page{adding_independent_rv_with_convolution}
\title{Adding independent random variables using convolution.}

\page_constructor_text "#!scheme
(load \"$CDS_CONFIG_DIR/cds.scheme\")
(load '/mit/cdsdev/beta/applications/thesis/convolution.scm)
(add-menu-item \"Help\" \"Using-this-screen\"...)"
\begin_screen

\begin_figure {XmLabel}
\figure_name "intro" 
\mapping "True"
borderWidth "0";
bottomPosition "688";
fontList "*lucida-*-r-*-*-24-*";
labelString "Convolution is your new best friend.";
leftPosition "0";
rightPosition "992";
topPosition "608";
\end_figure

\begin_figure {XmLabel}
\figure_name "logo" 
\mapping "True"
borderWidth "0";
bottomPosition "608";
labelPixmap "mit-logo";
labelType "PIXMAP";
leftPosition "192";
marginHeight "14";
marginTop "10";
rightPosition "800";
topPosition "272";
\end_figure
\end_screen
\end_page

\begin_page{preliminary_explanation}
\title{A bit of preliminary explanation.}
\begin_screen

\begin_figure {CmLabel}
\figure_name "explanation" 
\mapping "True"
borderWidth "0";
bottomPosition "976";
fontSize "biggest";
label "@^6[The convolution operation...]
@.
@.
@^6[@c[@i[f]@-[@i[c]](@i[w]@-[0]) = @Int[From[@i[x]@-[0] = -@Infty]To[@Infty]]@#@#@i[f]@-[@i[a]](@i[x]@-[0])*@i[f]@-[@i[b]](@i[w]@-[0] - @i[x]@-[0])d@i[x]@-[0]]]
@.
@.
@^6[@c[@i[p]@-[@i[c]](@i[w]@-[0]) = @Sum[From[@i[x]@-[0] = -@Infty]To[@Infty]]@#@#@i[p]@-[@i[a]](@i[x]@-[0])*@i[p]@-[@i[b]](@i[w]@-[0] - @i[x]@-[0])]]
@.
@.
@>[@^6[  ...for @i[c] = @i[a] + @i[b] and @i[a], @i[b] independent@#@#@#@#@#@#]]
@.";
leftPosition "32";
rightPosition "960";
topPosition "16";
xFlag "left";
\end_figure
\end_screen
\end_page

\begin_page{defining_independent_rvs}
\title{Defining and adding independent random variables.}
\page_constructor_text "(for (i 0 3)
   (cds-figure-set-resource \"$CDS_THIS_PAGE\" (nth pmfa_scale_list i) \"value\" (* 10 (nth pmfa_list i)))
   (cds-figure-set-resource \"$CDS_THIS_PAGE\" (nth pmfb_scale_list i) \"value\" (* 10 (nth pmfb_list i))))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"scale_numa\" \"value\" 2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"scale_numb\" \"value\" 4)
(update-pmfa-text numa)
(update-pmfb-text numb)
(update-border \"pmfa_text\")
(update-border \"pmfb_text\")
(barchart \"pmfa\" pmfa_list)
(barchart \"pmfb\" pmfb_list)"
\page_entry_text "(add-menu-function \"Help\" \"Using-this-screen\"...
      (lambda() (cds-figure-show \"$CDS_THIS_PAGE\" \"help_defining\")
                               (cds-figure-show \"$CDS_THIS_PAGE\" \"ok_help_defining\")))"
\page_exit_text "(remove-menu-function \"Help\" \"Using-this-screen\"...)"
\begin_screen

\begin_figure {AtPlotter}
\figure_name "PMFA" 
\mapping "True"
\constructor_text "(add-barchart \"PMFA\" \"pmfa\" 4)
(set-barchart-resource \"pmfa\" \"xMin\" 0)
(set-barchart-resource \"pmfa\" \"xMax\" 3)
(set-barchart-resource \"pmfa\" \"density\" .7)                                 "
bottomPosition "384";
leftPosition "0";
rightPosition "496";
title "PMF A";
topPosition "0";
xaxis.autoNumber "false";
xaxis.label "x = possible values for random variable A";
xaxis.max "4";
xaxis.min "-1";
yaxis.label "P(x)";
\end_figure

\begin_figure {AtPlotter}
\figure_name "PMFB" 
\mapping "True"
\constructor_text "(add-barchart \"PMFB\" \"pmfb\" 4)
(set-barchart-resource \"pmfb\" \"xMin\" 0)
(set-barchart-resource \"pmfb\" \"xMax\" 3)
(set-barchart-resource \"pmfb\" \"denisty\" 0.7)                                 "
bottomPosition "384";
leftPosition "496";
legendTitle "";
rightPosition "976";
title "PMF B";
topPosition "0";
xaxis.autoNumber "false";
xaxis.label "x = possible values for random variable B";
xaxis.max "4";
xaxis.min "-1";
yaxis.label "P(x)";
\end_figure

\begin_figure {XmPushButton}
\figure_name "Define_PMFs" 
\mapping "True"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\"  \"Define_PMFs\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Show_Stats\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Show_PMFC\")
(for (i 0 (- numa 1))
   (cds-figure-show \"$CDS_THIS_PAGE\" (nth pmfa_scale_list i)))
(for (i 0 (- numb 1))
      (cds-figure-show \"$CDS_THIS_PAGE\" (nth pmfb_scale_list i)))
(cds-figure-show \"$CDS_THIS_PAGE\" \"pmfa_text\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pmfb_text\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"scale_numa\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"scale_numb\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"done\")                                     "
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "Define PMF's";
leftPosition "0";
rightPosition "336";
topPosition "912";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pa[1]" 
\mapping "False"
\callback "Drag" "(set! pmfa_list (replace-nth pmfa_list 1
	(get-slider-value \"scale_Pa\"[1])))
(barchart \"pmfa\" (head pmfa_list numa))                            
(set!  suma (total pmfa_list numa))
(update-pmfa-text numa)
(update-border \"pmfa_text\")    "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pa\"[1] \"Drag\")    "
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "176";
maximum "10";
rightPosition "256";
titleString "P(1)";
topPosition "512";
value "3";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pb[1]" 
\mapping "False"
\callback "Drag" "(set! pmfb_list (replace-nth pmfb_list 1
	(get-slider-value \"scale_Pb\"[1])))
(barchart \"pmfb\" (head pmfb_list numb))                            
(set!  sumb (total pmfb_list numb))
(update-pmfb-text numb)
(update-border \"pmfb_text\")    "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pb\"[1] \"Drag\")    "
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "640";
maximum "10";
rightPosition "720";
titleString "P(1)";
topPosition "512";
value "5";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pb[0]" 
\mapping "False"
\callback "Drag" " (set! pmfb_list (replace-nth pmfb_list 0 
	(get-slider-value \"scale_Pb\"[0])))
(barchart \"pmfb\" (head pmfb_list numb))
(set!  sumb (total pmfb_list numb))
(update-pmfb-text numb)
(update-border \"pmfb_text\")       "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pb\"[0] \"Drag\")    "
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "560";
maximum "10";
rightPosition "640";
titleString "P(0)";
topPosition "512";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pb[2]" 
\mapping "False"
\callback "Drag" "(set! pmfb_list (replace-nth pmfb_list 2
	(get-slider-value \"scale_Pb\"[2])))
(barchart \"pmfb\" (head pmfb_list numb))                            
(set!  sumb (total pmfb_list numb))
(update-pmfb-text numb)
(update-border \"pmfb_text\")    "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pb\"[2] \"Drag\")    "
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "720";
maximum "10";
rightPosition "800";
titleString "P(2)";
topPosition "512";
value "3";
\end_figure

\begin_figure {XmPushButton}
\figure_name "done" 
\mapping "False"
\callback "Arm" "(if  (not (and (= suma 1) (= sumb 1)))
    (for (i 1 1)
        (cds-figure-show \"$CDS_THIS_PAGE\" \"warning\")
        (cds-figure-show \"$CDS_THIS_PAGE\" \"warning_ok\")
        (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda\")
        (cds-figure-hide \"$CDS_THIS_PAGE\" \"done\"))
    (for (i 1 1)   
        (for (j 0 3)
               (cds-figure-hide \"$CDS_THIS_PAGE\" (nth pmfa_scale_list j))
               (cds-figure-hide \"$CDS_THIS_PAGE\" (nth pmfb_scale_list j)))
        (cds-figure-hide \"$CDS_THIS_PAGE\" \"pmfa_text\")
        (cds-figure-hide \"$CDS_THIS_PAGE\" \"pmfb_text\")
        (cds-figure-hide \"$CDS_THIS_PAGE\" \"scale_numa\")
        (cds-figure-hide \"$CDS_THIS_PAGE\" \"scale_numb\")
        (cds-figure-show \"$CDS_THIS_PAGE\" \"Define_PMFs\")
        (cds-figure-show \"$CDS_THIS_PAGE\" \"Show_Stats\")
        (cds-figure-show \"$CDS_THIS_PAGE\" \"Show_PMFC\")
        (cds-figure-hide \"$CDS_THIS_PAGE\" \"done\")
        (set! pmfa_list (head pmfa_list numa))
        (set! pmfb_list (head pmfb_list numb))))"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "DONE";
leftPosition "432";
rightPosition "560";
topPosition "896";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pa[0]" 
\mapping "False"
\callback "Drag" "(set! pmfa_list (replace-nth pmfa_list 0
	(get-slider-value \"scale_Pa\"[0])))
(barchart \"pmfa\" (head pmfa_list numa))
(set!  suma (total pmfa_list numa))
(update-pmfa-text numa)
(update-border \"pmfa_text\")       "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pa\"[0] \"Drag\")            "
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "80";
maximum "10";
rightPosition "176";
titleString "P(0)";
topPosition "512";
value "7";
\end_figure

\begin_figure {XmPushButton}
\figure_name "warning_ok" 
\mapping "False"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"warning_ok\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"warning\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"done\")"
bottomPosition "896";
fontList "*lucida-*-r-*-*-24-*";
labelString "OK";
leftPosition "912";
rightPosition "976";
topPosition "832";
\end_figure

\begin_figure {XmLabel}
\figure_name "warning" 
\mapping "False"
bottomPosition "896";
fontList "*lucida-*-r-*-*-24-*";
labelString "The sum of the probabilities of all values of 
random variables A and B equal to 1 must be!";
leftPosition "48";
rightPosition "976";
topPosition "400";
\end_figure

\begin_figure {CmLabel}
\figure_name "pmfb_text" 
\mapping "False"
borderWidth "6";
bottomPosition "992";
fontSize "big";
label "0@#+@#0.5@#+@#0.3@#+@#0.2@#=@#1";
leftPosition "576";
rightPosition "896";
topPosition "896";
\end_figure

\begin_figure {CmLabel}
\figure_name "pmfa_text" 
\mapping "False"
borderWidth "6";
bottomPosition "992";
fontSize "big";
label "0.7@#+@#0.3@#=@#1";
leftPosition "112";
rightPosition "416";
topPosition "896";
\end_figure

\begin_figure {XmPushButton}
\figure_name "Show_Stats" 
\mapping "True"
\callback "Arm" "(set! temp 0)
(set! height (/ (- bottom top) (* numa numb)))
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Define_PMFs\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Show_PMFC\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Show_Stats\")
(for (i 0 (- numa 1))
    (for (j 0 (- numb 1))
       (make-label-box i j  temp  height)
       (make-prob-box i j temp height)
       (make-sum-box i j temp height)
       (set! temp (+ 1 temp))))
(set! height 
    (/ (- (- bottom top) 50) (- (+ numa numb) 1)))
(for (i 0 (- (+ numa numb) 2))
  (make-csum-box i i height))
(cds-figure-show \"$CDS_THIS_PAGE\" \"stats_header\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"stats_done\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"csum_header\")"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "Show Statistics";
leftPosition "336";
rightPosition "672";
topPosition "912";
\end_figure

\begin_figure {XmLabel}
\figure_name "stats_header" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
bottomPosition "459";
fontList "*times-*-r-*-*-24-*";
labelString "         Sample Point              Probability                     Sum";
leftPosition "0";
rightPosition "660";
topPosition "383";
\end_figure

\begin_figure {XmPushButton}
\figure_name "stats_done" 
\mapping "False"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"stats_header\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"stats_done\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"csum_header\")
(for (i 0 (- numa 1))
   (for (j 0 (- numb 1))
        (cut-figure (concat '[  i ', j ']))
        (cut-figure (concat \"prob\" i j))
        (cut-figure (concat \"sum\" i j))))
(for (i 0 (- (+ numa numb) 2))
      (cut-figure (concat \"C\" i)))
(cds-figure-show \"$CDS_THIS_PAGE\" \"Define_PMFs\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"Show_Stats\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"Show_PMFC\")
           "
bottomPosition "991";
fontList "*lucida-*-r-*-*-24-*";
labelString "DONE";
leftPosition "661";
rightPosition "978";
topPosition "943";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pb[3]" 
\mapping "False"
\callback "Drag" "(set! pmfb_list (replace-nth pmfb_list 3 
	(get-slider-value \"scale_Pb\"[3])))
(barchart \"pmfb\" (head pmfb_list numb))                            
(set!  sumb (total pmfb_list numb))
(update-pmfb-text numb)
(update-border \"pmfb_text\")    "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pb\"[3] \"Drag\")"
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "800";
maximum "10";
rightPosition "880";
titleString "P(3)";
topPosition "512";
value "2";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pa[3]" 
\mapping "False"
\callback "Drag" "(set! pmfa_list (replace-nth pmfa_list 3
	(get-slider-value \"scale_Pa\"[3])))
(barchart \"pmfa\" (head pmfa_list numa))                            
(set!  suma (total pmfa_list numa))
(update-pmfa-text numa)
(update-border \"pmfa_text\")    "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pa\"[3] \"Drag\")"
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "336";
maximum "10";
rightPosition "416";
titleString "P(3)";
topPosition "512";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_Pa[2]" 
\mapping "False"
\callback "Drag" "(set! pmfa_list (replace-nth pmfa_list 2
	(get-slider-value \"scale_Pa\"[2])))
(barchart \"pmfa\" (head pmfa_list numa))                            
(set!  suma (total pmfa_list numa))
(update-pmfa-text numa)
(update-border \"pmfa_text\")    "
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_Pa\"[2] \"Drag\")"
borderWidth "0";
bottomPosition "896";
decimalPoints "1";
leftPosition "256";
maximum "10";
rightPosition "336";
titleString "P(2)";
topPosition "512";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_numa" 
\mapping "False"
\callback "Drag" "(set! temp (get-slider-value \"scale_numa\"))
(if (>  temp numa)
      (for (i  numa (- temp 1))
            (cds-figure-show \"$CDS_THIS_PAGE\" (nth pmfa_scale_list i))
	    (set! pmfa_list (replace-nth pmfa_list i 
			(get-slider-value (nth pmfa_scale_list i))))))
(if (< temp numa)
       (for (i  temp 3)
                 (cds-figure-hide \"$CDS_THIS_PAGE\" (nth pmfa_scale_list i))))
(set! numa temp)
(barchart \"pmfa\" (head pmfa_list numa))
(set! suma (total pmfa_list numa))
(update-pmfa-text numa)
(update-border \"pmfa_text\")
"
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_numa\" \"Drag\")"
bottomPosition "512";
leftPosition "112";
maximum "4";
minimum "1";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "416";
titleString "# of possible values for random variable A";
topPosition "400";
value "2";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_numb" 
\mapping "False"
\callback "Drag" "(set! temp (get-slider-value \"scale_numb\"))
(if (>  temp numb)
        (for (i  numb (- temp 1))
            (cds-figure-show \"$CDS_THIS_PAGE\" (nth pmfb_scale_list i))
	    (set! pmfb_list (replace-nth pmfb_list i 
			(get-slider-value (nth pmfb_scale_list i))))))
(if (< temp numb)
    (for (i  temp 3)
                 (cds-figure-hide \"$CDS_THIS_PAGE\" (nth pmfb_scale_list i))))
(set! numb temp)
(barchart \"pmfb\" (head pmfb_list numb))
(set! sumb (total pmfb_list numb))
(update-pmfb-text numb)
(update-border \"pmfb_text\")"
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_numb\" \"Drag\")"
bottomPosition "512";
leftPosition "576";
maximum "4";
minimum "1";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "880";
titleString "# of possible values for random variable B";
topPosition "400";
value "4";
\end_figure

\begin_figure {CmLabel}
\figure_name "csum_header" 
\mapping "False"
bottomPosition "458";
fontSize "medbig";
label "@b{C = A + B }";
leftPosition "661";
rightPosition "977";
topPosition "383";
\end_figure

\begin_figure {XmPushButton}
\figure_name "Show_PMFC" 
\mapping "True"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"Define_PMFs\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Show_Stats\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Show_PMFC\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"PMFC\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pmfc_done\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pmf_list\")
(define a (convolve (head  pmfa_list numa)
                    (head pmfb_list numb)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"pmf_list\" \"label\"
   (concat '@b{@c[  (quote PMF A = ) 
     (sublist pmfa_list numa) newline newline
     (quote PMF B = ) (sublist pmfb_list numb)
      newline newline
     (quote PMF C =) (sublist a(-(+ numa numb)1))
      ']}))
(barchart \"pmfc\" a)"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "Convolve A and B";
leftPosition "672";
rightPosition "992";
topPosition "912";
\end_figure

\begin_figure {AtPlotter}
\figure_name "PMFC" 
\mapping "False"
\constructor_text "(add-barchart \"PMFC\" \"pmfc\" 7)
(set-barchart-resource \"pmfc\"  \"xMin\" 0)
(set-barchart-resource \"pmfc\" \"xMax\" 6)
(set-barchart-resource \"pmfc\" \"density\" .7)"
bottomPosition "768";
leftPosition "0";
rightPosition "496";
title "PMF A + PMF B = PMF C";
topPosition "384";
xaxis.autoNumber "false";
xaxis.label "x = possible values for random variable C";
xaxis.max "7";
xaxis.min "-1";
yaxis.label "P(x)";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pmfc_done" 
\mapping "False"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"PMFC\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"pmfc_done\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"pmf_list\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"Show_Stats\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"Define_PMFs\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"Show_PMFC\")"
bottomPosition "864";
fontList "*lucida-*-r-*-*-24-*";
labelString "DONE";
leftPosition "256";
rightPosition "736";
topPosition "768";
\end_figure

\begin_figure {CmLabel}
\figure_name "pmf_list" 
\mapping "False"
bottomPosition "768";
fontSize "medbig";
label "@b{@c[PMF A = (0.7 0.3)@.@.PMF B = (0.2 0.5 0.3)@.@.PMF C =(0.14 0.41 0.36 0.09)]}";
leftPosition "496";
rightPosition "976";
topPosition "384";
\end_figure

\begin_figure {XmLabel}
\figure_name "yoda" 
\mapping "False"
borderWidth "0";
bottomPosition "813";
labelPixmap "yoda";
labelType "PIXMAP";
leftPosition "59";
rightPosition "206";
topPosition "462";
\end_figure

\begin_figure {CmLabel}
\figure_name "help_defining" 
\mapping "False"
bottomPosition "992";
fontSize "big";
label "@b{Define PMFs} - This button will bring up a group of sliders which will allow you
@c{ to choose the number of points for PMFs A and B and let you assign probabilities to them.}
@.
@c{@b{Show Statistics} - This button will produce a table enumerating the probabilities of }
@c{all sample  points in the sample space of random variables a and b. It also displays a table of}
@c{ values for the PMF of random variable c,  the sum of random variables a and b.}
@.
@c{@b{Convolve A and B} - This will display a graph showing PMF C, the PMF derived from}
@c{convolving PMF A and PMF B.}";
leftPosition "0";
rightPosition "992";
topPosition "384";
\end_figure

\begin_figure {XmPushButton}
\figure_name "ok_help_defining" 
\mapping "False"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"ok_help_defining\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"help_defining\")"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "OK";
leftPosition "912";
rightPosition "992";
topPosition "928";
\end_figure
\end_screen
\end_page

\begin_page{convolution_at_work}
\title{The convolution operation at work.}
\page_constructor_text "(define amax -1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_a\" \"set\" \"true\")
(barchart \"pmfc2\" pmfc_list)"
\page_entry_text "(set! pmfc_list (convolve pmfa_list pmfb_list))
(define slid_pmf \"a\")
(set! amax -1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"pmfa_label\" \"label\"
  (concat '@b{ (list-to-string (map prec2 (reverse pmfa_list))) '} ))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"pmfb_label\" \"label\"
  (concat '@b{ (list-to-string (map prec2 pmfb_list)) '}))
(position-pmfa-label -1)
(position-pmfb-label 3)
(cds-figure-show \"$CDS_THIS_PAGE\" \"pmfa_label\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pmfb_label\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"PMFA2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"PMFB2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"convolve_chart\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"PMFC2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"slide_a\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"slide_b\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"scale_i\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"label_c\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"label_b\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"label_a\")
(update-ith-sum-label -1)
(update-pmfc-label -1)
(barchart \"pmfa2\" pmfa_list)
(barchart \"pmfb2\" pmfb_list)
(barchart \"convb\" pmfb_list)
(barchart \"conva\" (reverse pmfa_list))
(set-barchart-resource \"conva\" \"xMin\" -4)
(set-barchart-resource \"conva\" \"xMax\" -1)
(set-barchart-resource \"convb\" \"xMin\" 0)
(set-barchart-resource \"convb\" \"xMax\" 3)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"scale_i\" \"value\" -1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_a\" \"set\" \"true\")
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_b\" \"set\" \"false\")
(barchart \"pmfc2\" (head pmfc_list 0))
(add-menu-function \"Help\" \"Using-this-screen\"...
      (lambda() (cds-figure-show \"$CDS_THIS_PAGE\" \"help_sliding\")
                               (cds-figure-show \"$CDS_THIS_PAGE\" \"ok_help_sliding\")))"
\page_exit_text "(remove-menu-function \"Help\" \"Using-this-screen\"...)"
\begin_screen

\begin_figure {AtPlotter}
\figure_name "PMFA2" 
\mapping "True"
\constructor_text "(add-barchart \"PMFA2\" \"pmfa2\" 4)
(set-barchart-resource \"pmfa2\" \"shading\" \"true\")
(set-barchart-resource \"pmfa2\" \"pattern\" \"AtGRAY5\")
(set-barchart-resource \"pmfa2\" \"xMin\" 0)
(set-barchart-resource \"pmfa2\" \"xMax\" 3)"
bottomPosition "336";
leftPosition "0";
rightPosition "496";
title "PMF A";
topPosition "0";
xaxis.autoNumber "false";
xaxis.label "x = possible values for random variable A";
xaxis.max "4";
xaxis.min "-1";
yaxis.label "P(x)";
\end_figure

\begin_figure {AtPlotter}
\figure_name "PMFC2" 
\mapping "True"
\constructor_text "(add-barchart \"PMFC2\" \"pmfc2\" 7)
(set-barchart-resource \"pmfc2\" \"xMin\" 0)
(set-barchart-resource \"pmfc2\" \"xMax\" 6)
(set-barchart-resource \"pmfc2\" \"shading\" \"true\")
(set-barchart-resource \"pmfc2\" \"pattern\" \"AtGRAY2\")
(add-barchart \"PMFC2\" \"current_c\" 7)
(set-barchart-resource \"current_c\" \"xMin\" 0)
(set-barchart-resource \"current_c\" \"xMax\" 6)
"
bottomPosition "704";
leftPosition "496";
rightPosition "976";
title "PMFA + PMF B = PMF C";
topPosition "336";
xaxis.autoNumber "false";
xaxis.label "x = possible values for random variable c";
xaxis.max "7";
xaxis.min "-1";
yaxis.label "P(x)";
\end_figure

\begin_figure {AtPlotter}
\figure_name "PMFB2" 
\mapping "True"
\constructor_text "(add-barchart \"PMFB2\" \"pmfb2\" 4)
(set-barchart-resource \"pmfb2\" \"shading\" \"true\")
(set-barchart-resource \"pmfb2\" \"xMin\" 0)
(set-barchart-resource \"pmfb2\" \"xMax\" 3)
(set-barchart-resource \"pmfb2\" \"pattern\" \"AtGRAY0\")"
bottomPosition "336";
leftPosition "496";
rightPosition "976";
title "PMF B";
topPosition "0";
xaxis.autoNumber "false";
xaxis.label "x = possible values for random variable b";
xaxis.max "4";
xaxis.min "-1";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_i" 
\mapping "True"
\callback "Drag" "(set!  amax (get-slider-value \"scale_i\"))
(if (eq? slid_pmf  \"a\") (for (i 0 0)
       (barchart \"conva\" (reverse pmfa_list))
       (barchart \"convb\" pmfb_list)
       (set-barchart-resource \"convb\" \"xMin\" 0)
       (set-barchart-resource \"convb\" \"xMax\" 3)
       (set-barchart-resource \"conva\" \"xMin\" (- amax 3))
       (set-barchart-resource \"conva\" \"xMax\" amax)
       (position-pmfa-label amax))
     (for (i 0 0)
     (barchart \"convb\" (reverse pmfb_list))
     (barchart \"conva\" pmfa_list)
     (set-barchart-resource \"convb\" \"xMin\" (- amax 3))
     (set-barchart-resource \"convb\" \"xMax\" amax)
     (set-barchart-resource \"conva\" \"xMin\" 0)
     (set-barchart-resource \"conva\" \"xMax\" 3)
     (position-pmfb-label amax)))  
(update-ith-sum-label amax)
(barchart \"pmfc2\" pmfc_list)
(barchart \"current_c\" 
    (replace-nth (list 0 0 0 0 0 ) amax
                                    (nth pmfc_list amax)))
(update-pmfc-label amax)"
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_i\" \"Drag\")"
borderWidth "0";
bottomPosition "800";
leftPosition "64";
maximum "6";
minimum "-2";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "496";
titleString "C(w)";
topPosition "688";
value "-1";
\end_figure

\begin_figure {AtPlotter}
\figure_name "convolve_chart" 
\mapping "True"
\constructor_text "(add-barchart \"convolve_chart\" \"convb\" 4)
(add-barchart \"convolve_chart\" \"conva\" 4)
(set-barchart-resource \"conva\" \"shading\" \"true\")
(set-barchart-resource \"conva\" \"pattern\" \"AtGRAY5\")
(set-barchart-resource \"conva\" \"density\" .5)
(set-barchart-resource \"convb\" \"shading\" \"true\")
(set-barchart-resource \"convb\" \"pattern\" \"AtGRAY0\")
(set-barchart-resource \"convb\" \"density\" .8)"
bottomPosition "704";
leftPosition "0";
rightPosition "496";
title "Convolving PMF A and PMF B";
topPosition "336";
xaxis.autoNumber "false";
xaxis.label "x = possible values for randomvariables a and b";
xaxis.max "6";
xaxis.min "-2";
yaxis.label "P(x)";
\end_figure

\begin_figure {XmToggleButton}
\figure_name "slide_b" 
\mapping "True"
\callback "Value Changed" "(if (eq? slid_pmf  \"a\")
      (for (i 0 0)
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_b\" \"set\" \"true\")
         (set! slid_pmf \"b\")
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_a\" \"set\" \"false\")
         (barchart \"convb\" (reverse(head pmfb_list numb)))
         (barchart \"conva\" (head pmfa_list numa))
         (set-barchart-resource \"conva\" \"xMin\" 0)
         (set-barchart-resource \"conva\" \"xMax\" 3)
         (set-barchart-resource \"convb\" \"xMax\" amax)
         (set-barchart-resource \"convb\" \"xMin\" (- amax 3))
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"pmfa_label\" \"label\" 
               (concat '@b{ 
               (list-to-string (map prec2 pmfa_list)) '}))
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"pmfb_label\" \"label\"
               (concat '@b{ (list-to-string 
                (map prec2 (reverse pmfb_list))) '}))
         (position-pmfb-label amax)
         (position-pmfa-label 3)
         (update-ith-sum-label amax))
       (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_b\" \"set\" \"true\"))"
borderWidth "0";
bottomPosition "800";
fontList "*lucida-*-r-*-*-24-*";
labelString "Slide PMF B";
leftPosition "720";
rightPosition "912";
set "false";
topPosition "704";
\end_figure

\begin_figure {XmToggleButton}
\figure_name "slide_a" 
\mapping "True"
\callback "Value Changed" "(if (eq? slid_pmf  \"b\")
      (for (i 0 0)
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_a\" \"set\" \"true\")  
         (set! slid_pmf \"a\")
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_b\" \"set\" \"false\")
         (barchart \"conva\" (reverse(head pmfa_list numa)))
         (barchart \"convb\" (head pmfb_list numb))
         (set-barchart-resource \"convb\" \"xMin\" 0)
         (set-barchart-resource \"convb\" \"xMax\" 3)
         (set-barchart-resource \"conva\" \"xMax\" amax)
         (set-barchart-resource \"conva\" \"xMin\" (- amax 3))
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"pmfa_label\" \"label\"
                           (concat '@b{ (list-to-string 
                          (map prec2 (reverse pmfa_list))) '}))
         (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"pmfb_label\" \"label\"
                  (concat '@b{
            (list-to-string (map prec2 pmfb_list)) '}))
         (position-pmfb-label 3)
         (position-pmfa-label amax)
         (update-ith-sum-label amax))
        (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"slide_a\" \"set\" \"true\"))"
borderWidth "0";
bottomPosition "800";
fontList "*lucida-*-r-*-*-24-*";
labelString "Slide PMF A";
leftPosition "528";
rightPosition "720";
set "true";
topPosition "704";
\end_figure

\begin_figure {CmLabel}
\figure_name "pmfc_label" 
\mapping "True"
bottomPosition "992";
fontSize "medbig";
label "@b{0.00}";
leftPosition "88";
rightPosition "688";
topPosition "944";
xFlag "left";
\end_figure

\begin_figure {CmLabel}
\figure_name "ith_sum_label" 
\mapping "True"
bottomPosition "944";
fontSize "medbig";
label "@b{0.00@#=@#0}";
leftPosition "394";
rightPosition "810";
topPosition "896";
xFlag "left";
\end_figure

\begin_figure {CmLabel}
\figure_name "pmfb_label" 
\mapping "True"
bottomPosition "896";
fontSize "medbig";
label "@b{0.00___0.50___0.30___0.20}";
leftPosition "394";
rightPosition "702";
topPosition "848";
xFlag "left";
\end_figure

\begin_figure {CmLabel}
\figure_name "pmfa_label" 
\mapping "True"
bottomPosition "848";
fontSize "medbig";
label "@b{0.00___0.00___0.30___0.70}";
leftPosition "88";
rightPosition "396";
topPosition "800";
xFlag "left";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_c" 
\mapping "True"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "PMFC";
leftPosition "0";
rightPosition "84";
topPosition "944";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_b" 
\mapping "True"
bottomPosition "896";
fontList "*lucida-*-r-*-*-24-*";
labelString "PMFB";
leftPosition "0";
rightPosition "84";
topPosition "848";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_a" 
\mapping "True"
bottomPosition "848";
fontList "*lucida-*-r-*-*-24-*";
labelString "PMFA";
leftPosition "0";
rightPosition "84";
topPosition "800";
\end_figure

\begin_figure {CmLabel}
\figure_name "help_sliding" 
\mapping "False"
bottomPosition "352";
fontSize "big";
label "@c{Use the toggle buttons to select which PMF to mirror and translate}
@c{ across the x-axis of the barchart labeled Convolving PMF A and PMF B.}@.
@c{Use the slider to translate the mirrored PMF across the x-axis. The barchart labeled}
@c{PMF A + PMF B = PMF C will show the values of PMF C as they are calculated.}
@.@c{The labels at the bottom display the same information as the barcharts.}";
leftPosition "0";
rightPosition "976";
topPosition "0";
\end_figure

\begin_figure {XmPushButton}
\figure_name "ok_help_sliding" 
\mapping "False"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"ok_help_sliding\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"help_sliding\")"
bottomPosition "352";
fontList "*lucida-*-r-*-*-24-*";
labelString "OK";
leftPosition "912";
rightPosition "976";
topPosition "272";
\end_figure
\end_screen
\end_page

\begin_page{play_time}
\title{Play time!}
\page_constructor_text "(define current_pmf \"a\")
(define pmf_type \"bernoulli\")
(define pmfa3_list (append pmfa_list (list 0 0 0 0 0 0)))
(define pmfb3_list (append pmfb_list (list 0 0 0 0 0 0)))
(define pmfc3_list (convolve pmfa3_list pmfb3_list))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"define_a\" \"set\" \"true\")
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"define_b\" \"set\" \"false\")
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFA3\" \"borderWidth\" 4)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFB3\" \"borderWidth\" 1)
(add-menu-pane \"PMFs\")
(add-menu-item \"PMFs\" \"Bernoulli\")
(add-menu-item \"PMFs\" \"Binomial\")
(add-menu-item \"PMFs\" \"Geometric\")
(add-menu-item \"PMFs\" \"Pascal\")
(add-menu-item \"PMFs\" \"PMFC\")
(add-menu-item \"PMFs\" \"Random\")
(barchart \"pmfa3\" pmfa3_list)
(barchart \"pmfb3\" pmfb3_list)
(barchart \"pmfc3\" pmfc3_list)"
\page_entry_text "(add-menu-function \"PMFs\" \"Binomial\" set-binomial)
(add-menu-function \"PMFs\" \"Bernoulli\" set-bernoulli)
(add-menu-function \"PMFs\" \"Geometric\" set-geometric)
(add-menu-function \"PMFs\" \"Pascal\" set-pascal)
(add-menu-function \"PMFs\" \"PMFC\" set-c)
(add-menu-function \"PMFs\" \"Random\" set-random)
(add-menu-function \"Help\" \"Using-this-screen\"...
          (lambda() (cds-figure-show \"$CDS_THIS_PAGE\" \"playing_help\")
                                   (cds-figure-show \"$CDS_THIS_PAGE\" \"ok_playing_help\")))"
\page_exit_text "(remove-menu-function \"PMFs\" \"Binomial\" )
(remove-menu-function \"PMFs\" \"Bernoulli\" )
(remove-menu-function \"PMFs\" \"Geometric\" )
(remove-menu-function \"PMFs\" \"Pascal\" )
(remove-menu-function \"PMFs\" \"PMFC\" )
(remove-menu-function \"PMFs\" \"Random\" )
(remove-menu-function \"Help\" \"Using-this-screen\"...)"
\begin_screen

\begin_figure {AtPlotter}
\figure_name "PMFC3" 
\mapping "True"
\constructor_text "(add-barchart \"PMFC3\" \"pmfc3\" 18)
(set-barchart-resource \"pmfc3\" \"xMin\" 0)
(set-barchart-resource \"pmfc3\" \"xMax\" 17) "
bottomPosition "912";
leftPosition "0";
rightPosition "496";
title "PMFC = PMF A + PMF B";
topPosition "416";
xaxis.autoNumber "false";
xaxis.label "x = possible values of random variable C";
xaxis.max "19";
xaxis.min "-1";
yMax "1";
yMaximum "1";
yaxis.label "P(x)";
\end_figure

\begin_figure {AtPlotter}
\figure_name "PMFA3" 
\mapping "True"
\constructor_text "(add-barchart \"PMFA3\" \"pmfa3\" 10)
(set-barchart-resource \"pmfa3\" \"xMin\" 0)
(set-barchart-resource \"pmfa3\" \"xMax\" 9)
"
borderWidth "4";
bottomPosition "416";
leftPosition "0";
rightPosition "496";
title "PMF A";
topPosition "0";
xaxis.autoNumber "false";
xaxis.label "x = possible values of random variable A";
xaxis.max "11";
xaxis.min "-1";
yaxis.label "P(x)";
\end_figure

\begin_figure {AtPlotter}
\figure_name "PMFB3" 
\mapping "True"
\constructor_text "(add-barchart \"PMFB3\" \"pmfb3\" 10)
(set-barchart-resource \"pmfb3\" \"xMin\" 0)
(set-barchart-resource \"pmfb3\" \"xMax\" 9)"
bottomPosition "416";
leftPosition "496";
rightPosition "992";
title "PMF B";
topPosition "0";
xaxis.autoNumber "false";
xaxis.label "x = possible values of random variable B";
xaxis.max "11";
xaxis.min "-1";
yaxis.label "P(x)";
\end_figure

\begin_figure {XmToggleButton}
\figure_name "define_b" 
\mapping "True"
\callback "Value Changed" "(if (eq? current_pmf \"b\")
      (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"define_b\" \"set\" \"true\")
      (for (i 0 0)
           (set! current_pmf \"b\")
           (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"define_a\" \"set\" \"False\")
           (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFA3\" \"borderWidth\" 1)
           (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFB3\" \"borderWidth\" 4)
           (barchart \"pmfa3\" pmfa3_list)
           (barchart \"pmfb3\" pmfb3_list)))"
bottomPosition "512";
fontList "*lucida-*-r-*-*-24-*";
labelString "Define PMF B";
leftPosition "748";
rightPosition "992";
set "false";
topPosition "416";
\end_figure

\begin_figure {XmToggleButton}
\figure_name "define_a" 
\mapping "True"
\callback "Value Changed" "(if (eq? current_pmf \"a\")
      (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"define_a\" \"set\" \"true\")
      (for (i 0 0)
           (set! current_pmf \"a\")
           (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"define_b\" \"set\" \"false\")
           (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFA3\" \"borderWidth\" 4)
           (cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFB3\" \"borderWidth\" 1)
           (barchart \"pmfa3\" pmfa3_list)
           (barchart \"pmfb3\" pmfb3_list)))"
bottomPosition "512";
fontList "*lucida-*-r-*-*-24-*";
labelString "Define PMF A";
leftPosition "496";
rightPosition "748";
set "true";
topPosition "416";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_n" 
\mapping "False"
\callback "Drag" "(define n (get-slider-value \"scale_n\"))
(define p (get-slider-value \"scale_p\"))
(set! pmf_list (binomial p n 10))
(if (eq? current_pmf \"a\") 
      (for (i 0 0)
        (set! pmfa3_list pmf_list)
        (barchart \"pmfa3\" pmfa3_list))
       (for (i 0 0)
        (set! pmfb3_list pmf_list)
        (barchart \"pmfb3\" pmfb3_list)))
(set! pmfc3_list (convolve pmfa3_list pmfb3_list))
(barchart \"pmfc3\"  pmfc3_list)"
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_n\" \"Drag\")"
borderWidth "0";
bottomPosition "912";
leftPosition "656";
maximum "9";
minimum "1";
rightPosition "736";
titleString "N";
topPosition "512";
value "9";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_r" 
\mapping "False"
\callback "Drag" "(define pmf_list (list 0 0 0 0 0 0 0 0 0 0 ))
(define p (get-slider-value \"scale_p\"))
(define r (get-slider-value \"scale_r\"))
(set! pmf_list (pascal p r 10))
(if (eq? current_pmf \"a\") 
      (for (i 0 0)
        (set! pmfa3_list pmf_list)
        (barchart \"pmfa3\" pmfa3_list))
       (for (i 0 0)
        (set! pmfb3_list pmf_list)
        (barchart \"pmfb3\" pmfb3_list)))
(set! pmfc3_list (convolve pmfa3_list pmfb3_list))
(barchart \"pmfc3\" pmfc3_list)"
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_r\"  \"Drag\")"
borderWidth "0";
bottomPosition "912";
leftPosition "672";
maximum "10";
minimum "1";
rightPosition "752";
titleString "R";
topPosition "512";
value "2";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_p" 
\mapping "True"
\callback "Drag" "(define pmf_list (list 0 0 0 0 0 0 0 0 0 0))
(define p (get-slider-value \"scale_p\"))
(if (eq? pmf_type \"bernoulli\") (for (i 0 0)
      (set! pmf_list (replace-nth pmf_list 0 (- 1 p)))
      (set! pmf_list (replace-nth pmf_list 1 p))))
(if (eq? pmf_type \"binomial\") (for (i 0 0)
      (define n (get-slider-value \"scale_n\"))
      (set! pmf_list (binomial p n 10))))
(if (eq? pmf_type \"geometric\") (for (i 0 0)
      (set! pmf_list (geometric p 10))))
(if (eq? pmf_type \"pascal\") (for (i 0 0)
      (define r (get-slider-value \"scale_r\"))
      (set! pmf_list (pascal p r 10))))
(if (eq? current_pmf \"a\") 
      (for (i 0 0)
        (set! pmfa3_list pmf_list)
        (barchart \"pmfa3\" pmfa3_list))
       (for (i 0 0)
        (set! pmfb3_list pmf_list)
        (barchart \"pmfb3\" pmfb3_list)))
(set! pmfc3_list (convolve pmfa3_list pmfb3_list))
(barchart \"pmfc3\"  pmfc3_list)"
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_p\" \"Drag\")"
borderWidth "0";
bottomPosition "912";
decimalPoints "2";
leftPosition "576";
rightPosition "656";
titleString "P";
topPosition "512";
value "45";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_num_points" 
\mapping "False"
\callback "Drag" "(define num_p (get-slider-value \"scale_num_points\"))
(define pmf_list (list 0 0 0 0 0 0 0 0 0 0))
(if (eq? pmf_type \"random\")
      (for (i 0 0)
         (for (i 0 (- num_p 1))
              (set! pmf_list (replace-nth pmf_list i (random))))
         (set! pmf_list (map (lambda (x) 
               (/ x (total pmf_list 10))) pmf_list))
         (if (eq? current_pmf \"a\")
             (for (i 0 0)
                (set! pmfa3_list pmf_list)
                (barchart \"pmfa3\" pmfa3_list))
             (for (i 0 0)
                (set! pmfb3_list pmf_list)
                (barchart \"pmfb3\" pmfb3_list)))
          (set! pmfc3_list (convolve pmfa3_list pmfb3_list))
          (barchart \"pmfc3\" pmfc3_list)))"
\callback "Value Changed" "(cds-figure-call-callback \"$CDS_THIS_PAGE\" \"scale_num_points\" \"Drag\")"
borderWidth "0";
bottomPosition "912";
leftPosition "576";
maximum "10";
minimum "1";
rightPosition "704";
titleString "# points...";
topPosition "512";
value "4";
\end_figure

\begin_figure {XmScale}
\figure_name "scale_start_at" 
\mapping "False"
borderWidth "0";
bottomPosition "912";
leftPosition "704";
maximum "9";
rightPosition "864";
titleString "... starting at";
topPosition "512";
value "1";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_random" 
\mapping "False"
borderWidth "0";
bottomPosition "928";
fontList "*lucida-*-r-*-*-24-*";
labelString "RANDOM";
leftPosition "656";
rightPosition "848";
topPosition "848";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_PMFC" 
\mapping "False"
borderWidth "0";
bottomPosition "928";
fontList "*lucida-*-r-*-*-24-*";
labelString "PMFC";
leftPosition "784";
rightPosition "896";
topPosition "832";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_pascal" 
\mapping "False"
borderWidth "0";
bottomPosition "912";
fontList "*lucida-*-r-*-*-24-*";
labelString "PASCAL";
leftPosition "768";
rightPosition "944";
topPosition "816";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_geometric" 
\mapping "False"
borderWidth "0";
bottomPosition "912";
fontList "*lucida-*-r-*-*-24-*";
labelString "GEOMETRIC";
leftPosition "672";
rightPosition "864";
topPosition "816";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_binomial" 
\mapping "False"
borderWidth "0";
bottomPosition "912";
fontList "*lucida-*-r-*-*-24-*";
labelString "BINOMIAL";
leftPosition "736";
rightPosition "944";
topPosition "816";
\end_figure

\begin_figure {XmLabel}
\figure_name "label_bernoulli" 
\mapping "True"
borderWidth "0";
bottomPosition "912";
fontList "*lucida-*-r-*-*-24-*";
labelString "BERNOULLI";
leftPosition "656";
rightPosition "848";
topPosition "832";
\end_figure

\begin_figure {XmPushButton}
\figure_name "set_to_this" 
\mapping "False"
\callback "Arm" "(define pmf_list (list 0 0 0 0 0 0 0 0 0 0))
(define num_p (get-slider-value \"scale_num_points\"))
(define at (get-slider-value \"scale_start_at\"))
(for (j  0 (-  num_p 1))
         (set! pmf_list (replace-nth pmf_list j 
                (nth pmfc3_list (+ j at)))))
(set! pmf_list (map (lambda (x) 
               (/ x (total pmf_list 10))) pmf_list))
(if (eq? current_pmf  \"a\") 
      (for (i 0 0)
        (set! pmfa3_list pmf_list)
        (barchart \"pmfa3\" pmfa3_list))
      (for (i 0 0)
        (set! pmfb3_list pmf_list)
        (barchart \"pmfb3\" pmfb3_list)))
(set! pmfc3_list (convolve pmfa3_list pmfb3_list))
(barchart \"pmfc3\" pmfc3_list)"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "SET TO THIS";
leftPosition "592";
rightPosition "784";
topPosition "928";
\end_figure

\begin_figure {XmPushButton}
\figure_name "unzoom" 
\mapping "False"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"unzoom\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"zoom\")
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFC3\" \"yaxis\".max 1)
(barchart \"pmfc3\" pmfc3_list)
"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "UNZOOM PMF C";
leftPosition "0";
rightPosition "496";
topPosition "912";
\end_figure

\begin_figure {XmPushButton}
\figure_name "zoom" 
\mapping "True"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"zoom\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"unzoom\")
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"PMFC3\" \"yaxis\".max 
    (max pmfc3_list))
(barchart \"pmfc3\" pmfc3_list)"
bottomPosition "992";
fontList "*lucida-*-r-*-*-24-*";
labelString "ZOOM PMF C";
leftPosition "0";
rightPosition "496";
topPosition "912";
\end_figure

\begin_figure {CmLabel}
\figure_name "playing_help" 
\mapping "False"
bottomPosition "416";
fontSize "medbig";
label "@c{In the menu bar, select PMFs to choose a type of PMF to define.}
@c{ Sliders will appear to set parameters.}
@c{Use the toggle buttons to decide which PMF to define.}
@.
@c{The barchart labeled PMF C  = PMF A + PMF B shows the convolution of PMF A and PMF B. }
@c{Use the ZOOM PMF C button to fill the vertical space in the PMF C barchart.}";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {XmPushButton}
\figure_name "ok_playing_help" 
\mapping "False"
\callback "Arm" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"ok_playing_help\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"playing_help\")"
bottomPosition "416";
fontList "*lucida-*-r-*-*-24-*";
labelString "OK";
leftPosition "928";
rightPosition "992";
topPosition "336";
\end_figure
\end_screen
\end_page

\begin_page{final_word}
\title{A Final Word}
\begin_screen

\begin_figure {CmLabel}
\figure_name "credits" 
\mapping "True"
borderWidth "0";
bottomPosition "992";
label "@c[
@b(CDS) is the result of years of hard work by students,
staff, and faculty.   Members of @b(Project CDS)  are:
@b( )
Al Drake,
Ed Moriarty,
Dept. of Electrical Engineering & Computer Science
@b()
Jon C. Haass
Dept. of Mathematics
@b( )
Joe Wang
Sourabh Niyogi
Marc Schaub
John Piscitello
Jason Beardsley
Jeff Turcotte
Adam Feder
@b( )
A special thanks is extended to the @b(UROP)
office, whose funding and support is
greatly appreciated.]";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {XmLabel}
\figure_name "fuzzy" 
\mapping "True"
borderWidth "0";
bottomPosition "816";
labelPixmap "fuzzball";
labelType "PIXMAP";
leftPosition "48";
rightPosition "240";
topPosition "304";
\end_figure
\end_screen
\end_page

\begin_page{design_philosophy}
\title{design_philosophy}
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "432";
fontList "*times-*-r-*-*-24-*";
labelString "(1) Visual feedback needs to be immediate.";
leftPosition "288";
rightPosition "736";
topPosition "336";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "224";
fontList "*times-*-r-*-*-24-*";
labelString "Three guiding principles...";
leftPosition "192";
rightPosition "816";
topPosition "112";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "624";
fontList "*times-*-r-*-*-24-*";
labelString "(3) User input should be spare and robust.";
leftPosition "288";
rightPosition "736";
topPosition "528";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "528";
fontList "*times-*-r-*-*-24-*";
labelString "(2) The screen should be uncluttered.";
leftPosition "288";
rightPosition "736";
topPosition "432";
\end_figure
\end_screen
\end_page

\begin_page{adding_independent_rvs}
\title{Adding Independent Random Variables}
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "544";
fontList "*times-*-r-*-*-24-*";
labelString "(2) The convolution operation at work. ";
leftPosition "288";
rightPosition "736";
topPosition "448";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "448";
fontList "*times-*-r-*-*-24-*";
labelString "(1) Defining and adding random variables. ";
leftPosition "288";
rightPosition "736";
topPosition "352";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "640";
fontList "*times-*-r-*-*-24-*";
labelString "(3) Play time! ";
leftPosition "288";
rightPosition "736";
topPosition "544";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "224";
fontList "*times-*-r-*-*-24-*";
labelString "Three main screens...";
leftPosition "208";
rightPosition "784";
topPosition "128";
\end_figure
\end_screen
\end_page

\begin_page{development_issues}
\title{CDS Development Issues}
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "208";
fontList "*times-*-r-*-*-24-*";
labelString "Three important issues...";
leftPosition "240";
rightPosition "752";
topPosition "112";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "672";
fontList "*times-*-r-*-*-24-*";
labelString "(3) Development with faculty";
leftPosition "336";
rightPosition "656";
topPosition "560";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "560";
fontList "*times-*-r-*-*-24-*";
labelString "(2) Editing Large Applications";
leftPosition "336";
rightPosition "656";
topPosition "448";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "448";
fontList "*times-*-r-*-*-24-*";
labelString "(1) Efficiency of the Model";
leftPosition "336";
rightPosition "656";
topPosition "352";
\end_figure
\end_screen
\end_page
