\CDS_Version "2.0.3.development"

\begin_outline
"introduction"
"what_is_cds"
"periodic_table"
"fuzzy_wuzzy"
"plotter"
"other_goodies"
"untitled0"
\end_outline


\begin_page{introduction}
\title{Introduction to CDS}
\page_constructor_text "#!/bin/csh -f -i
source $CDS_CONFIG_DIR/cds.csh"
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled0_XmLabel0" 
borderWidth "0";
bottomPosition "594";
labelPixmap "mit-logo";
labelString "Default Label.
";
labelType "PIXMAP";
leftPosition "352";
rightPosition "683";
topPosition "258";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled0_XmLabel0" 
borderWidth "0";
bottomPosition "739";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Courseware Development System";
leftPosition "223";
rightPosition "843";
topPosition "649";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
borderWidth "0";
bottomPosition "224";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Welcome to the";
leftPosition "231";
rightPosition "803";
topPosition "127";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "95";
fontList "8x13bold";
labelString "Click the left button on the
NEXT icon to go to the next page";
leftPosition "624";
rightPosition "999";
topPosition "2";
\end_figure
\end_screen
\end_page

\begin_page{periodic_table}
\title{The Figure Periodic Table}
\begin_screen

\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
bottomPosition "259";
fontSize "big";
label "TextTool";
leftPosition "188";
rightPosition "443";
topPosition "164";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
bottomPosition "416";
fontList "*lucida-*-r-*-*-24-*";
labelString "Label";
leftPosition "187";
rightPosition "441";
topPosition "321";
\end_figure

\begin_figure {XmToggleButton}
\figure_name "untitled1_XmToggleButton0" 
bottomPosition "255";
fontList "*lucida-*-r-*-*-24-*";
labelString "ToggleButton";
leftPosition "542";
rightPosition "797";
topPosition "160";
\end_figure

\begin_figure {XmScale}
\figure_name "untitled1_XmScale0" 
bottomPosition "980";
leftPosition "192";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "799";
scaleHeight "30";
scaleWidth "480";
topPosition "804";
value "28";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
bottomPosition "409";
fontList "*lucida-*-r-*-*-24-*";
labelString "PushButton";
leftPosition "549";
rightPosition "804";
topPosition "314";
\end_figure

\begin_figure {AtPlotter}
\figure_name "untitled1_AtPlotter0" 
bottomPosition "782";
leftPosition "193";
motionX "0.235431";
motionY "0.877358";
rightPosition "800";
title "@b(@bigger(Plotter))";
topPosition "463";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
borderWidth "0";
bottomPosition "150";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "The Atoms of CDS";
leftPosition "279";
rightPosition "726";
topPosition "79";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "93";
fontList "8x13bold";
labelString "Click the left button on the
NEXT icon to go to the next page";
leftPosition "654";
rightPosition "996";
topPosition "0";
\end_figure
\end_screen
\end_page

\begin_page{fuzzy_wuzzy}
\title{Fuzzy Wuzzy}
\begin_screen

\begin_figure {XmPushButton}
\figure_name "untitled2_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"fuzzy\")                 "
bottomPosition "620";
fontList "*helvetica-*-r-*-*-20-*";
labelString "Show fuzzy";
leftPosition "200";
rightPosition "440";
topPosition "520";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled2_XmPushButton0" 
\callback "Activate" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"fuzzy\")                 "
bottomPosition "620";
fontList "*helvetica-*-r-*-*-20-*";
labelString "Hide fuzzy";
leftPosition "540";
rightPosition "800";
topPosition "520";
\end_figure

\begin_figure {XmLabel}
\figure_name "fuzzy" 
borderWidth "0";
bottomPosition "482";
labelPixmap "fuzzball";
labelType "PIXMAP";
leftPosition "342";
rightPosition "637";
topPosition "51";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "5";
bottomPosition "929";
fontList "*times-*-r-*-*-20-*";
labelString "These figure actions are stored in the callbacks
of the push buttons as LISP instructions like
(hide-figure 'fuzzy) or (show-figure 'fuzzy)";
leftPosition "128";
rightPosition "844";
topPosition "793";
\end_figure

\begin_figure {CmLabel}
\figure_name "untitled2_CmLabel0" 
borderWidth "0";
bottomPosition "760";
fontSize "big";
label "@b{Click on the Hide Fuzzy and Show Fuzzy push 
                    buttons to see figures in action}
";
leftPosition "200";
rightPosition "800";
topPosition "640";
yFlag "bottom";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "109";
fontList "8x13bold";
labelString "Click the left button on the
NEXT icon to go to the next page";
leftPosition "640";
rightPosition "1000";
topPosition "16";
\end_figure
\end_screen
\end_page

\begin_page{plotter}
\title{Plotter}
\begin_screen

\begin_figure {XmScale}
\figure_name "freq" 
\mapping "True"
\constructor_text "(define f (/ ${freq:value} 10))               "
\callback "Value Changed" "(set! f (/ ${freq:value} 10))"
borderWidth "0";
bottomPosition "800";
decimalPoints "01";
leftPosition "100";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "480";
scaleHeight "20";
scaleWidth "300";
titleString "Frequency";
topPosition "680";
value "17";
\end_figure\begin_figure {XmScale}
\figure_name "amp" 
\mapping "True"
\constructor_text "(define amp ${amp:value})              "
\callback "Value Changed" "(set! amp ${amp:value})"
borderWidth "0";
bottomPosition "800";
leftPosition "520";
maximum "5";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "880";
scaleHeight "20";
scaleWidth "300";
titleString "Amplitude";
topPosition "680";
value "2";
\end_figure\begin_figure {AtPlotter}
\figure_name "fred" 
\mapping "True"
bottomPosition "674";
leftPosition "6";
motionX "2.827044";
motionY "2.084328";
rightPosition "973";
title "Sine Wave";
topPosition "15";
xaxis.max "5";
xaxis.min "-5";
yaxis.max "5";
yaxis.min "-5";
\end_figure\begin_figure {XmPushButton}
\figure_name "plotsin" 
\mapping "True"
\callback "Activate" "(cds-plotter-xyplot \"$CDS_THIS_PAGE\" \"fred\" \"xy\" 
	(lambda (x) (* amp (sin (* x f)))) -5 5)              "
bottomPosition "980";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Click here to
Plot sin(x)";
leftPosition "634";
rightPosition "948";
topPosition "812";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
\mapping "True"
borderWidth "5";
bottomPosition "971";
fontList "*helvetica-*-r-*-*-20-*";
labelString "The function is plotted by a LISP instruction
(cds-plotter-xyplot \"plotter\" \"fred\" \"xy\" 
	(lambda (x) (* amp (sin (* x f)))) -5 5)";
leftPosition "0";
rightPosition "544";
topPosition "835";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "95";
fontList "8x13bold";
labelString "Click the left button on the
NEXT icon to go to the next page";
leftPosition "624";
rightPosition "999";
topPosition "2";
\end_figure
\end_screen
\end_page

\begin_page{other_goodies}
\title{Other Goodies}
\begin_screen

\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
\callback "Activate" "(cds-system \"xcalc &\")                    "
bottomPosition "320";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "xcalc";
leftPosition "80";
rightPosition "320";
topPosition "220";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
\callback "Activate" "(cds-system \"xterm &\")                    "
bottomPosition "440";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "xterm";
leftPosition "80";
rightPosition "320";
topPosition "340";
\end_figure

\begin_figure {XmPushButton}
\figure_name "jig" 
\callback "Activate" "(define x ${jig:leftPosition})
(define y ${jig:topPosition})
(define xmax 300)
(define xmin 50)
(define inc 5)
(while (< x xmax)
	(cds-figure-place \"$CDS_THIS_PAGE\" \"jig\" x y 300 300)
	(set! x (+ x inc)))
(while (> x xmin)
	(cds-figure-place \"$CDS_THIS_PAGE\" \"jig\" x y 300 300)
	(set! x (- x inc)))	
         "
armPixmap "calvin";
borderWidth "0";
bottomPosition "986";
highlightPixmap "calvin";
labelPixmap "calvin";
labelString "The Jig";
labelType "PIXMAP";
leftPosition "53";
rightPosition "353";
topPosition "686";
\end_figure

\begin_figure {AtPlotter}
\figure_name "bar1" 
*fastUpdate "True";
autoScale "False";
bottomPosition "712";
leftPosition "444";
motionX "-103.161765";
motionY "0.638298";
rightPosition "848";
title "Random Points";
topPosition "92";
xaxis.max "100";
xaxis.min "-100";
yaxis.max "10";
yaxis.min "-1";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
\callback "Activate" "(define (construct-list n f)
	(if (= n 0)
	     nil
	     (cons (f n) (construct-list (- n 1) f))))
(define pts (construct-list 9 (lambda (x) (* 10 (rnd)))))
(cds-plotter-barchart \"$CDS_THIS_PAGE\" \"bar1\" \"b1\" pts)                 "
bottomPosition "833";
fontList "*helvetica-*-r-*-*-20-*";
labelString "Plot Random Points";
leftPosition "482";
rightPosition "819";
topPosition "739";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
borderWidth "0";
bottomPosition "210";
fontList "*helvetica-*-r-*-*-20-*";
labelString "To see system calls executed
push any of the following two 
buttons below";
leftPosition "12";
rightPosition "402";
topPosition "52";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
borderWidth "0";
bottomPosition "644";
fontList "*helvetica-*-r-*-*-20-*";
labelString "To see the figure  below move
simply click on it.";
leftPosition "16";
rightPosition "425";
topPosition "551";
\end_figure

\begin_figure {XmScale}
\figure_name "mag" 
\callback "Drag" "(define (construct-list n f)
	(if (= n 0)
	     nil
	     (cons (f n) (construct-list (- n 1) f))))
(define pts (construct-list 9 (lambda (x) 
	  (* (get-resource 'mag 'value) (random)))))
(barchart 'b1 pts)                 "
borderWidth "0";
bottomPosition "203";
leftPosition "856";
maximum "10";
rightPosition "1107";
titleString "Mag";
topPosition "109";
value "6";
\end_figure
\end_screen
\end_page

\begin_page{what_is_cds}
\title{What is CDS?}
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled" 
borderWidth "0";
bottomPosition "217";
fontList "*times-*-r-*-*-20-*";
labelString "The Courseware Development System is an authoring 
system which is designed to allow professors to create
courseware.";
leftPosition "144";
rightPosition "928";
topPosition "120";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
borderWidth "0";
bottomPosition "686";
fontList "*times-*-r-*-*-20-*";
labelString "Using CDS, one can write hypertext applications
in almost any interpreted language.  This particular
application uses SCHEME as it's language, but CDS
applications can just as easily be written using 
BASIC, C-SHELL, MAPLE, MACSYMA, MATHEMATICA, PASCAL
etc.....";
leftPosition "136";
rightPosition "934";
topPosition "271";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "95";
fontList "8x13bold";
labelString "Click the left button on the
NEXT icon to go to the next page";
leftPosition "624";
rightPosition "999";
topPosition "2";
\end_figure
\end_screen
\end_page

\begin_page{untitled0}
\title{untitled0}
\begin_screen

\begin_figure {XmPushButton}
\figure_name "untitled" 
\callback "Activate" "emacs $CDS_CONFIG_DIR/cds.csh &"
bottomPosition "227";
labelString "Edit Cds.csh";
leftPosition "0";
rightPosition "688";
topPosition "129";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled" 
\callback "Activate" "#!/bin/csh -f -i
source $CDS_CONFIG_DIR/cds.csh"
bottomPosition "398";
labelString "Load CDS cshell compatibility package";
leftPosition "0";
rightPosition "687";
topPosition "300";
\end_figure
\end_screen
\end_page
