/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/XYErrorPlotP.h,v 3.1 91/01/03 17:29:35 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtXYErrorPlotP_h
#define _AtXYErrorPlotP_h    

#include <X11/IntrinsicP.h>

#ifdef _AtDevelopment_
#include "PlotP.h"
#include "XYPlotP.h"
#include "XYErrorPlot.h"
#else
#include <At/PlotP.h>
#include <At/XYPlotP.h>
#include <At/XYErrorPlot.h>
#endif 

typedef struct _AtXYErrorPlotClassPart {
  int bletch;
} AtXYErrorPlotClassPart;

typedef struct _AtXYErrorPlotClassRec {
  ObjectClassPart object_class;
  AtPlotClassPart plot_class;
  AtXYPlotClassPart xyplot_class;
  AtXYErrorPlotClassPart xyerrorplot_class;
} AtXYErrorPlotClassRec;

extern AtXYErrorPlotClassRec atXYErrorPlotClassRec;

typedef struct _AtXYErrorPlotPart {
  /* resources */
  double percentError;
  Boolean errorsArePercentages;
  Boolean errorsAreAbsolute;
  double *errorAbove;
  double *errorBelow;
  Dimension errorBarWidth;
  /* private data */
  Boolean valid;
  double *errabove, *errbelow;
  double *abovepts, *belowpts;
  XPoint *abovepix, *belowpix;
} AtXYErrorPlotPart;

typedef struct _AtXYErrorPlotRec {
  ObjectPart object;
  AtPlotPart plot;
  AtXYPlotPart xyplot;
  AtXYErrorPlotPart xyerrorplot;
} AtXYErrorPlotRec;


#endif /* _AtXYErrorPlotP_h */
