#include <X11/copyright.h>

/* $XConsortium: TekP.h,v 1.4 89/07/21 01:41:48 kit Exp $ */
/* Copyright	Massachusetts Institute of Technology	1987, 1988 */

#ifndef _TekP_h
#define _TekP_h

#include "Tek.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRTekResource "TekResource"

typedef struct {
    int empty;
} TekClassPart;

typedef struct _TekClassRec {
    CoreClassPart	core_class;
    TekClassPart	tek_class;
} TekClassRec;

extern TekClassRec tekClassRec;
typedef struct {
  int     x;
  int     y;
  int     fontsize;
  int     linetype;
} Tmodes;


#define TEK_FONT_LARGE 0
#define TEK_FONT_2 1
#define TEK_FONT_3 2
#define TEK_FONT_SMALL 3
#define TEKNUMFONTS 4

/* Actually there are 5 types of lines, but four are non-solid lines */
#define TEKNUMLINES     4


typedef struct {
    /* resources */
  XFontStruct *Tfont[TEKNUMFONTS];
  int         tobaseline[TEKNUMFONTS]; /* top to baseline for each font */
  char        *initial_font;          /* large, 2, 3, small */
  char        *string;
  int         string_pos;
  int         string_length;
  Boolean     string_done;
  Dimension   width, height;
  Pixel       foreground_pixel;
  char *      file;
    /* private state */
  int             cur_X;          /* current x                    */
  int             cur_Y;          /* current y                    */
  Tmodes          cur;            /* current tek modes            */
  int             margin;         /* 0 -> margin 1, 1 -> margin 2 */
  Boolean         pen_down;            /* current Tektronix pen 0=up, 1=dn */
  GC              TnormalGC;
  GC              TcursorGC;
  int             last_x, last_y;
  double scale;
  GC              linepat[TEKNUMLINES]; /* line patterns          */
  XPoint          **Tbox;         /* draw unselected cursor       */
  XSegment        *line_buffer;
  XSegment        *line_cur;
  int             line_num;
} TekPart;

typedef struct _TekRec {
    CorePart		core;
    TekPart	tek;
} TekRec;

#define CLEAR           0
#define TOGGLE          1


#endif /* _TekP_h */
