/* $Date: 92/02/16 08:40:58 $    $Revision: 1.3 $  by $Author: joe $  */
// CmCDS.cc - Main Driver for the Courseware Development System 

// Contact - sniyogi, maschaub

#include <CmCDS.h>
#include <CmFigureEditor.h>
#include <CmNavigator.h>
#include <CmMenu.h>
#include <CmModel.h>
#include <CmDialog.h>

#include <X11/cursorfont.h>
#include <Xm/DialogS.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/MainW.h>
#include <Xm/PanedW.h>
#include <Xm/Text.h>
#include <X11/Shell.h>
#include <ctype.h>

extern "C" {
#include <At/Help.h>
}

static void CmCdsHelpCancel(Widget, Widget helpshell, XtPointer) {
  XtPopdown(helpshell);
}

void CmCdsDisplayHelp(Widget, Widget helpshell, XtPointer) {
  XtPopup(helpshell, XtGrabNone); 
}

/********************************
 CDS CONSTRUCTOR 
  Requires: Command line arguments to be passed to toolkit initializer
  Modifies: argc and argv as specified in XtInitialize 
  Effects:
   Creates shell, rootwindow, menu with panes added, 
    work area, control box, outline
   Creates all non-lecture file widgets, global model, 
    navigator, which sets up the initial widgets, editor and switcher.
   Starts the main event loop
*********************************/
CmCDS::CmCDS(int *argc_p, char **argv) {  
  cout << "\nCDS - Athena Courseware Development System\n";
  cout << "Version " << VER << " Copyright 1990-1992 MIT\n";
  cout.flush();

  Version = VER;

  // Initialize Toolkit and get Application Contexts
  XtToolkitInitialize();
  app_context = XtCreateApplicationContext();

  // Open the display
  Display *display =
    XtOpenDisplay(app_context, NULL, "cds", "Cds", NULL, 0, 
		  (Cardinal *) argc_p, argv);

  // If we can't open the display then exit
  if (!display) {
    cerr << "Unable to connect to X server\n"
         << "Exiting .... \n";
    exit(1);
  }

  // Get the name of the configuration directory
  // If we can't get the configuration directory, then exit and explain
  // why.
  const char *cds_config_dir = getenv("CDS_CONFIG_DIR");
  if (!cds_config_dir) {
    cerr << "Cannot find figure configuration file\n"
         << "Please set the CDS_CONFIG_DIR environment variable\n"
         << "To the directory in which the CDS configuration files\n"
	 << "are kept\n\n"
         << "Do this by typing\n\n"
         << "setenv CDS_CONFIG_DIR <name of configuation directory>\n\n"
         << "at the commandline prompt\n";
    exit(1);
  }

  ConfigDir = cds_config_dir;

  // Create the toplevel shell
  toplevel = XtAppCreateShell("cds", "Cds", applicationShellWidgetClass,
			      display, NULL, 0);
  
  // Create pane widget
  Widget main_window = 
    XtCreateManagedWidget("main_window", xmMainWindowWidgetClass, toplevel,
			  NULL, 0);

  pane_widget = 
    XtCreateManagedWidget("pane_widget", xmPanedWindowWidgetClass, main_window,
			  NULL, 0);
  // Create the menu
  menu = new CmMenu(main_window); 
  menu->AddPane("File");
  menu->AddPane("Edit");
  menu->AddPane("Page");
  menu->AddPane("Options");
  menu->AddPane("Help");

  collections =
    XtCreateManagedWidget("collections", xmFormWidgetClass, pane_widget,
			  NULL, 0);
  workarea =
    XtVaCreateManagedWidget("collections", xmFormWidgetClass, pane_widget,
			    XmNfractionBase, 1000, NULL);

  XmMainWindowSetAreas(main_window, menu->GetMenubar(), NULL,
		       NULL, NULL, pane_widget);
    
  // Set Help Dialog Box from menu bar
  Widget helpshell = XtCreatePopupShell("helpshell", 
					transientShellWidgetClass,
					toplevel, NULL, 0);
  Widget help = XtCreateManagedWidget("general_help", 
				      atHelpWidgetClass, helpshell, NULL, 0);
  //  AtHelpShowSection(help, "Introduction");
  XtAddCallback(help, XtNdoneCallback, 
		(XtCallbackProc)CmCdsHelpCancel, (XtPointer)helpshell);
  menu->AddItem("Help", "cds_manual",
		(XtCallbackProc) CmCdsDisplayHelp, (XtPointer)helpshell);
  
  // Create CDS Modules
  editor = new CmFigureEditor(this, workarea);  
  model = new CmModel(this, pane_widget); 
  navigator = new CmNavigator(this, collections); 
  
  // Bring up window  
  XtRealizeWidget(toplevel);
  
  // Initial file open
  if (*argc_p > 1)
    navigator->OpenFile(argv[*argc_p - 1]);
}

/*************************
CmCDS Destructor
Modifies/Effects:
Destroys all CDS objects created in constructor.
 *************************/
CmCDS::~CmCDS() {
  delete editor;
  delete navigator;
  delete menu;
  delete model;
  if (toplevel)
    XtDestroyWidget(toplevel);
}

void CmCDS::StartEventLoop() {
  keep_looping = True;  
  XEvent event;
  while (keep_looping) {
      XtAppNextEvent(app_context, &event);
      XtDispatchEvent(&event);
    }
}

void CmCDS::StopEventLoop() {
  keep_looping = False;
}

void CmCDS::Error(const CmString  &error_message) {
  CmDialog* err= new CmDialog(toplevel, "Error", CMDIALOG_MODAL);
  err->XmDialogCreate(CMDIALOG_ERROR, error_message);
  err->XmDialogManage();
}

void CmCDS::ShowWaitCursor() {
  if (toplevel && XtIsRealized(toplevel)) {
    const Cursor wait = XCreateFontCursor(XtDisplay(toplevel), XC_watch);  
    XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel), wait);
    XSync(XtDisplay(toplevel), False);
    XFreeCursor(XtDisplay(toplevel), wait);
  }
}

void CmCDS::ShowNormCursor() {
  if (toplevel && XtIsRealized(toplevel)) {
    const Cursor norm = XCreateFontCursor(XtDisplay(toplevel), XC_left_ptr);
  
    XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel), norm);
    XSync(XtDisplay(toplevel), False);
    XFreeCursor(XtDisplay(toplevel), norm);
  }
}


/**********
CmString CmCDS::NextToken
takes: string - a CmString containing
effects: chops off the next token from the string passed
returns: the next token, if no next token return ""

Note: const char * means that the char being pointed to
is const, the pointer itself is still mutable.  If I wanted 
to make the pointer itself constant that would be char const *
 **********/

CmString CmCDS::NextToken(const char *& string) {
  const char *begin;
  while (*string && isspace(*string))
    string++;

  if (*string == '\000')
    return "";

  if (*string =='\"') {
    CmString next_token;
    string++;
    begin = string;
    while (1) {
      while (*string && *string != '\"')
	string++;
      if (!*string || *(string - 1) != '\\') {
	next_token += CmString(begin, string - begin);
	break;
      } else {
	next_token += CmString(begin, string - begin -1);
	next_token += '\"';
	string++;
	begin = string;
      }
    }
    string++;
    return next_token;
  } else {
    const char *begin = string;
    while (*string && !isspace(*string))
      string++;
    return CmString(begin, string-begin);
  }
}

