/* $Date: 92/02/15 05:11:54 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
#ifndef _CM_FIGURE_PARSER_H
#define _CM_FIGURE_PARSER_H

#include <CmParser.h>
#include <CDS.h>

class CmFigure;
class CmFigureEditor;

class CmFigureParser: private CmParser {
 private:
  CmFigureEditor *figure_editor;
  CmFigure *default_parent_cm_figure;
  CmFigure *current_cm_figure;
  CmString arg1_token, arg2_token, arg3_token;
  CmString string_token;
  int yylook();
  int yyparse();
  int yylex();
  int yywrap();
  CmBool string_input;
  int untitled_counter;
  CmBool collected_string;
 protected:
 public:
  CmFigureParser(CmFigureEditor*); // constructor
  ~CmFigureParser(); // destructor
  void Parse(CmFigure *, const CmString &);
  void Parse(CmFigure *, FILE *);
};

#endif
