%{
/* $Date: 92/02/16 08:44:38 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
%}
%{
#include <CmFigureParser.h>
#include <CDS.h>
#include <CmCDS.h>
#include <CmFigure.h>
#include <CmFigureEditor.h>
#include <CmFigureClass.h>

static void handle_quote(CmString &string) {
   string.Gsub("\\\"", "\"");
}
%}

%token BEGIN_FIGURE END_FIGURE
%token GROUP PARENT NAME MAPPING MESSAGE CALLBACK CONSTRUCTOR_TEXT SEMICOLON
%token STRING_TOKEN

%start figure_parser

%%

figure_parser: figure_parser_list;

figure_parser_list:	figure_definition
		| figure_parser_list figure_definition;

figure_definition: begin_figure figure_name figure_args end_figure;

begin_figure	: BEGIN_FIGURE GROUP {
  arg1_token = string_token; // to use in nonterminal figure_names code
};

figure_name	: NAME STRING_TOKEN {
    current_cm_figure = new CmFigure(
		  default_parent_cm_figure, 
		  string_token,
                  figure_editor->GetCmFigureClass(arg1_token),
                  figure_editor->CDSPtr());
};

figure_args	: figure_arg
		| figure_args figure_arg;

figure_arg	: STRING_TOKEN {
			arg1_token = string_token;
			handle_quote(arg1_token);
		}
		  STRING_TOKEN {
			handle_quote(arg1_token);
			handle_quote(string_token);
			current_cm_figure->ChangeResource(
			  arg1_token, 
			  string_token); }
		  SEMICOLON

		| MAPPING STRING_TOKEN {
			if (string_token == "True")
			  current_cm_figure->SetIsMapped(True);
			else
			  current_cm_figure->SetIsMapped(False);
		}

		| CALLBACK STRING_TOKEN {
			arg1_token = string_token;
		}
		  STRING_TOKEN {
			handle_quote(arg1_token);
			handle_quote(string_token);
			current_cm_figure->ChangeCallback(arg1_token,
							string_token);
		}

		| CONSTRUCTOR_TEXT STRING_TOKEN {
			handle_quote(string_token);
			cerr << "Figure Constructor Text is obsolete";
		}
			

		| PARENT STRING_TOKEN {
			current_cm_figure->
				SetParent(default_parent_cm_figure,
					  string_token);
			}
		| error;

end_figure	: END_FIGURE

%%

#ifdef SYSV
#define FILECHAR unsigned char
#else
#define FILECHAR char
#endif

void CmFigureParser::Parse(CmFigure *cm_figure, const CmString & string) {
  FILE fpscratch;
  fpscratch._flag = _IOREAD | _IOSTRG;
  fpscratch._ptr = fpscratch._base = (FILECHAR *) string.Chars();
  fpscratch._bufsiz = fpscratch._cnt = string.Length();
  string_input = 1;
  Parse(cm_figure, &fpscratch);
}

void CmFigureParser::Parse(CmFigure *cm_figure, FILE *file) {
  default_parent_cm_figure = cm_figure;
  SetParserInput(file);
  untitled_counter = 0;
  yyparse();
}

int CmFigureParser::yywrap() {
  if (string_input) {
    if (yyin->_ptr == yyin->_base + yyin->_bufsiz)
      return (1);
    else
      return (0);
  }
  else
    return(feof(yyin));
}

CmFigureParser::CmFigureParser(CmFigureEditor* we) {  
   figure_editor = we; 
}

CmFigureParser::~CmFigureParser() { 
}

