/* $Date: 92/03/10 15:36:08 $    $Revision: 1.3 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */

#include <CmFigureEditor.h>
#include <CmFigureClass.h>
#include <CmFigure.h>
#include <CmFigureRegistrar.h>
#include <CmDialog.h>
#include <CmCDS.h>
#include <CmStringMotif.h>
#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <X11/Shell.h>
#include <Xm/RowColumn.h>
#include <Xm/Command.h>
#include <Xm/MainW.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <Xm/List.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>

extern "C" {
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <At/FontFamily.h>
#include <At/Plot.h>
#include <At/Plotter.h>
#include <At/FBarchart.h>
#include <At/Cli.h>
#include <Cm/CmLabel.h>
#include <Tek.h>
}

#define NUMBER_WIDGET_CLASSES 16
static WidgetClass widget_class_list[50];

static void UpdateCallbackXmText(CmFigure *cm_figure, const CmString &,
				 XtPointer call_data){
  XmAnyCallbackStruct *a_callback =
    (XmAnyCallbackStruct *) call_data;
  if (a_callback->reason == XmCR_VALUE_CHANGED) {
    char *string = XmTextGetString(cm_figure->GetWidget());
    cm_figure->ChangeResource(XmNvalue, string);
    free(string);
  }
}

static void UpdateCallbackXmScale(CmFigure *cm_figure, const CmString &,
				  XtPointer call_data) {
  cm_figure->ChangeResourceInt(XmNvalue, 
			       ((XmScaleCallbackStruct *) call_data)->value);
}

static void UpdateCallbackXmToggleButton(CmFigure *cm_figure, const CmString &,
			     XtPointer call_data) {
  XmToggleButtonCallbackStruct *t_callback =
    (XmToggleButtonCallbackStruct *) call_data;
  if (t_callback->reason == XmCR_VALUE_CHANGED)
    cm_figure->ChangeResource(XmNset, t_callback->set ? "True" : "False");
}

static void UpdateCallbackAtPlotter(CmFigure *cm_figure, 
				    const CmString & reason,
				    XtPointer call_data) {
  char string[256];
  if (reason == XtNdragCallback) {
    PointStruct *rect = (PointStruct *) call_data;
    double xmin, xmax;
    double ymin, ymax;
    double y2min, y2max;
    double tmp;
    AtPlotterWidget w = (AtPlotterWidget) cm_figure->GetWidget();

    if (cm_figure->GetResource("canZoom") == "True") {
#define swap(x,y) {tmp = x; x = y; y = tmp;}
      
      xmin = rect[0].x;
      xmax = rect[1].x;
      if (xmin > xmax) {
	// zoom out
	swap(xmin, xmax);
	AtPlotterGetAxisBounds(w, &xmin, &xmax, &ymin, &ymax);
	double width = xmax - xmin;
	double height = ymax - ymin;
	xmax += width;
	xmin -= width;
	ymax += height;
	ymin -= height;
      
	
	cm_figure->ChangeResourceDouble("xaxis.min", xmin);
	cm_figure->ChangeResourceDouble("xaxis.max", xmax);
	cm_figure->ChangeResourceDouble("yaxis.min", ymin);
	cm_figure->ChangeResourceDouble("yaxis.max", ymax);
      
	AtPlotterSetAxisBounds(w, xmin, xmax, ymin, ymax);
	return;
      }
      ymin = rect[0].y;
      ymax = rect[1].y;
      if (ymin > ymax) swap(ymin, ymax);
      y2min = rect[0].y2;
      y2max = rect[1].y2;
      if (y2min > y2max) swap(y2min, y2max);
      
      cm_figure->ChangeResourceDouble("xaxis.min", xmin);
      cm_figure->ChangeResourceDouble("xaxis.max", xmax);
      cm_figure->ChangeResourceDouble("yaxis.min", ymin);
      cm_figure->ChangeResourceDouble("yaxis.max", ymax);
      
      AtPlotterSetAllAxisBounds(w, xmin, xmax, ymin, ymax, y2min, y2max);
#undef swap    
    }
  } else if (reason == XtNclickCallback) {
    PointStruct *point_struct = (PointStruct *) call_data;
    cm_figure->ChangeResourceDouble("clickX", point_struct->x);
    cm_figure->ChangeResourceDouble("clickY", point_struct->y);
  }  else if (reason == XtNmotionCallback) {
    PointStruct *point_struct = (PointStruct *) call_data;
    cm_figure->ChangeResourceDouble("motionX", point_struct->x);
    cm_figure->ChangeResourceDouble("motionY", point_struct->y);
  }
}

static void UpdateCallbackXmList(CmFigure *cm_figure, const CmString &,
				 XtPointer call_data) {
  XmListCallbackStruct *list_callback =
    (XmListCallbackStruct *) call_data;
  if (list_callback->reason == XmCR_SINGLE_SELECT ||
      list_callback->reason == XmCR_DEFAULT_ACTION ||
      list_callback->reason == XmCR_BROWSE_SELECT) {
    cm_figure->ChangeResource(XmNselectedItemCount, "1");
    CmString cm_string = XmToCmString(list_callback->item);
    cm_string.Gsub(",", "\\,");
    cm_figure->ChangeResource(XmNselectedItems, cm_string);
  } else {
    cm_figure->ChangeResource(XmNselectedItemCount, 
			      list_callback->selected_item_count);
    CmString cm_string;
    for (int i =0; i<list_callback->selected_item_count; i++) {
      CmString one_item = XmToCmString(list_callback->selected_items[i]);
      one_item.Gsub(",","\\,");
      cm_string += ",";
      cm_string += one_item;
    }
    cm_figure->ChangeResource(XmNselectedItems, cm_string);
  }
}	   

/************************************************************
 CmFigureEditor register_figure_classes
  Called by the constructor of CmFigureEditor
  Adds classes and keywords to the figure registrar
 ************************************************************/
void CmFigureEditor::register_figure_classes() { 
  widget_class_list[0] = widgetClass;
  widget_class_list[1] = xmPrimitiveWidgetClass;
  widget_class_list[2] = compositeWidgetClass;
  widget_class_list[3] = constraintWidgetClass;
  widget_class_list[4] = xmFormWidgetClass;
  widget_class_list[5] = cmLabelWidgetClass;
  widget_class_list[6] = xmLabelWidgetClass;
  widget_class_list[7] = xmToggleButtonWidgetClass;
  widget_class_list[8] = xmScaleWidgetClass;
  widget_class_list[9] = xmPushButtonWidgetClass;
  widget_class_list[10] = xmTextWidgetClass;
  widget_class_list[11] = atPlotterWidgetClass;
  widget_class_list[12] = tekWidgetClass;
  widget_class_list[13] = xmPushButtonGadgetClass;
  widget_class_list[14] = xmListWidgetClass;
  widget_class_list[15] = xmToggleButtonGadgetClass;
  widget_class_list[16] = xmLabelGadgetClass;
  widget_class_list[17] = NULL;

  // The following is a external procedure in the vimage library which 
  // needs to be called before the ImageWidget is created
  // This should be put in the ClassInitialize class of the SimpleImage
  // widget, but it's here until that is done.

  // The vimage procs will die on a color machine without the proc.
  load_widget_config();


  figure_registrar->GetCmFigureClass("XmText")->UpdateCallbackProc = 
    UpdateCallbackXmText;
  figure_registrar->GetCmFigureClass("XmScale")->UpdateCallbackProc =
    UpdateCallbackXmScale;
  figure_registrar->GetCmFigureClass("AtPlotter")->UpdateCallbackProc =
    UpdateCallbackAtPlotter;
  figure_registrar->GetCmFigureClass("XmToggleButton")->UpdateCallbackProc =
    UpdateCallbackXmToggleButton;
  figure_registrar->GetCmFigureClass("XmList")->UpdateCallbackProc =
    UpdateCallbackXmList;
}


Boolean CmFigureEditor::cmstring_to_boolean(const CmString &figure_class, const CmString &string) {
  XrmValue from, to;
  from.size = string.Length();
  from.addr = (char *) string.Chars();
  XtConvert(cds->TopLevel(), XtRString, &from, XtRBoolean, &to);
  if (to.addr != NULL)
    return *(to.addr);
  else {
    cerr << "Error in definition for figure class \"" << figure_class << "\"\n";
    return False;
  }
}

int CmFigureEditor::cmstring_to_cmdialog_item_type(const CmString &figure_class, const CmString &string) {
  if (string == "LABEL")
    return (CMDIALOG_LABEL);
  else if (string == "LIST")
    return (CMDIALOG_LIST);
  else if (string == "PUSHBUTTON")
    return (CMDIALOG_PUSHBUTTON);
  else if (string == "RADIOBOX")
    return (CMDIALOG_RADIOBOX);
  else if (string == "SCALE")
    return (CMDIALOG_SCALE);
  else if (string == "SEPARATOR")
    return (CMDIALOG_SEPARATOR);
  else if (string == "TEXTSTRING")
    return (CMDIALOG_TEXTSTRING);
  else if (string == "TOGGLEBUTTON")
    return (CMDIALOG_TOGGLEBUTTON);
  
  cerr << "Unable to convert \"" << string << "\" to dialog_type\n"
       << "Error in definition for figure class \"" << figure_class << "\"\n";
  return (CMDIALOG_TEXTSTRING);
}

WidgetClass CmFigureEditor::cmstring_to_widget_class(const CmString &string) {
  for(int i=0; widget_class_list[i]; i++) {
    if (string == widget_class_list[i]->core_class.class_name)
      return (widget_class_list[i]);
  }
  return (xmLabelWidgetClass);
}

void CmFigureEditor::load_widget_config() {
  char cbuffer[BUFSIZ];
  CmFigureClass *current_figure_class;
  CmString current_figure_class_name;
  char *buffer;
  const CmRegex white_space = "[ \n\t\r\v\f]*";


  CmString filename = CDSPtr()->ConfigDir + "/cds.widgets";

  FILE *file = fopen(filename.Chars(), "r");
  if (!file) {
    cerr << "Unable to open widget configuration file\n"
         << filename << "\n"
         << "Please set the environment variable CDS_CONFIG_DIR\n"
         << "to the name of the configuration directory, which\n"
         << "should contain the file cds.widgets.";
    exit(1);
  }
  while (!feof(file)) {
    fgets(cbuffer, BUFSIZ, file);
    buffer = cbuffer;
    CmString token = cds->NextToken(buffer);

// Make token lowercase
    token.Downcase();

// If it's a comment then go to the next line
    if (token.Matches(white_space) || token[0] == '#')
      continue;

// If it's a figure_class command, start another figure class
    if (token == "figure_class") {
      current_figure_class_name = cds->NextToken(buffer);
      if (!current_figure_class_name.Empty())
	current_figure_class = 
	  figure_registrar->RegisterWidgetClass(current_figure_class_name);
    } 

// Handle token "parent"
    else if (token == "parent") {
      CmString parent_figure_class_name = cds->NextToken(buffer);
      if (!parent_figure_class_name.Empty()) {
	current_figure_class->
	  SetSuperCmClass(figure_registrar->
			  GetCmFigureClass(parent_figure_class_name));
      }
    } 

// Handle token "display"
    else if (token == "display") {
      CmString display_widget_class_name = cds->NextToken(buffer);
      if (!display_widget_class_name.Empty()) {
	current_figure_class->
	  SetWidgetClass(cmstring_to_widget_class(display_widget_class_name));
      }
    } 

// Handle token "resource"
    else if (token == "resource") {
      CmString resource = cds->NextToken(buffer);
      CmString display_name = cds->NextToken(buffer);
      CmString default_value = cds->NextToken(buffer);
      int display_type = 
	cmstring_to_cmdialog_item_type(current_figure_class_name, 
				       cds->NextToken(buffer));
      Boolean major_resource = 
	cmstring_to_boolean(current_figure_class_name, cds->NextToken(buffer));

      if (current_figure_class)
	current_figure_class->AddResource(resource, display_name,
					  default_value, display_type, 
					  major_resource);
    } 

// Handle token "option"
    else if (token == "option") {
      CmString resource = cds->NextToken(buffer);
      CmString resource_option = cds->NextToken(buffer);
      if (current_figure_class)
	current_figure_class->AddOptionToResource(resource, resource_option);
    } 

// Handle token "callback"
    else if (token == "callback") {
      CmString callback = cds->NextToken(buffer);
      CmString display_name = cds->NextToken(buffer);
      if (current_figure_class)
	current_figure_class->AddCallback(callback, display_name);
    } 

// Handle token "palette"
    else if (token == "palette") {
      if (current_figure_class)
	figure_registrar->AddToPalette(current_figure_class);
    } else

// If all else fails print an error
      {
      cerr << "Unidentified command in widget configuration file "
	   << token << "\n";
    }
  }

// Close the file
  fclose(file);
}
