/* $Date: 92/02/16 08:45:23 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/**************************************
 CmList is a general linked list utility
 Contact:  maschaub
*****************************************/
#include <CmList.h>
#include <stream.h>

/***************************************************************
  CmList CmList
  Initializes all variables to NULL
***************************************************************/
CmList::CmList()
{
  num_elements = 0;
  first = NULL;
  last = NULL;
  
  cache_link = NULL;
  cache_index = 0;
}

/***************************************************************
  CmList ~CmList
  deletes all the links
***************************************************************/
CmList::~CmList()
{ Clear(); }

/***************************************************************
  CmList check_for_empty_list
  done before all accesses to the list to check if its empty or not
***************************************************************/
int CmList::check_for_empty_list() const { 
  if ( num_elements == 0 ) {
    cerr << "Attempt to get information from a null list\n";
    return 0;
  } else
    return 1;
}

/***************************************************************
  CmList GetLink
  Called by index procedures to get a link given the index
  Performs error checking as well
***************************************************************/
CmLink* CmList::GetLink(int index) {
  CmLink*link;
  int i;
  char search_forward;

  if (index < 0 || index >= num_elements) {
    cerr << "Attempt to access non-existent element number " << index << "\n";
    return first;
  }

  if (cache_link) {
    if (cache_index == index)
      return (cache_link);

    if (cache_index < index) {
      if ((num_elements - index -1) < (index - cache_index)) {
	link = last;
	i = num_elements -1;
	search_forward = 0;
      } else {
	link = cache_link;
	i = cache_index;
	search_forward = 1;
      }
    } else {
      if (index < (cache_index - index)) {
	link = first;
	i = 0;
	search_forward = 1;
      } else {
	link = cache_link;
	i = cache_index;
	search_forward = 0;
      }
    }
  } else {
    link = first;
    i = 0;
    search_forward = 1;
  }

  if (search_forward) {
    while (i++ < index)
      link = link->next;
  } else {
    while (i-- > index)
      link = link->prev;
  }
  cache_link = link;
  cache_index = index;
  return(link);
}

/***************************************************************
  CmList Append
  Adds a new link to the end of the list
***************************************************************/
void* CmList::Append(void *p){ 
  CmLink* new_link = new CmLink;
  new_link->data = p;
  new_link->next = NULL;
  if ( num_elements > 0 ) {
    last->next = new_link;
    new_link->prev = last;
    last = new_link;
  }
  else {
    new_link->prev = NULL;
    first = last = new_link;
  }
  num_elements++;
  return p;
}

/***************************************************************
  CmList Insert
  Adds a new link at position
***************************************************************/
void* CmList::Insert(void *p, const int location){
  if (location == num_elements)
    return(Append(p));

  CmLink* const next_link = GetLink(location);
  if (next_link == NULL)
    return(NULL);

  CmLink* const new_link = new CmLink;
  new_link->data = p;
  new_link->next = next_link;
  new_link->prev = next_link->prev;
    
  if (next_link->prev != NULL)
    next_link->prev->next = new_link;
  else
    first = new_link;
  next_link->prev = new_link;
  num_elements++;

  cache_link = NULL;
  cache_index = 0;
  return(p);
}

void CmList::InsertBefore(void *p) {
  if (current) {
    CmLink* const new_link = new CmLink;
    new_link->data = p;
    new_link->next = current;
    new_link->prev = current->prev;

    if (current->prev) 
      current->prev->next = new_link;
    else
      first = new_link;

    current->prev = new_link;
    num_elements++;
  }
  cache_link = NULL;
  cache_index = 0;
}

/***************************************************************
  CmList Remove
  Removes array number index from the list
***************************************************************/
void CmList::Remove(const int index) { 
  if(!check_for_empty_list()) 
    return;

  if ( num_elements == 1 ) {
    delete first;
    first = last = NULL;
  }  else 
    if (index == 0 ) {  // special case for removing the first element
      first = first->next;
      delete(first->prev);
      first->prev = NULL;
    }
    else 
      if ( index == num_elements - 1) { // special case for removing the last element
      last = last->prev;
      delete(last->next);
      last->next = NULL;
    }
    else {
      CmLink* link  = GetLink(index);
      (link->prev)->next = link->next; // normal removal of an element
      (link->next)->prev = link->prev;
      delete(link);
    }
  num_elements--;
  cache_index = 0;
  cache_link = NULL;
  current = NULL;
}
 

/***************************************************************
  CmList Replace
  Returns element index of the list
***************************************************************/
void* CmList::Replace(void* p, const int index) { 
  if( check_for_empty_list() == NULL ) return(NULL);
  CmLink* const link = GetLink(index);
  link->data = p;
  return(link->data);
}

/***************************************************************
  CmList Clear
  deletes all elements in the list
***************************************************************/
void CmList::Clear() {
  for(CmLink *f=first; f; f = f->next)
    delete f;

  cache_index = num_elements = 0;
  first = last = current = cache_link = NULL;
}
