/************************************************************
 CmModel.h - Model definition
 Contact: sniyogi
 ************************************************************/
#ifndef _CMMODEL
#define _CMMODEL

#include <CDS.h>
#include <stdarg.h>

class CmCDS;
class CmFigure;
class CmModel; 
class CmPage;
class CmModelEvaluator;
class CmModelConnection;

typedef void (*CmModelMethodProc)(const char *, CmModel *);

struct CmModelError {
  CmModelError& operator << (char *);
};

class CmModel {
private:
  CmCDS* cds;
  CmModelEvaluator *evaluator;
  CmModelConnection *connection;
  CmString command_buffer;
  int trace_level;
public:
  CmModel(CmCDS * const, const Widget);
  ~CmModel();

  CmModelError  ModelError;
  CmCDS* CDSPtr() { return cds; };


  void Evaluate();
  void Evaluate(CmString);
  void Error(const CmString &);

  void ReceiveInput();

  CmFigure *GetCmFigure(const char *&);
  CmFigure *GetCmFigure(CmPage*, const CmString &);

  void ParseModelCommands(CmString &);
  void FlushCommandBuffer();
  void FindMethod(const char *);

  void SetEcho(Boolean echo_set);
  void SetTraceLevel(int);
  friend void CmModelInterrupt(Widget, CmModel *, XtPointer);
};


 
// CmModel trace levels
// 0 - No output to model evaluator
// 1 - Output buffer only to model evaluator
// 2 - Output & command buffers to model evaluator
// 3 - Output & command buffers and debug info to evaluator
#endif


