/* $Date: 92/02/16 08:46:16 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*********************************************************
 CmNavigatorOutliner.cc - Navigator Code
 Contact: joe, maschaub
 *********************************************************/

#include <CDS.h>
#include <CmCDS.h>
#include <CmNavigatorOutliner.h>
#include <CmNavigator.h>
#include <CmPage.h>
#include <CmStringMotif.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/List.h>

/*** ANY BUTTON ***/

void CmNavigatorOutliner::update_outline() {
  CmInt i, j, list_location = 0;
  const CmInt list_size = item_list.ListSize();
  CmInt count = 0;
  CmString string;

  if (list_size > 0) {
    XmStringTable table = new XmString[list_size];
    for (i = 0; i < list_size; i++) {
      if (!get_item(i)->hidden) {
	if (get_item(i)->compressed == TRUE)
	  string = "*";
	else
	  string = " ";
	for (j=0; j < get_item(i)->level; j++)
	  string += "-";
	if (show_titles) {
	  CmPage *page = navigator->GetPageByName(get_item(i)->item);
	  if (page)
	    string += page->Title;
	  else
	    string += "<No Page>";
	} else
	  string += get_item(i)->item; 
 
	get_item(i)->location_on_list = list_location+1;
	table[list_location++] = CmToXmString(string);
      }
    }
    XtVaSetValues(any,
		  XmNitemCount, list_location,
		  XmNitems, table, NULL);
    number_of_displayed_items = list_location;
    for (i=0; i < list_location; i++)
      XmStringFree(table[i]);
    delete table;
  }  else {
    number_of_displayed_items = 0;
    XtVaSetValues(any, 
		  XmNitemCount, 0, NULL);
  }
}

/*************************************
 CmNavigator constructor
  Adds New, Open,Save, Save As, Exit, Append Page and Remove Page to 
  menu with callbacks to procedures here
**************************************/
CmNavigatorOutliner::CmNavigatorOutliner(CmNavigator *nav,
					 Widget widget) {
  navigator = nav;
  any = widget;
  counter = 0;
  current_item = -1;
  current_level = 0;
  number_of_displayed_items = 0;
  show_titles = TRUE;
}

/*************************************
 CmNavigatorOutliner destructor
  deletes the parser
  destroys the file_box widget
**************************************/
CmNavigatorOutliner::~CmNavigatorOutliner() {
  for (item_list.MoveFirst(); item_list.HasCurrent(); item_list.MoveNext())
    delete (CmOutlineItem *) item_list.GetCurrent();
}

/*************************************
 CmNavigator AppendOutlineItem
  Adds a child to the current page and sets the current page to that new child
**************************************/
void CmNavigatorOutliner::AppendItemToOutline(const CmString &string) {
  CmOutlineItem *new_item = new CmOutlineItem;
  new_item->item = string;
  item_list.Append((void *) new_item);
}

void CmNavigatorOutliner::AddItemToOutline(const CmString &page_name, 
					   const CmString &where) {
  for (int i=0; i < item_list.ListSize(); i++)
    if (get_item(i)->item == page_name) {
      delete get_item(i);
      item_list.Remove(i);
      if (current_item > i)
	current_item--;
    }
  
  int place = (current_item >= 0) ? current_item : 0;
  CmOutlineItem *new_item = new CmOutlineItem;
  new_item->item = page_name;
  if (where == "first")
    place = 0;
  if (where == "last")
    place = item_list.ListSize();
  if (where == "before")
    place = current_item;
  if (where == "after")
    place = current_item + 1;

  item_list.Insert(new_item, place);
  if (current_item >= place)
    current_item++;
  update_outline();
  highlight_outline_item();
}
  
  
void CmNavigatorOutliner::highlight_outline_item() {
  if (current_item >= 0) {
    XmListSetPos(any, get_item(current_item)->location_on_list);
    XmListSelectPos(any, get_item(current_item)->location_on_list, False);
  }
}

CmInt CmNavigatorOutliner::get_index_of_page(const CmString &name) {
  int i;
  if (name.Empty())
     return current_item;
  for (item_list.MoveFirst(), i=0; 
       item_list.HasCurrent(); 
       item_list.MoveNext(), i++)
    if (((CmOutlineItem *) item_list.GetCurrent())->item == name)
      return(i);
  return(-1);
}

/*************************************
 CmNavigator output
**************************************/
ostream& operator << (ostream &stream, CmNavigatorOutliner * outliner) {
  // write out version number
  stream << "\\CDS_Version \"" << outliner->navigator->cds->Version.Chars() << "\"\n\n";

  stream << "\\begin_outline\n";
  
  for(outliner->item_list.MoveFirst();
      outliner->item_list.HasCurrent();
      outliner->item_list.MoveNext())
    stream << ((CmOutlineItem *) outliner->item_list.GetCurrent());

  stream << "\\end_outline\n\n";
  return(stream);
}

void CmNavigatorOutliner::ShowTitles(Boolean use) {
  show_titles = use;
  update_outline();
  if (item_list.ListSize())
    highlight_outline_item();
}

static CmString empty = "";

const CmString & CmNavigatorOutliner::GetPageName(const CmString &command,
						  const CmString &page_name) {
  if (current_item == -1)
    current_item = 0;
  CmString compare_string = command;

  switch(compare_string[0]) {
  case 'c':
    if (command == "clear") {
      const int list_size = item_list.ListSize();
      for (int i=0; i< list_size; i++)
	delete (CmOutlineItem *) item_list[i];
      item_list.Clear();
      current_item = -1;
      update_outline();
      return empty;
    }
    if (command == "change_to")
      get_item(current_item)->item = page_name;
    break;
  case 'f':
    if (command == "first")
      current_item = 0;
    break;
  case 'g':
    if (command == "goto")
      current_item = get_index_of_page(page_name);
    break;
  case 'l':
    if (command == "last")
      current_item = item_list.ListSize() -1;
    break;
  case 'n': 
    if (command == "next" && current_item < item_list.ListSize() - 1)
      current_item++;
    break;
  case 'p':
    if (command == "prev" && current_item > 0)
      current_item--;
    break;
  case 'r':
    if (command == "remove") {
      if (item_list.ListSize() > 1) {
	int remove_item = get_index_of_page(page_name);
	if (remove_item == -1)
	  return empty;
	delete (CmOutlineItem *) item_list[remove_item];
	item_list.Remove(remove_item);
	if (current_item > remove_item)
	  current_item--;
	if (current_item >= item_list.ListSize())
	  current_item = item_list.ListSize() -1;
	update_outline();
      } else 
	return empty;
    }
    break;
  case 'u':
    if (command == "up") {
      const CmInt current_level = get_item(current_item)->level;
      for (int i = current_item - 1; i>=0 ; i--) 
	if (get_item(i)->level < current_level)
	  break;
      current_item = i;
    }
    if (command == "update")
      update_outline();
    break;
  }
    
  highlight_outline_item();
  if (current_item >= 0)
    return get_item(current_item)->item;

  return page_name;
}

const CmString &CmNavigatorOutliner::GetPageName(const CmString &command,
					  const int position_on_list) {
  if (command == "any")
    for(int i=0; i < item_list.ListSize(); i++)
      if (get_item(i)->location_on_list == position_on_list &&
	  get_item(i)->hidden == FALSE) {
	current_item = i;
	return get_item(current_item)->item;
      }

  return empty;
} 


ostream& operator << (ostream &stream, CmOutlineItem *const output_item) {
  stream << "\"" << output_item->item << "\"\n";
  return(stream);
}


