\CDS_Version "2.00.00"

\begin_outline
"title_page"
"three_main_screens"
"basic_queuing_system_info"
"Basic_Queuing_System"
"queue_convergence_info"
"Queue_Convergence"
"queue_simulator_info"
"Queue_Simulator"
"the_end"
\end_outline


\begin_page{title_page}
\title{Title Page}
\page_constructor_text "#!scheme
(load \"$CDS_CONFIG_DIR/cds.scheme\")"
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "0";
bottomPosition "688";
labelPixmap "mit-logo";
labelType "PIXMAP";
leftPosition "0";
rightPosition "992";
topPosition "112";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "0";
bottomPosition "800";
fontList "*lucida-*-r-*-*-24-*";
labelString "QUEUING THEORY:";
leftPosition "0";
rightPosition "992";
topPosition "752";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "0";
bottomPosition "896";
fontList "*times-*-r-*-*-24-*";
labelString "All you ever wanted to know (and more)
about waiting in lines.";
leftPosition "0";
rightPosition "992";
topPosition "800";
\end_figure
\end_screen
\end_page

\begin_page{Basic_Queuing_System}
\title{Basic Queuing System}
\page_constructor_text "(define qlength 0)
(define numtrials 0)
(define birth ( / ${s_birth:value} 100))
(define death ( / ${s_death:value} 100))
(define bdratio (/ birth death))
(define trial 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdratio\" \"labelString\" bdratio)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials\" \"labelString\" numtrials)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength\" \"labelString\" qlength)
(define dth #f)
(define brth #f)
(define figure-list '(\"cust0\" \"cust1\" \"cust2\" \"cust3\" \"cust4\" \"cust5\"))
(map (lambda (x) (cds-figure-hide \"$CDS_THIS_PAGE\" x)) figure-list)"
\begin_screen

\begin_figure {XmLabel}
\figure_name "yoda" 
borderWidth "0";
bottomPosition "560";
labelPixmap "yoda";
labelType "PIXMAP";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "160";
topPosition "224";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
borderWidth "3";
bottomPosition "208";
labelPixmap "junkXmLabel";
labelType "PIXMAP";
leftPosition "0";
rightPosition "992";
topPosition "192";
\end_figure

\begin_figure {CmLabel}
\figure_name "untitled3_CmLabel0" 
borderWidth "0";
bottomPosition "48";
fontSize "medbig";
label "Please select one of the following:";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled3_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"textbox1\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pushokay\")                       "
bottomPosition "174";
fontList "*times-*-r-*-*-20-*";
labelString "Why am I looking at
      this screen?";
leftPosition "16";
rightPosition "223";
topPosition "80";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_numtrials" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "399";
fontList "*lucida-*-r-*-*-24-*";
labelString "0";
leftPosition "149";
rightPosition "322";
topPosition "305";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_queuelength" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "491";
fontList "*lucida-*-r-*-*-24-*";
labelString "0";
leftPosition "173";
rightPosition "191";
topPosition "397";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_bdratio" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "302";
fontList "*lucida-*-r-*-*-24-*";
labelString "31";
leftPosition "138";
rightPosition "332";
topPosition "208";
\end_figure

\begin_figure {XmScale}
\figure_name "s_birth" 
\callback "Value Changed" "(set! birth (/ ${s_birth:value} 100))
(set! bdratio (/ birth death))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdratio\" \"labelString\" bdratio)
(if (> (+ birth death) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda\") )
(if (> (+ birth death) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") )
(if (<= (+ birth death) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda\") )
(if (<= (+ birth death) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") )               "
bottomPosition "334";
decimalPoints "2";
leftPosition "480";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "768";
titleString "B, Probability of Birth (Arrival)";
topPosition "223";
value "62";
\end_figure

\begin_figure {XmScale}
\figure_name "s_death" 
\callback "Value Changed" "(define death (/ ${s_death:value} 100))
(define bdratio (/ birth death))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdratio\" \"labelString\" bdratio)
(if (> (+ birth death) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda\"))
(if (> (+ birth death) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\"))
(if (<= (+ birth death) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda\"))
(if (<= (+ birth death) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\"))                   "
bottomPosition "480";
decimalPoints "2";
leftPosition "480";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "768";
titleString "D, Probability of Death (Departure)";
topPosition "368";
value "2";
\end_figure

\begin_figure {CmLabel}
\figure_name "textbox1" 
bottomPosition "992";
label "The purpose of this page is acquaint you with a physical representation of a basic queuing system.  
      
Queues are lines in which customers wait for service, but they may vary in several ways.  For example, they may:
     
A) Have a limit to the number of customers that may wait in the queue at any one time.
B) Have one or more servers attending to the customers.
C) Have the probability of the next arrival into the queue be dependent on the current queue length.
    
Throughout this program, all queues have one server and the probability of arrival of the next customer is independent 
of the current length of the queue.  A maximum queue length may be imposed, however.
     
         
A couple of definitions to keep in mind are:
      
A) The @i(state of the queue): the total number of customers in the queuing system, including those being served.
B) The @i(length of the queue): the total number of people in the queuing system minus the number currently being served.
    
   
Lastly, a few constraints imposed by probability law should be noted.  They are:
         
A) The sum of the probabilities of birth (arrival) and death (departure) for any one trial @b(cannot exceed one).
B) The probability of birth is the same regardless of queue length unless an imposed maximum length has 
      been reached, in which case it is zero.
C) Likewise, the probability of death is independent of queue length but is zero in queue state zero.";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pushokay" 
\callback "Activate" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"textbox1\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"textbox12\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"pushokay\")     
                 "
bottomPosition "960";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "OK";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "944";
topPosition "864";
\end_figure

\begin_figure {CmLabel}
\figure_name "warningtext" 
borderWidth "10";
bottomPosition "560";
fontSize "biggest";
label "The sum of birth and death 
probabilities cannot exceed one.   
      
Please readjust the sliders to 
correct this situation!!";
leftPosition "144";
mappedWhenManaged "False";
rightPosition "464";
topPosition "224";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled3_XmPushButton0" 
\callback "Activate" "(define qlength 0)
(define numtrials 0)
(define birth (/ ${s_birth:value} 100))
(define death (/ ${s_death:value} 100))
(define bdratio (/ birth death))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdratio\" \"labelString\" bdratio)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials\" \"labelString\" numtrials)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength\" \"labelString\" qlength)
(define true (= 1 1)) 
(define brth nil)
(define dth nil)
(cds-figure-hide \"$CDS_THIS_PAGE\" \"cust0\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"cust1\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"cust2\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"cust3\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"cust4\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"cust5\")            "
bottomPosition "176";
fontList "*times-*-r-*-*-20-*";
labelString "Reset the
Queuing System";
leftPosition "752";
rightPosition "992";
topPosition "80";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled3_XmPushButton0" 
\callback "Activate" "(set! numtrials (1+ numtrials))
(set! brth (and (< (rnd) birth) (< qlength 6)))
(set! dth (and (< (rnd) death) (> qlength 0)))
(if brth 
	(begin (cds-figure-show \"$CDS_THIS_PAGE\" (list-ref figure-list qlength))
		(set! qlength (1+ qlength))))
(if dth 
	(begin (set! qlength (1- qlength))
		(cds-figure-hide \"$CDS_THIS_PAGE\" (list-ref figure-list qlength))))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials\" \"labelString\" numtrials)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength\" \"labelString\" qlength)"
bottomPosition "176";
fontList "*times-*-r-*-*-20-*";
labelString "Run a Single Trial for
the Queuing System";
leftPosition "464";
rightPosition "736";
topPosition "80";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "304";
fontList "*lucida-*-r-*-*-24-*";
labelString "B/D Ratio: ";
leftPosition "0";
rightPosition "144";
topPosition "208";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "491";
fontList "*lucida-*-r-*-*-24-*";
labelString "Queue State: ";
leftPosition "0";
rightPosition "174";
topPosition "397";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "400";
fontList "*lucida-*-r-*-*-24-*";
labelString "# of Trials: ";
leftPosition "0";
rightPosition "160";
topPosition "304";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
bottomPosition "864";
labelPixmap "drake";
labelType "PIXMAP";
leftPosition "32";
rightPosition "176";
topPosition "528";
\end_figure

\begin_figure {CmLabel}
\figure_name "untitled3_CmLabel0" 
borderWidth "0";
bottomPosition "960";
label "Line for Students 
     Awaiting  Service
         Starts Here";
leftPosition "464";
rightPosition "656";
topPosition "864";
\end_figure

\begin_figure {CmLabel}
\figure_name "untitled3_CmLabel0" 
borderWidth "0";
bottomPosition "960";
label "Student Currently
   Being Served";
leftPosition "176";
rightPosition "336";
topPosition "864";
\end_figure

\begin_figure {CmLabel}
\figure_name "untitled3_CmLabel0" 
borderWidth "0";
bottomPosition "992";
label "Server:
Prof. Drake,
Dispenser
of Knowledge";
leftPosition "32";
rightPosition "160";
topPosition "864";
\end_figure

\begin_figure {XmLabel}
\figure_name "cust0" 
borderWidth "0";
bottomPosition "864";
labelPixmap "student1";
labelType "PIXMAP";
leftPosition "176";
rightPosition "448";
topPosition "592";
\end_figure

\begin_figure {XmLabel}
\figure_name "cust1" 
borderWidth "0";
bottomPosition "864";
labelPixmap "student1";
labelType "PIXMAP";
leftPosition "448";
mappedWhenManaged "False";
rightPosition "768";
topPosition "592";
\end_figure

\begin_figure {XmLabel}
\figure_name "cust2" 
borderWidth "0";
bottomPosition "864";
labelPixmap "student2";
labelType "PIXMAP";
leftPosition "448";
mappedWhenManaged "False";
rightPosition "768";
topPosition "592";
\end_figure

\begin_figure {XmLabel}
\figure_name "cust3" 
borderWidth "0";
bottomPosition "864";
labelPixmap "student3";
labelType "PIXMAP";
leftPosition "448";
mappedWhenManaged "False";
rightPosition "768";
topPosition "592";
\end_figure

\begin_figure {XmLabel}
\figure_name "cust4" 
borderWidth "0";
bottomPosition "864";
labelPixmap "student4";
labelType "PIXMAP";
leftPosition "448";
mappedWhenManaged "False";
rightPosition "768";
topPosition "592";
\end_figure

\begin_figure {XmLabel}
\figure_name "cust5" 
borderWidth "0";
bottomPosition "864";
labelPixmap "student5";
labelType "PIXMAP";
leftPosition "448";
mappedWhenManaged "False";
rightPosition "768";
topPosition "592";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled3_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"textbox12\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pushokay\")"
bottomPosition "176";
fontList "*times-*-r-*-*-20-*";
labelString "How do I use
this screen?";
leftPosition "240";
rightPosition "448";
topPosition "80";
\end_figure

\begin_figure {CmLabel}
\figure_name "textbox12" 
bottomPosition "992";
label "This screen runs trials one by one and shows students entering and leaving a queue that is limited by physical
          limitations to a maximum length of 5. (Which means the queue may be in one of @i(six) states , zero to five.)
     
          There are sliders and pushbuttons that may be used to operate this demo: 
     
          A) The sliders determine the probabilities of birth (arrival) and death (departure) for any 
                 trial that is simulated.  The sum of these probabilities may never exceed one.  They may 
                 be changed at any time during the demo however.
     
          B) The pushbuttons are used to either run a trial or reset the queue.  If a trial is run, a new 
                 student may or may not enter or leave the queue.  The reset button removes all students 
                who may be in the queue and resets the trial counter.         
        
          Notice that as the sliders are changed, the @b(birth-death ratio) also changes.  In basic queues 
          of this sort, this is a very important parameter.  Note how as it is increased, the queue length tends 
          to be longer on the average, and as it is decreased the queue tends to shrink more quickly.  ";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {CmLabel}
\figure_name "untitled3_CmLabel0" 
borderWidth "5";
bottomPosition "864";
label "WARNING!!!!!
     CONSTRUCTION
        MEN AT WORK
(i.e. Kids, you can't wait 
 here to see Prof. Drake)";
leftPosition "768";
rightPosition "992";
topPosition "592";
\end_figure
\end_screen
\end_page

\begin_page{Queue_Convergence}
\title{Queue Convergence}
\page_constructor_text "(define (zeros number_zeros)
   (if (> number_zeros 0)
       (cons 0 (zeros (1- number_zeros))))
       '())

(define (geometric prob num_elem)
	(cons 0.0 (recurse-geometric prob (1- num_elem) prob)))
(define (recurse-geometric prob num_elem running)
	(if (> num_elem 0)
	    (cons running
	           (recurse-geometric prob (1- num_elem)
				(* running prob)))
		'()))

(define emptylist (zeros 30))
(define qlength2 0)
(define numtrials2 0)
(define curlist2 emptylist)
(define outlist2 emptylist)
(define birth2 0)
(define death2 0)
(define bdratio2 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdratio2\" \"labelString\" bdratio2) 
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)

(define (set-barchart-resource plot name value)
    (cds-plotter-set-plot-resource \"$CDS_THIS_PAGE\" \"P_queues\" plot name value))



(define (graph-steady-state)
   (define prob bdratio2)
   (if (and (= hide 0) (>= prob 0) (<= prob 1))
      (cds-plotter-barchart \"$CDS_THIS_PAGE\" \"P_queues\" \"steady_state\" 
         (cdr (geometric prob 31))))
   (set-barchart-resource \"steady_state\" \"numPoints\" 30)
   (set-barchart-resource \"steady_state\" \"xMin\" 0)
   (set-barchart-resource \"steady_state\" \"xMax\" 29)
   (set-barchart-resource \"steady_state\" \"density\" .8)
   (set-barchart-resource \"steady_state\" \"shading\" \"true\") 
   (set-barchart-resource \"steady_state\" \"pattern\" \"AtGRAY1\"))

(define (clear-steady-state)
   (cds-plotter-delete-plot \"$CDS_THIS_PAGE\" \"P_queues\" \"steady_state\"))

(define (graph-transient-state)
   '())

(define (plotter-yaxis ymax)
   (cds-plotter-axis \"$CDS_THIS_PAGE\" \"P_queues\" -1 30 0 ymax)
)

(define (reset-axis ymax)
   (plotter-yaxis ymax)
   (graph-steady-state)
   (graph-transient-state))

;(set-barchart-resource \"transient_state\" \"numPoints\" 30)
;(set-barchart-resource \"transient_state\" \"xMin\" 0)
;(set-barchart-resource \"transient_state\" \"xMax\" 29)
;(set-barchart-resource \"transient_state\" \"density\" .3)



"
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
borderWidth "3";
bottomPosition "208";
labelPixmap "junkXmLabel";
labelType "PIXMAP";
leftPosition "0";
rightPosition "992";
topPosition "192";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"textbox2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pushokay\")                                        "
bottomPosition "176";
fontList "*times-*-r-*-*-20-*";
labelString "Why am I looking at
this screen?";
leftPosition "0";
rightPosition "224";
topPosition "80";
\end_figure

\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
borderWidth "0";
bottomPosition "64";
fontSize "medbig";
label "Please select one of the following:";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {AtPlotter}
\figure_name "P_queues" 
autoScale "False";
bottomPosition "630";
clickX "6.358799";
clickY "0.593548";
leftPosition "10";
motionX "15.897541";
motionY "0.909677";
rightPosition "1000";
title "Steady State Queue in Light Gray, Transient Queue in Black";
topPosition "231";
xaxis.label "Queue State";
xaxis.max "30";
xaxis.min "-1";
yaxis.label "Prob(Queue State)";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_queuelength2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "832";
fontList "*lucida-*-r-*-*-24-*";
labelString "0";
leftPosition "720";
rightPosition "832";
topPosition "768";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_numtrials2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "768";
fontList "*lucida-*-r-*-*-24-*";
labelString "0";
leftPosition "784";
rightPosition "928";
topPosition "704";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_bdratio2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "704";
fontList "*lucida-*-r-*-*-24-*";
labelString "0";
leftPosition "688";
rightPosition "832";
topPosition "640";
\end_figure

\begin_figure {XmScale}
\figure_name "s_birth2" 
\callback "Value Changed" "(define birth2 (/ ${s_birth2:value} 100))
(define bdratio2 (/ birth2 death2))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdratio2\" \"labelString\" bdratio2)
(graph-steady-state)
(if (> (+ birth2 death2) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda2\") )
(if (> (+ birth2 death2) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") ) 
(if (<= (+ birth2 death2) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda2\") )
(if (<= (+ birth2 death2) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") ) 
(if (>= birth2 death2)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda3\") )
(if (>= birth2 death2)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birth2 death2)  
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda3\") )
(if (< birth2 death2)  
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") )  "
bottomPosition "894";
decimalPoints "2";
leftPosition "240";
mappedWhenManaged "False";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "511";
titleString "B, Probability of Birth (arrival)";
topPosition "799";
value "31";
\end_figure

\begin_figure {XmScale}
\figure_name "s_death2" 
\callback "Value Changed" "(define death2 (/ ${s_death2:value} 100))
(define bdratio2 (/ birth2 death2))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdratio2\" \"labelString\" bdratio2)
(graph-steady-state)
(if (> (+ birth2 death2) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda2\") )
(if (> (+ birth2 death2) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") ) 
(if (<= (+ birth2 death2) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda2\") )
(if (<= (+ birth2 death2) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") ) 
(if (>= birth2 death2)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda3\") )
(if (>= birth2 death2)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birth2 death2)  
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda3\") )
(if (< birth2 death2)  
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") )  "
bottomPosition "992";
decimalPoints "2";
leftPosition "240";
mappedWhenManaged "False";
minimum "1";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "512";
titleString "D, Probability of Death (departure)";
topPosition "896";
value "58";
\end_figure

\begin_figure {CmLabel}
\figure_name "warningtext" 
borderWidth "10";
bottomPosition "992";
fontSize "biggest";
label "The sum of birth and death 
         probabilities cannot 
         exceed one.   
     
         Please readjust the sliders 
         to correct this situation!!";
leftPosition "656";
mappedWhenManaged "False";
rightPosition "992";
topPosition "624";
\end_figure

\begin_figure {CmLabel}
\figure_name "warntext" 
borderWidth "10";
bottomPosition "992";
fontSize "biggest";
label "The birth probability must be
         less than the death probability.  
     
        Please readjust the sliders to  
        correct this situation!!";
leftPosition "656";
mappedWhenManaged "False";
rightPosition "992";
topPosition "624";
\end_figure

\begin_figure {CmLabel}
\figure_name "textbox2" 
bottomPosition "992";
fontSize "big";
label "The purpose of this screen is to show how many trials have to be simulated before the
steady-state is approached.  The queue used in this demo has one server and is of 
infinite length.  
      
Given the birth-death ratio, the program plots the steady-state queue state distribution
in light gray.  As trials are simulated, the simulated transient queue's state distribution is 
superimposed in black over the steady-state distribution.  The birth-death ratio is a major
deteriminant in the number of trials it takes for a queue to converge.  As you change this 
ratio, note that:
     
A)  Even when the ratio is relatively low, several thousands of trials are needed to 
        satisfactorily converge.
B)  As this ratio approaches one, the number of trials needed for the queue to 
       converge can easily  surpass one million.
C)  This demo does not allow birth-death ratios greater than or equal to one 
        because a geometric distribution is used to plot the steady-state and it 
        cannot receive invalid values.  (Even if the ratio was allowed to exceed one, 
        since the queue is of infinite length, the first thirty states would shortly 
        become insignificant and the barchart would appear empty.)";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pushokay" 
\callback "Activate" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"textbox2\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"textbox22\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"pushokay\")"
bottomPosition "960";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "OK";
leftPosition "800";
mappedWhenManaged "False";
rightPosition "944";
topPosition "864";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_reset" 
\callback "Activate" "(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"P_queues\" \"yaxis.max\" 1)
(clear-steady-state)
;(barchart \"transient_state\" emptylist)        
(define numtrials2 0)
(define qlength2 0)
(define curlist2 emptylist)
(define outlist2 emptylist)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)                 
(cds-figure-hide \"$CDS_THIS_PAGE\" \"pb_undo\")"
bottomPosition "734";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Reset Demo";
leftPosition "16";
mappedWhenManaged "False";
rightPosition "208";
topPosition "640";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "768";
fontList "*lucida-*-r-*-*-24-*";
labelString "Total # of Trials: ";
leftPosition "544";
rightPosition "784";
topPosition "704";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "704";
fontList "*lucida-*-r-*-*-24-*";
labelString "B/D Ratio: ";
leftPosition "544";
rightPosition "688";
topPosition "640";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "832";
fontList "*lucida-*-r-*-*-24-*";
labelString "Queue State: ";
leftPosition "544";
rightPosition "720";
topPosition "768";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_menu" 
borderWidth "0";
bottomPosition "800";
fontList "7x13bold";
labelString "Hit Number of Trials you
currently want to run:";
leftPosition "16";
mappedWhenManaged "False";
rightPosition "208";
topPosition "752";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_pickrun" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_reset\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_one\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_ten\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hundred\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_thousand\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_tenthousand\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hundredthou\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"l_menu\") 
(cds-figure-show \"$CDS_THIS_PAGE\" \"l_run\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_halve\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hidesteady\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_double\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_birth2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_death2\") 
(define hide 0)
(graph-steady-state)"
bottomPosition "176";
fontList "*times-*-r-*-*-20-*";
labelString "Run the Queue Convergence
Demonstration";
leftPosition "512";
rightPosition "992";
topPosition "80";
\end_figure

\begin_figure {XmLabel}
\figure_name "l_run" 
bottomPosition "176";
labelString "Push the appropriate button in the lower left-hand corner of the screen.
Also, you may adjust the birth and death probabilities whenever you wish.";
leftPosition "512";
mappedWhenManaged "False";
rightPosition "992";
topPosition "80";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_hundred" 
\callback "Arm" "(define newlist2 (queue_list 1 qlength2 qlength2 100 numtrials2 30 1000 birth2 birth2 death2 curlist2 curlist2))
(define oldnumtrials2 numtrials2)
(define oldqlength2 qlength2)
(define oldcurlist2 curlist2)
(define oldoutlist2 outlist2)
(define oldsslist sslist)
(define numtrials2 (cadr newlist2))
(define qlength2 (cxr adddadd newlist2))
(define curlist2 (cxr adddd newlist2))
(define outlist2 (cxr adddddd newlist2))
(define prob (- 1 bdratio2))
(define geomlist (geometric prob 31))
(define sslist (cdr geomlist))
(if (= hide 0) (barchart \"steady_state\" sslist))
(barchart \"transient_state\" outlist2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)
 (cds-figure-show \"$CDS_THIS_PAGE\" \"pb_undo\")"
bottomPosition "928";
fontList "*times-*-r-*-*-20-*";
labelString "100";
leftPosition "16";
mappedWhenManaged "False";
rightPosition "112";
topPosition "864";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_ten" 
\callback "Arm" "(define newlist2 (queue_list 1 qlength2 qlength2 10 numtrials2 30 1000 birth2 birth2 death2 curlist2 curlist2))
(define oldnumtrials2 numtrials2)
(define oldqlength2 qlength2)
(define oldcurlist2 curlist2)
(define oldoutlist2 outlist2)
(define oldsslist sslist)
(define numtrials2 (car (cdr newlist2)))
(define qlength2 (car (cdr (cdr (cdr (car (cdr (cdr newlist2))))))))
(define curlist2 (car (cdr (cdr (cdr (cdr newlist2))))))
(define outlist2 (car (cdr (cdr (cdr (cdr (cdr (cdr newlist2))))))))
(define prob (- 1 bdratio2))
(define geomlist (geometric prob 31))
(define sslist (cdr geomlist))
(if (= hide 0) (barchart \"steady_state\" sslist))
(barchart \"transient_state\" outlist2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_undo\")"
bottomPosition "862";
fontList "*times-*-r-*-*-20-*";
labelString "10";
leftPosition "111";
mappedWhenManaged "False";
rightPosition "207";
topPosition "799";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_thousand" 
\callback "Arm" "(define newlist2 (queue_list 1 qlength2 qlength2 1000 numtrials2 30 1000 birth2 birth2 death2 curlist2 curlist2))
(define oldnumtrials2 numtrials2)
(define oldqlength2 qlength2)
(define oldcurlist2 curlist2)
(define oldoutlist2 outlist2)
(define oldsslist sslist)
(define numtrials2 (car (cdr newlist2)))
(define qlength2 (car (cdr (cdr (cdr (car (cdr (cdr newlist2))))))))
(define curlist2 (car (cdr (cdr (cdr (cdr newlist2))))))
(define outlist2 (car (cdr (cdr (cdr (cdr (cdr (cdr newlist2))))))))
(define prob (- 1 bdratio2))
(define geomlist (geometric prob 31))
(define sslist (cdr geomlist))
(if (= hide 0) (barchart \"steady_state\" sslist))
(barchart \"transient_state\" outlist2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_undo\") "
bottomPosition "928";
fontList "*times-*-r-*-*-20-*";
labelString "1000";
leftPosition "112";
mappedWhenManaged "False";
rightPosition "208";
topPosition "864";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_tenthousand" 
\callback "Arm" "(define newlist2 (queue_list 1 qlength2 qlength2 10000 numtrials2 30 1000 birth2 birth2 death2 curlist2 curlist2))
(define oldnumtrials2 numtrials2)
(define oldqlength2 qlength2)
(define oldcurlist2 curlist2)
(define oldoutlist2 outlist2)
(define oldsslist sslist)
(define numtrials2 (car (cdr newlist2)))
(define qlength2 (car (cdr (cdr (cdr (car (cdr (cdr newlist2))))))))
(define curlist2 (car (cdr (cdr (cdr (cdr newlist2))))))
(define outlist2 (car (cdr (cdr (cdr (cdr (cdr (cdr newlist2))))))))
(define prob (- 1 bdratio2))
(define geomlist (geometric prob 31))
(define sslist (cdr geomlist))
(if (= hide 0) (barchart \"steady_state\" sslist))
(barchart \"transient_state\" outlist2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)
 (cds-figure-show \"$CDS_THIS_PAGE\" \"pb_undo\")"
bottomPosition "992";
fontList "*times-*-r-*-*-20-*";
labelString "10,000";
leftPosition "16";
mappedWhenManaged "False";
rightPosition "112";
topPosition "928";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_hundredthou" 
\callback "Arm" "(define newlist2 (queue_list 1 qlength2 qlength2 100000 numtrials2 30 1000 birth2 birth2 death2 curlist2 curlist2))
(define oldnumtrials2 numtrials2)
(define oldqlength2 qlength2)
(define oldcurlist2 curlist2)
(define oldoutlist2 outlist2)
(define oldsslist sslist)
(define numtrials2 (car (cdr newlist2)))
(define qlength2 (car (cdr (cdr (cdr (car (cdr (cdr newlist2))))))))
(define curlist2 (car (cdr (cdr (cdr (cdr newlist2))))))
(define outlist2 (car (cdr (cdr (cdr (cdr (cdr (cdr newlist2))))))))
(define prob (- 1 bdratio2))
(define geomlist (geometric prob 31))
(define sslist (cdr geomlist))
( if (= hide 0) (barchart \"steady_state\" sslist))
(barchart \"transient_state\" outlist2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)
 (cds-figure-show \"$CDS_THIS_PAGE\" \"pb_undo\")"
bottomPosition "992";
fontList "*times-*-r-*-*-20-*";
labelString "100,000";
leftPosition "112";
mappedWhenManaged "False";
rightPosition "208";
topPosition "928";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_one" 
\callback "Arm" "(define newlist2 (queue_list 1 qlength2 qlength2 1 numtrials2 30 1000 birth2 birth2 death2 curlist2 curlist2))
(define oldnumtrials2 numtrials2)
(define oldqlength2 qlength2)
(define oldcurlist2 curlist2)
(define oldoutlist2 outlist2)
(define oldsslist sslist)
(define numtrials2 (cadr newlist2))
(define qlength2 (car (cdr (cdr (cdr (car (cdr (cdr newlist2))))))))
(define curlist2 (car (cdr (cdr (cdr (cdr newlist2))))))
(define outlist2 (car (cdr (cdr (cdr (cdr (cdr (cdr newlist2))))))))
(define prob (- 1 bdratio2))(graph-steady-state)
;(cds-plotter-barchart \"$CDS_THIS_PAGE\" \"P_queues\" \"transient_state\" outlist2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)
 (cds-figure-show \"$CDS_THIS_PAGE\" \"pb_undo\")"
bottomPosition "858";
fontList "*times-*-r-*-*-20-*";
labelString "1";
leftPosition "16";
mappedWhenManaged "False";
rightPosition "112";
topPosition "795";
\end_figure

\begin_figure {XmLabel}
\figure_name "yoda2" 
borderWidth "0";
bottomPosition "944";
labelPixmap "yoda";
labelType "PIXMAP";
leftPosition "528";
mappedWhenManaged "False";
rightPosition "656";
topPosition "624";
\end_figure

\begin_figure {XmLabel}
\figure_name "yoda3" 
borderWidth "0";
bottomPosition "759";
labelPixmap "yoda";
labelType "PIXMAP";
leftPosition "609";
mappedWhenManaged "False";
rightPosition "737";
topPosition "439";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_halve" 
\callback "Activate" "(reset-axis (/ ${P_queues:yaxis.max} 2)) "
bottomPosition "706";
fontList "*times-*-r-*-*-20-*";
labelString "Zoom Chart";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "368";
topPosition "643";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_double" 
\callback "Activate" "(reset-axis (* ${P_queues:yaxis.max} 2))"
bottomPosition "704";
fontList "*times-*-r-*-*-20-*";
labelString "Unzoom Chart";
leftPosition "368";
mappedWhenManaged "False";
rightPosition "512";
topPosition "640";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_undo" 
\callback "Activate" "(define numtrials2 oldnumtrials2)
(define qlength2 oldqlength2)
(define curlist2 oldcurlist2)
(define outlist2 oldoutlist2)
(define sslist oldsslist)
(if (= hide 0) (barchart \"steady_state\" sslist)) 
(barchart \"transient_state\" outlist2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_numtrials2\" \"labelString\" numtrials2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_queuelength2\" \"labelString\" qlength2)  
(cds-figure-hide \"$CDS_THIS_PAGE\" \"pb_undo\")"
bottomPosition "800";
fontList "*times-*-r-*-*-20-*";
labelString "Undo Prior Batch of Trials";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "512";
topPosition "752";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"textbox22\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pushokay\")"
bottomPosition "176";
fontList "*times-*-r-*-*-20-*";
labelString "How do I use this
screen?";
leftPosition "256";
rightPosition "464";
topPosition "80";
\end_figure

\begin_figure {CmLabel}
\figure_name "textbox22" 
bottomPosition "992";
label "This screen shows the first thirty states of an infinite queue.  There are several pushbuttons and sliders to aid you 
in exploring the convergence of queues:
     
A)  Birth and death probability sliders:  Whenever these are changed, the steady-state distribution changes to reflect 
       the current birth-death ratio.  In changing these sliders, keep three things in mind:
            1)  The sum of the two sliders cannot exceed one.
            2)  The birth probability cannot equal or exceed the death probability.
            3)  You may want to reset the experiment once you adjust the sliders because the 
                   steady-state chart reflects only the current birth-death ratio and the transient 
                   queue contains all the affects of prior birth-death ratios, so it won't converge to 
                   the steady-state chart, unless maybe a HUGE number of trials are run.
    
B)  Once you hit the button to run the experiment for the first time, several other pushbuttons 
       appear:
      
            1)  The reset button allows you to clear the transient queue.
            2)  The numbered trial buttons allow you to run batches of up to 100,000 trials.
            3)  The halve-Yaxis and double Y-axis buttons allow you inspect the tails of 
                  distributions and/or distributions of queues with high birth-death ratios 
                  with greater precision.
            4)  The undo button, when it is available, allows you to undo the last selected batch 
                   of trials.  This comes in handy when you select a large number of trials, the queue 
                   suddenly seems to converge, and you wish to go back and explore this converge at a 
                   smaller trial batch increment.
            5)  The hide/show steady state buttons allow for different lecture displays.  By hiding the 
                   steady state, the user can focus solely on the transient queue.  On the other hand, by 
                   not selecting trials and merely moving the sliders while the steady-state is showing, 
                   different steady-states can be compared.";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "992";
topPosition "0";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_showsteady" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hidesteady\")
(define hide 0)
(define prob (- 1 bdratio2))
(if (and (>= prob 0) (<= prob 1))
    (define geomlist (geometric prob 31)))
(if (and (>= prob 0) (<= prob 1))
    (define sslist (cdr geomlist)))
(if (and (>= prob 0) (<= prob 1))
    (barchart \"steady_state\" sslist)) "
bottomPosition "752";
fontList "*times-*-r-*-*-20-*";
labelString "Show the Steady State";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "512";
topPosition "704";
\end_figure

\begin_figure {XmPushButton}
\figure_name "pb_hidesteady" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_showsteady\")
(define hide #t)
(cds-plotter-delete-plot \"$CDS_THIS_PAGE\" \"P_queues\" \"steady_state\")"
bottomPosition "752";
fontList "*times-*-r-*-*-20-*";
labelString "Hide the Steady State";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "512";
topPosition "704";
\end_figure
\end_screen
\end_page

\begin_page{Queue_Simulator}
\title{Queue Simulator}
\page_constructor_text "(define tot1birth 0)
(define tot1death 0)
(define tot1length 0)
(define q1length 0)
(define tot1balk 0)
(define tot2birth 0)
(define tot2death 0)
(define tot2length 0)
(define q2length 0)
(define tot2balk 0)
(define emptylist (list 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(define q1curlist emptylist)
(define q2curlist emptylist)
(define q1outlist emptylist)
(define q2outlist emptylist)
(define maxlength2 10000)
(define trialsrun 0)
(define birthQ1 ( / ${s_birthQ1:value} 100))
(define birthQ2 ( / ${s_birthQ2:value} 100))
(define deathQ12 ( / ${s_deathQ12:value} 100))
(define birthstv ( / ${s_birthSTV:value} 100))
(define deathstv ( / ${s_deathSTV:value} 100))
(define ratiostv ${s_ratioSTV:value})
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" 0)   "
\begin_screen
\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "3";
bottomPosition "170";
labelPixmap "junkXmLabel";
labelType "PIXMAP";
leftPosition "0";
rightPosition "991";
topPosition "151";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled2_CmLabel0" 
borderWidth "0";
bottomPosition "48";
fontSize "medbig";
label "Please select one of the following:";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure\begin_figure {XmPushButton}
\figure_name "untitled2_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"textbox3\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_okay\")"
bottomPosition "144";
fontList "*times-*-r-*-*-20-*";
labelString "Why am I looking
at this screen?";
leftPosition "0";
rightPosition "176";
topPosition "48";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_run1" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_runbdr\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_qreset\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_runstv\")    
(cds-figure-show \"$CDS_THIS_PAGE\" \"l_trialnumber\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_finiteql\")"
bottomPosition "144";
fontList "*times-*-r-*-*-20-*";
labelString "Run the Queue
Simulator";
leftPosition "432";
rightPosition "992";
topPosition "48";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled2_CmLabel0" 
borderWidth "0";
bottomPosition "224";
label "@u(Queue #1 Statistics):";
leftPosition "512";
rightPosition "688";
topPosition "176";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled2_CmLabel0" 
borderWidth "0";
bottomPosition "640";
label "@u(Queue #2 Statistics):";
leftPosition "512";
rightPosition "688";
topPosition "592";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled2_CmLabel0" 
borderWidth "0";
bottomPosition "240";
fontSize "medbig";
label "@b(@u(Experiment Control):)";
leftPosition "752";
rightPosition "992";
topPosition "176";
\end_figure\begin_figure {XmLabel}
\figure_name "yoda4" 
borderWidth "0";
bottomPosition "544";
labelPixmap "yoda";
labelType "PIXMAP";
leftPosition "544";
mappedWhenManaged "False";
rightPosition "672";
topPosition "224";
\end_figure\begin_figure {XmLabel}
\figure_name "yoda5" 
borderWidth "0";
bottomPosition "512";
labelPixmap "yoda";
labelType "PIXMAP";
leftPosition "544";
mappedWhenManaged "False";
rightPosition "672";
topPosition "192";
\end_figure\begin_figure {XmScale}
\figure_name "s_deathSTV" 
\callback "Value Changed" "(define deathstv (/ ${s_deathSTV:value} 100))
(define bdratiostv (/ birthstv deathstv))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" bdratiostv)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" bdratiostv)
(if (> (+ birthstv deathstv) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (> (+ birthstv deathstv) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") )
(if (<= (+ birthstv deathstv) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (<= (+ birthstv deathstv) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") )      
(if (>= birthstv deathstv)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (>= birthstv deathstv)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birthstv deathstv)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (< birthstv deathstv)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") )       "
bottomPosition "608";
decimalPoints "2";
leftPosition "752";
mappedWhenManaged "False";
minimum "1";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "992";
titleString "Death Probability, Queues #1, #2 #1";
topPosition "512";
value "20";
\end_figure\begin_figure {XmScale}
\figure_name "s_ratioSTV" 
\callback "Value Changed" "(define ratiostv ${s_ratioSTV:value})"
bottomPosition "704";
decimalPoints "1";
leftPosition "752";
mappedWhenManaged "False";
maximum "50";
minimum "10";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "992";
titleString "Q2 Serv. Time Var. / Q1 S.T.V.";
topPosition "608";
value "20";
\end_figure\begin_figure {AtPlotter}
\figure_name "p_queue1" 
bottomPosition "544";
leftPosition "0";
rightPosition "496";
title "Queue #1 State Distribution";
topPosition "192";
xaxis.label "Queue State";
xaxis.max "30";
xaxis.min "-1";
yaxis.label "Prob(Queue State)";
\end_figure\begin_figure {AtPlotter}
\figure_name "p_queue2" 
bottomPosition "960";
leftPosition "0";
rightPosition "496";
title "Queue #2 State Distribution";
topPosition "624";
xaxis.label "Queue State";
xaxis.max "30";
xaxis.min "-1";
yaxis.label "Prob(Queue State)";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_runstv" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_one2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_ten2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hundred2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_thousand2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_tenthousand2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hundredthou2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"l_exstv\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_birthSTV\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_deathSTV\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_ratioSTV\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"l_ratio\")
(define maxratio 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" maxratio)
(cds-figure-show \"$CDS_THIS_PAGE\" \"l_maxratio\")
(define experiment 2)
(define bdratiostv (/ ${s_birthSTV:value}
		  ${s_deathSTV:value}))
(define tot1birth 0)
(define tot1death 0)
(define tot1length 0)
(define q1length 0)
(define tot1balk 0)
(define tot2birth 0)
(define tot2death 0)
(define tot2length 0)
(define q2length 0)
(define tot2balk 0)
(define emptylist (list 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(define trialsrun 0)
(define q1curlist emptylist)
(define q2curlist emptylist)
(define q1outlist emptylist)
(define q2outlist emptylist)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" bdratiostv)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" bdratiostv)
(barchart \"chart1\" q1outlist)
(barchart \"chart2\" q2outlist) "
bottomPosition "144";
fontList "*times-*-r-*-*-20-*";
labelString "Run the Service Time
Variance Experiment";
leftPosition "800";
mappedWhenManaged "False";
rightPosition "992";
topPosition "48";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_qreset" 
\callback "Activate" "(define tot1birth 0)
(define tot1death 0)
(define tot1length 0)
(define q1length 0)
(define tot1balk 0)
(define tot2birth 0)
(define tot2death 0)
(define tot2length 0)
(define q2length 0)
(define tot2balk 0)
(define emptylist (list 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(define trialsrun 0)
(define maxratio 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" 0)
(define q1curlist emptylist)
(define q2curlist emptylist)
(define q1outlist emptylist)
(define q2outlist emptylist)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" trialsrun)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" 0) 
(barchart \"chart1\" q1outlist)
(barchart \"chart2\" q2outlist)  "
bottomPosition "144";
fontList "*times-*-r-*-*-24-*";
labelString "RESET THE
QUEUES";
leftPosition "624";
mappedWhenManaged "False";
rightPosition "800";
topPosition "48";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_runbdr" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_one2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_ten2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hundred2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_thousand2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_tenthousand2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_hundredthou2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"l_exbdr\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_birthQ1\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_birthQ2\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_deathQ12\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l_ratio\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l_maxratio\")
(define experiment 1)
(define bdratioQ1 (/ ${s_birthQ1:value}
                                                 ${s_deathQ12:value}))
(define bdratioQ2 (/ ${s_birthQ2:value}
                                                 ${s_deathQ12:value}))
(define tot1birth 0)
(define tot1death 0)
(define tot1length 0)
(define q1length 0)
(define tot1balk 0)
(define tot2birth 0)
(define tot2death 0)
(define tot2length 0)
(define q2length 0)
(define tot2balk 0)
(define emptylist (list 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(define trialsrun 0)
(define q1curlist emptylist)
(define q2curlist emptylist)
(define q1outlist emptylist)
(define q2outlist emptylist)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" 0)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" bdratioQ1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" bdratioQ2)
(barchart \"chart1\" q1outlist)
(barchart \"chart2\" q2outlist) "
bottomPosition "144";
fontList "*times-*-r-*-*-20-*";
labelString "Run the Birth-Death
Ratio Experiment";
leftPosition "432";
mappedWhenManaged "False";
rightPosition "624";
topPosition "48";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_tenthousand2" 
\callback "Arm" "(if (= experiment 1) (define newlist3 (queue_list 1 q1length q2length 10000 trialsrun 29 maxlength2 birthQ1 birthQ2 deathQ12 q1curlist q2curlist)))
(if (= experiment 2) (define newlist3 (queue_list 2 q1length q2length 10000 trialsrun 29 maxlength2 birthstv deathstv ratiostv q1curlist q2curlist)))
(define trialsrun (car (cdr newlist3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" trialsrun)
(set! tot1birth (+ tot1birth (car (car (cdr (cdr newlist3))))))
(set! tot1death (+ tot1death (car (cdr (car (cdr (cdr newlist3)))))))
(set! tot1length (+ tot1length (car (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! q1length (car (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! tot1balk (+ tot1balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))))
(set! tot2birth (+ tot2birth (car (car (cdr (cdr (cdr newlist3)))))))
(set! tot2death (+ tot2death (car (cdr (car (cdr (cdr (cdr newlist3))))))))
(set! tot2length (+ tot2length (car (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! q2length (car (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! tot2balk (+ tot2balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))))
(define q1curlist (car (cdr (cdr (cdr (cdr newlist3))))))
(define q2curlist (car (cdr (cdr (cdr (cdr (cdr newlist3)))))))
(define q1outlist (car (cdr (cdr (cdr (cdr (cdr (cdr newlist3))))))))
(define q2outlist (car (cdr (cdr (cdr (cdr (cdr (cdr (cdr newlist3)))))))))
(define maxratio (precision (car newlist3) 2))
(define exstate1 (precision (/ tot1length trialsrun) 3))
(define exstate2 (precision (/ tot2length trialsrun) 3))
(define emptprob1 (precision (car q1outlist) 3))
(define emptprob2 (precision (car q2outlist) 3))
(define exlen1 (precision (- exstate1 (- 1 emptprob1)) 3))
(define exlen2 (precision (- exstate2 (- 1 emptprob2)) 3))
(define simbp1 (precision (/ tot1birth trialsrun) 3))
(define simbp2 (precision (/ tot2birth trialsrun) 3))
(define simdp1 (precision (/ tot1death trialsrun) 3))
(define simdp2 (precision (/ tot2death trialsrun) 3))
(if (= tot1birth 0) (define btob1 0))
(if (> tot1birth 0) (define btob1 (precision (/ tot1balk tot1birth) 3)))
(if (= tot2birth 0) (define btob2 0))
(if (> tot2birth 0) (define btob2 (precision (/ tot2balk tot2birth) 3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" maxratio)  
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" exstate1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" exstate2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" exlen1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" exlen2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" emptprob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" emptprob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" simbp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" simdp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" simbp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" simdp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" tot1balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" btob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" tot2balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" btob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" q1length)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" q2length)
(barchart \"chart1\" q1outlist) 
(barchart \"chart2\" q2outlist)
 "
bottomPosition "992";
fontList "*times-*-r-*-*-20-*";
labelString "10,000";
leftPosition "832";
mappedWhenManaged "False";
rightPosition "912";
topPosition "928";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_thousand2" 
\callback "Arm" "(if (= experiment 1) (define newlist3 (queue_list 1 q1length q2length 1000 trialsrun 29 maxlength2 birthQ1 birthQ2 deathQ12 q1curlist q2curlist)))
(if (= experiment 2) (define newlist3 (queue_list 2 q1length q2length 1000 trialsrun 29 maxlength2 birthstv deathstv ratiostv q1curlist q2curlist)))
(define trialsrun (car (cdr newlist3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" trialsrun)
(set! tot1birth (+ tot1birth (car (car (cdr (cdr newlist3))))))
(set! tot1death (+ tot1death (car (cdr (car (cdr (cdr newlist3)))))))
(set! tot1length (+ tot1length (car (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! q1length (car (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! tot1balk (+ tot1balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))))
(set! tot2birth (+ tot2birth (car (car (cdr (cdr (cdr newlist3)))))))
(set! tot2death (+ tot2death (car (cdr (car (cdr (cdr (cdr newlist3))))))))
(set! tot2length (+ tot2length (car (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! q2length (car (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! tot2balk (+ tot2balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))))
(define q1curlist (car (cdr (cdr (cdr (cdr newlist3))))))
(define q2curlist (car (cdr (cdr (cdr (cdr (cdr newlist3)))))))
(define q1outlist (car (cdr (cdr (cdr (cdr (cdr (cdr newlist3))))))))
(define q2outlist (car (cdr (cdr (cdr (cdr (cdr (cdr (cdr newlist3)))))))))
(define maxratio (precision (car newlist3) 2))
(define exstate1 (precision (/ tot1length trialsrun) 3))
(define exstate2 (precision (/ tot2length trialsrun) 3))
(define emptprob1 (precision (car q1outlist) 3))
(define emptprob2 (precision (car q2outlist) 3))
(define exlen1 (precision (- exstate1 (- 1 emptprob1)) 3))
(define exlen2 (precision (- exstate2 (- 1 emptprob2)) 3))
(define simbp1 (precision (/ tot1birth trialsrun) 3))
(define simbp2 (precision (/ tot2birth trialsrun) 3))
(define simdp1 (precision (/ tot1death trialsrun) 3))
(define simdp2 (precision (/ tot2death trialsrun) 3))
(if (= tot1birth 0) (define btob1 0))
(if (> tot1birth 0) (define btob1 (precision (/ tot1balk tot1birth) 3)))
(if (= tot2birth 0) (define btob2 0))
(if (> tot2birth 0) (define btob2 (precision (/ tot2balk tot2birth) 3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" maxratio)  
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" exstate1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" exstate2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" exlen1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" exlen2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" emptprob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" emptprob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" simbp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" simdp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" simbp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" simdp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" tot1balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" btob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" tot2balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" btob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" q1length)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" q2length)
(barchart \"chart1\" q1outlist) 
(barchart \"chart2\" q2outlist)
 "
bottomPosition "992";
fontList "*times-*-r-*-*-20-*";
labelString "1000";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "832";
topPosition "928";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_hundred2" 
\callback "Arm" "(if (= experiment 1) (define newlist3 (queue_list 1 q1length q2length 100 trialsrun 29 maxlength2 birthQ1 birthQ2 deathQ12 q1curlist q2curlist)))
(if (= experiment 2) (define newlist3 (queue_list 2 q1length q2length 100 trialsrun 29 maxlength2 birthstv deathstv ratiostv q1curlist q2curlist)))
(define trialsrun (car (cdr newlist3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" trialsrun)
(set! tot1birth (+ tot1birth (car (car (cdr (cdr newlist3))))))
(set! tot1death (+ tot1death (car (cdr (car (cdr (cdr newlist3)))))))
(set! tot1length (+ tot1length (car (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! q1length (car (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! tot1balk (+ tot1balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))))
(set! tot2birth (+ tot2birth (car (car (cdr (cdr (cdr newlist3)))))))
(set! tot2death (+ tot2death (car (cdr (car (cdr (cdr (cdr newlist3))))))))
(set! tot2length (+ tot2length (car (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! q2length (car (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! tot2balk (+ tot2balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))))
(define q1curlist (car (cdr (cdr (cdr (cdr newlist3))))))
(define q2curlist (car (cdr (cdr (cdr (cdr (cdr newlist3)))))))
(define q1outlist (car (cdr (cdr (cdr (cdr (cdr (cdr newlist3))))))))
(define q2outlist (car (cdr (cdr (cdr (cdr (cdr (cdr (cdr newlist3)))))))))
(define maxratio (precision (car newlist3) 2))
(define exstate1 (precision (/ tot1length trialsrun) 3))
(define exstate2 (precision (/ tot2length trialsrun) 3))
(define emptprob1 (precision (car q1outlist) 3))
(define emptprob2 (precision (car q2outlist) 3))
(define exlen1 (precision (- exstate1 (- 1 emptprob1)) 3))
(define exlen2 (precision (- exstate2 (- 1 emptprob2)) 3))
(define simbp1 (precision (/ tot1birth trialsrun) 3))
(define simbp2 (precision (/ tot2birth trialsrun) 3))
(define simdp1 (precision (/ tot1death trialsrun) 3))
(define simdp2 (precision (/ tot2death trialsrun) 3))
(if (= tot1birth 0) (define btob1 0))
(if (> tot1birth 0) (define btob1 (precision (/ tot1balk tot1birth) 3)))
(if (= tot2birth 0) (define btob2 0))
(if (> tot2birth 0) (define btob2 (precision (/ tot2balk tot2birth) 3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" maxratio)   
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" exstate1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" exstate2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" exlen1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" exlen2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" emptprob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" emptprob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" simbp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" simdp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" simbp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" simdp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" tot1balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" btob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" tot2balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" btob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" q1length)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" q2length)
(barchart \"chart1\" q1outlist) 
(barchart \"chart2\" q2outlist)
 "
bottomPosition "928";
fontList "*times-*-r-*-*-20-*";
labelString "100";
leftPosition "912";
mappedWhenManaged "False";
rightPosition "992";
topPosition "864";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_ten2" 
\callback "Arm" "(if (= experiment 1) (define newlist3 (queue_list 1 q1length q2length 10 trialsrun 29 maxlength2 birthQ1 birthQ2 deathQ12 q1curlist q2curlist)))
(if (= experiment 2) (define newlist3 (queue_list 2 q1length q2length 10 trialsrun 29 maxlength2 birthstv deathstv ratiostv q1curlist q2curlist)))
(define trialsrun (car (cdr newlist3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" trialsrun)
(set! tot1birth (+ tot1birth (car (car (cdr (cdr newlist3))))))
(set! tot1death (+ tot1death (car (cdr (car (cdr (cdr newlist3)))))))
(set! tot1length (+ tot1length (car (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! q1length (car (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! tot1balk (+ tot1balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))))
(set! tot2birth (+ tot2birth (car (car (cdr (cdr (cdr newlist3)))))))
(set! tot2death (+ tot2death (car (cdr (car (cdr (cdr (cdr newlist3))))))))
(set! tot2length (+ tot2length (car (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! q2length (car (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! tot2balk (+ tot2balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))))
(define q1curlist (car (cdr (cdr (cdr (cdr newlist3))))))
(define q2curlist (car (cdr (cdr (cdr (cdr (cdr newlist3)))))))
(define q1outlist (car (cdr (cdr (cdr (cdr (cdr (cdr newlist3))))))))
(define q2outlist (car (cdr (cdr (cdr (cdr (cdr (cdr (cdr newlist3)))))))))
(define maxratio (precision (car newlist3) 2))
(define exstate1 (precision (/ tot1length trialsrun) 3))
(define exstate2 (precision (/ tot2length trialsrun) 3))
(define emptprob1 (precision (car q1outlist) 3))
(define emptprob2 (precision (car q2outlist) 3))
(define exlen1 (precision (- exstate1 (- 1 emptprob1)) 3))
(define exlen2 (precision (- exstate2 (- 1 emptprob2)) 3))
(define simbp1 (precision (/ tot1birth trialsrun) 3))
(define simbp2 (precision (/ tot2birth trialsrun) 3))
(define simdp1 (precision (/ tot1death trialsrun) 3))
(define simdp2 (precision (/ tot2death trialsrun) 3))
(if (= tot1birth 0) (define btob1 0))
(if (> tot1birth 0) (define btob1 (precision (/ tot1balk tot1birth) 3)))
(if (= tot2birth 0) (define btob2 0))
(if (> tot2birth 0) (define btob2 (precision (/ tot2balk tot2birth) 3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" maxratio)   
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" exstate1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" exstate2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" exlen1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" exlen2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" emptprob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" emptprob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" simbp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" simdp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" simbp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" simdp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" tot1balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" btob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" tot2balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" btob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" q1length)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" q2length)
(barchart \"chart1\" q1outlist) 
(barchart \"chart2\" q2outlist)
 "
bottomPosition "928";
fontList "*times-*-r-*-*-20-*";
labelString "10";
leftPosition "832";
mappedWhenManaged "False";
rightPosition "912";
topPosition "864";
\end_figure\begin_figure {XmLabel}
\figure_name "l_trialnumber" 
bottomPosition "864";
fontList "8x13bold";
labelString "Select # of Trials to Run:";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "992";
topPosition "832";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_hundredthou2" 
\callback "Arm" "(if (= experiment 1) (define newlist3 (queue_list 1 q1length q2length 100000 trialsrun 29 maxlength2 birthQ1 birthQ2 deathQ12 q1curlist q2curlist)))
(if (= experiment 2) (define newlist3 (queue_list 2 q1length q2length 100000 trialsrun 29 maxlength2 birthstv deathstv ratiostv q1curlist q2curlist)))
(define trialsrun (car (cdr newlist3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" trialsrun)
(set! tot1birth (+ tot1birth (car (car (cdr (cdr newlist3))))))
(set! tot1death (+ tot1death (car (cdr (car (cdr (cdr newlist3)))))))
(set! tot1length (+ tot1length (car (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! q1length (car (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! tot1balk (+ tot1balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))))
(set! tot2birth (+ tot2birth (car (car (cdr (cdr (cdr newlist3)))))))
(set! tot2death (+ tot2death (car (cdr (car (cdr (cdr (cdr newlist3))))))))
(set! tot2length (+ tot2length (car (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! q2length (car (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! tot2balk (+ tot2balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))))
(define q1curlist (car (cdr (cdr (cdr (cdr newlist3))))))
(define q2curlist (car (cdr (cdr (cdr (cdr (cdr newlist3)))))))
(define q1outlist (car (cdr (cdr (cdr (cdr (cdr (cdr newlist3))))))))
(define q2outlist (car (cdr (cdr (cdr (cdr (cdr (cdr (cdr newlist3)))))))))
(define maxratio (precision (car newlist3) 2))
(define exstate1 (precision (/ tot1length trialsrun) 3))
(define exstate2 (precision (/ tot2length trialsrun) 3))
(define emptprob1 (precision (car q1outlist) 3))
(define emptprob2 (precision (car q2outlist) 3))
(define exlen1 (precision (- exstate1 (- 1 emptprob1)) 3))
(define exlen2 (precision (- exstate2 (- 1 emptprob2)) 3))
(define simbp1 (precision (/ tot1birth trialsrun) 3))
(define simbp2 (precision (/ tot2birth trialsrun) 3))
(define simdp1 (precision (/ tot1death trialsrun) 3))
(define simdp2 (precision (/ tot2death trialsrun) 3))
(if (= tot1birth 0) (define btob1 0))
(if (> tot1birth 0) (define btob1 (precision (/ tot1balk tot1birth) 3)))
(if (= tot2birth 0) (define btob2 0))
(if (> tot2birth 0) (define btob2 (precision (/ tot2balk tot2birth) 3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" maxratio)   
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" exstate1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" exstate2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" exlen1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" exlen2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" emptprob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" emptprob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" simbp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" simdp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" simbp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" simdp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" tot1balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" btob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" tot2balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" btob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" q1length)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" q2length)
(barchart \"chart1\" q1outlist) 
(barchart \"chart2\" q2outlist)
 "
bottomPosition "992";
fontList "*times-*-r-*-*-20-*";
labelString "100,000";
leftPosition "912";
mappedWhenManaged "False";
rightPosition "992";
topPosition "928";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_one2" 
\callback "Arm" "(if (= experiment 1) (define newlist3 (queue_list 1 q1length q2length 1 trialsrun 29 maxlength2 birthQ1 birthQ2 deathQ12 q1curlist q2curlist)))
(if (= experiment 2) (define newlist3 (queue_list 2 q1length q2length 1 trialsrun 29 maxlength2 birthstv deathstv ratiostv q1curlist q2curlist)))
(define trialsrun (car (cdr newlist3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_trialsrun\" \"labelString\" trialsrun)
(set! tot1birth (+ tot1birth (car (car (cdr (cdr newlist3))))))
(set! tot1death (+ tot1death (car (cdr (car (cdr (cdr newlist3)))))))
(set! tot1length (+ tot1length (car (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! q1length (car (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))
(set! tot1balk (+ tot1balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr newlist3))))))))))
(set! tot2birth (+ tot2birth (car (car (cdr (cdr (cdr newlist3)))))))
(set! tot2death (+ tot2death (car (cdr (car (cdr (cdr (cdr newlist3))))))))
(set! tot2length (+ tot2length (car (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! q2length (car (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))
(set! tot2balk (+ tot2balk (car (cdr (cdr (cdr (cdr (car (cdr (cdr (cdr newlist3)))))))))))
(define q1curlist (car (cdr (cdr (cdr (cdr newlist3))))))
(define q2curlist (car (cdr (cdr (cdr (cdr (cdr newlist3)))))))
(define q1outlist (car (cdr (cdr (cdr (cdr (cdr (cdr newlist3))))))))
(define q2outlist (car (cdr (cdr (cdr (cdr (cdr (cdr (cdr newlist3)))))))))
(define maxratio (precision (car newlist3) 2))
(define exstate1 (precision (/ tot1length trialsrun) 3))
(define exstate2 (precision (/ tot2length trialsrun) 3))
(define emptprob1 (precision (car q1outlist) 3))
(define emptprob2 (precision (car q2outlist) 3))
(define exlen1 (precision (- exstate1 (- 1 emptprob1)) 3))
(define exlen2 (precision (- exstate2 (- 1 emptprob2)) 3))
(define simbp1 (precision (/ tot1birth trialsrun) 3))
(define simbp2 (precision (/ tot2birth trialsrun) 3))
(define simdp1 (precision (/ tot1death trialsrun) 3))
(define simdp2 (precision (/ tot2death trialsrun) 3))
(if (= tot1birth 0) (define btob1 0))
(if (> tot1birth 0) (define btob1 (precision (/ tot1balk tot1birth) 3)))
(if (= tot2birth 0) (define btob2 0))
(if (> tot2birth 0) (define btob2 (precision (/ tot2balk tot2birth) 3)))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_maxratio\" \"labelString\" maxratio)   
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate1\" \"labelString\" exstate1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exstate2\" \"labelString\" exstate2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen1\" \"labelString\" exlen1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_exlen2\" \"labelString\" exlen2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob1\" \"labelString\" emptprob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_emptprob2\" \"labelString\" emptprob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp1\" \"labelString\" simbp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp1\" \"labelString\" simdp1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simbp2\" \"labelString\" simbp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_simdp2\" \"labelString\" simdp2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks1\" \"labelString\" tot1balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob1\" \"labelString\" btob1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_balks2\" \"labelString\" tot2balk)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_btob2\" \"labelString\" btob2)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate1\" \"labelString\" q1length)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_curstate2\" \"labelString\" q2length)
(barchart \"chart1\" q1outlist) 
(barchart \"chart2\" q2outlist)
 "
bottomPosition "928";
fontList "*times-*-r-*-*-20-*";
labelString "1";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "832";
topPosition "864";
\end_figure\begin_figure {XmScale}
\figure_name "s_birthSTV" 
\callback "Value Changed" "(define birthstv (/ ${s_birthSTV:value} 100))
(define bdratiostv (/ birthstv deathstv))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" bdratiostv)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" bdratiostv)
(if (> (+ birthstv deathstv) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (> (+ birthstv deathstv) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") )
(if (<= (+ birthstv deathstv) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (<= (+ birthstv deathstv) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") )      
(if (>= birthstv deathstv)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (>= birthstv deathstv)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birthstv deathstv)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (< birthstv deathstv)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") ) "
bottomPosition "512";
decimalPoints "2";
leftPosition "752";
mappedWhenManaged "False";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "992";
titleString "Birth Probability, Queues #1, #2";
topPosition "416";
value "15";
\end_figure\begin_figure {XmScale}
\figure_name "s_birthQ2" 
\callback "Value Changed" "(define birthQ2 (/ ${s_birthQ2:value} 100))
(define bdratioQ2 (/ birthQ2 deathQ12))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" bdratioQ2)
(if (> (+ birthQ2 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (> (+ birthQ2 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") )
(if (<= (+ birthQ2 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (<= (+ birthQ2 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") )  
(if (>= birthQ2 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (>= birthQ2 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birthQ2 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (< birthQ2 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") )"
bottomPosition "608";
decimalPoints "2";
leftPosition "752";
mappedWhenManaged "False";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "992";
titleString "Birth Probability, Queue #2";
topPosition "512";
value "15";
\end_figure\begin_figure {XmScale}
\figure_name "s_birthQ1" 
\callback "Value Changed" "(define birthQ1 (/ ${s_birthQ1:value} 100))
(define bdratioQ1 (/ birthQ1 deathQ12))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" bdratioQ1)
(if (> (+ birthQ1 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (> (+ birthQ1 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") )
(if (<= (+ birthQ1 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (<= (+ birthQ1 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") )  
(if (>= birthQ1 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (>= birthQ1 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birthQ1 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (< birthQ1 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") )   "
bottomPosition "512";
decimalPoints "2";
leftPosition "752";
mappedWhenManaged "False";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "992";
titleString "Birth Probability, Queue #1";
topPosition "416";
value "10";
\end_figure\begin_figure {XmScale}
\figure_name "s_deathQ12" 
\callback "Value Changed" "(define deathQ12 (/ ${s_deathQ12:value} 100))
(define bdratioQ1 (/ birthQ1 deathQ12))
(define bdratioQ2 (/ birthQ2 deathQ12))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr1\" \"labelString\" bdratioQ1)
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_bdr2\" \"labelString\" bdratioQ2)
(if (> (+ birthQ1 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (> (+ birthQ1 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") )
(if (<= (+ birthQ1 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (<= (+ birthQ1 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") )  
(if (>= birthQ1 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (>= birthQ1 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birthQ1 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (< birthQ1 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") ) 
(if (> (+ birthQ2 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (> (+ birthQ2 deathQ12) 1)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warningtext\") )
(if (<= (+ birthQ2 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda4\") )
(if (<= (+ birthQ2 deathQ12) 1)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warningtext\") )  
(if (>= birthQ2 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (>= birthQ2 deathQ12)
      (cds-figure-show \"$CDS_THIS_PAGE\" \"warntext\") )
(if (< birthQ2 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"yoda5\") )
(if (< birthQ2 deathQ12)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"warntext\") )  "
bottomPosition "704";
decimalPoints "2";
leftPosition "752";
mappedWhenManaged "False";
minimum "1";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "992";
titleString "Death Probability, Queues #1, #2";
topPosition "608";
value "20";
\end_figure\begin_figure {CmLabel}
\figure_name "warningtext" 
borderWidth "10";
bottomPosition "960";
fontSize "biggest";
label "The sum of birth and 
death probabilities 
cannot exceed one.   
    
Please readjust the 
sliders to correct 
this situation!!";
leftPosition "512";
mappedWhenManaged "False";
rightPosition "720";
topPosition "544";
\end_figure\begin_figure {CmLabel}
\figure_name "warntext" 
borderWidth "10";
bottomPosition "960";
fontSize "biggest";
label "The birth probability 
must be less than the 
death probability. 
      
Please readjust the 
sliders to correct this 
situation!!";
leftPosition "512";
mappedWhenManaged "False";
rightPosition "720";
topPosition "512";
\end_figure\begin_figure {XmScale}
\figure_name "s_maxlength" 
\callback "Value Changed" "(define maxlength2 ${s_maxlength:value})
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_ql\" \"labelString\" maxlength2)"
bottomPosition "832";
leftPosition "752";
mappedWhenManaged "False";
maximum "29";
minimum "1";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "992";
titleString "Maximum Queue Length";
topPosition "736";
value "10";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "0";
bottomPosition "272";
fontList "8x13bold";
labelString "Experiment Type:";
leftPosition "752";
rightPosition "896";
topPosition "240";
\end_figure\begin_figure {XmLabel}
\figure_name "l_exstv" 
borderWidth "0";
bottomPosition "336";
fontList "*lucida-*-r-*-*-20-*";
labelString "Service Time Variance";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "992";
topPosition "272";
\end_figure\begin_figure {XmLabel}
\figure_name "l_exbdr" 
borderWidth "0";
bottomPosition "336";
fontList "*lucida-*-r-*-*-20-*";
labelString "Birth-Death Ratio";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "992";
topPosition "272";
\end_figure\begin_figure {XmLabel}
\figure_name "l_ql" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "400";
fontList "7x13bold";
labelString "infinite";
leftPosition "912";
rightPosition "992";
topPosition "368";
\end_figure\begin_figure {XmLabel}
\figure_name "l_trialsrun" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "368";
fontList "7x13bold";
labelString "0";
leftPosition "912";
rightPosition "992";
topPosition "336";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "368";
fontList "7x13bold";
labelString "Total # of Trials Run:";
leftPosition "752";
rightPosition "912";
topPosition "336";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "400";
fontList "7x13bold";
labelString "Maximum Queue Length:";
leftPosition "752";
rightPosition "912";
topPosition "368";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_finiteql" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_infiniteql\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"s_maxlength\")
(define maxlength2 ${s_maxlength:value})
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_ql\" \"labelString\" maxlength2)"
bottomPosition "832";
fontList "*lucida-*-r-*-*-20-*";
labelString "Push here to set 
a finite queue 
length.";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "992";
topPosition "704";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_infiniteql" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_finiteql\")
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"l_ql\" \"labelString\" \"infinite\")
(define maxlength2 10000)"
bottomPosition "736";
labelString "Push here for infinite queue length.";
leftPosition "752";
mappedWhenManaged "False";
rightPosition "992";
topPosition "704";
\end_figure\begin_figure {CmLabel}
\figure_name "textbox3" 
bottomPosition "992";
label "The purpose of this screen is to allow you to see the effects of different parameters on the expected state of the queue. 
In particular, you may explore:
      
A) @b(Birth-Death Ratio).  By selecting the birth-death ratio experiment, you may see what effectes the birth-death ratio 
     has on the expected state of the queue.  You are asked to enter the birth probabilities of two queues and a death
     probability that the two queues share.  As trials are run, you may compare the simulated statistics and state 
     distributions of the two queues.  Each of the queues in this experiment has one server and @i(may) have an imposed
     maximum length.  These simple queues follow the Markovian discipline; in each state the probabilities of birth and 
     death are well defined.
       
B) @b(Service Time Variance).  This experiment allows you to see the drastic effect that an increase in service time 
     variance has on the expected state of the queue.  The queues used in this experiment have the same physical 
     aspects as those used in the birth-death ratio, but these queues do not follow the Markovian discipline.  The 
     variance is introduced by means of a probabilistic choice between two service types when a death is incurred, 
     thus the assumption that well defined probabilities for state transitions exist is violated.    The expected 
     service time for these two service types averages out so that the death probability is the same for both queues, 
     but the service time variance is not.  ";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "992";
topPosition "0";
\end_figure\begin_figure {XmPushButton}
\figure_name "pb_okay" 
\callback "Activate" "(cds-figure-hide \"$CDS_THIS_PAGE\" \"pb_okay\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"textbox3\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"textbox31\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"textbox32\")"
bottomPosition "928";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "OK";
leftPosition "784";
mappedWhenManaged "False";
rightPosition "960";
topPosition "816";
\end_figure\begin_figure {XmLabel}
\figure_name "l_bdr2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "672";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "640";
\end_figure\begin_figure {XmLabel}
\figure_name "l_bdr1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "256";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "224";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "256";
fontList "7x13bold";
labelString "Birth-Death Ratio:";
leftPosition "512";
rightPosition "688";
topPosition "224";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "672";
fontList "7x13bold";
labelString "Birth-Death Ratio:";
leftPosition "512";
rightPosition "688";
topPosition "640";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "736";
fontList "7x13bold";
labelString "Expected Queue State:";
leftPosition "512";
rightPosition "688";
topPosition "704";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "384";
fontList "7x13bold";
labelString "P(empty server):";
leftPosition "512";
rightPosition "688";
topPosition "352";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "800";
fontList "7x13bold";
labelString "P(empty server):";
leftPosition "512";
rightPosition "688";
topPosition "768";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "416";
fontList "7x13bold";
labelString "Simulated P(birth):";
leftPosition "512";
rightPosition "688";
topPosition "384";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "832";
fontList "7x13bold";
labelString "Simulated P(birth):";
leftPosition "512";
rightPosition "688";
topPosition "800";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "448";
fontList "7x13bold";
labelString "Simulated P(death):";
leftPosition "512";
rightPosition "688";
topPosition "416";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "864";
fontList "7x13bold";
labelString "Simulated P(death):";
leftPosition "512";
rightPosition "688";
topPosition "832";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "480";
fontList "7x13bold";
labelString "Number of Balks:";
leftPosition "512";
rightPosition "688";
topPosition "448";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "896";
fontList "7x13bold";
labelString "Number of Balks:";
leftPosition "512";
rightPosition "688";
topPosition "864";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "512";
fontList "7x13bold";
labelString "Balks/Births:";
leftPosition "512";
rightPosition "688";
topPosition "480";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "928";
fontList "7x13bold";
labelString "Balks/Births:";
leftPosition "512";
rightPosition "688";
topPosition "896";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "544";
fontList "7x13bold";
labelString "Current Queue State:";
leftPosition "512";
rightPosition "688";
topPosition "512";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "960";
fontList "7x13bold";
labelString "Current Queue State:";
leftPosition "512";
rightPosition "688";
topPosition "928";
\end_figure\begin_figure {XmLabel}
\figure_name "l_exstate2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "736";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "704";
\end_figure\begin_figure {XmLabel}
\figure_name "l_exstate1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "320";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "288";
\end_figure\begin_figure {XmLabel}
\figure_name "l_emptprob2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "800";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "768";
\end_figure\begin_figure {XmLabel}
\figure_name "l_emptprob1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "384";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "352";
\end_figure\begin_figure {XmLabel}
\figure_name "l_simbp2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "832";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "800";
\end_figure\begin_figure {XmLabel}
\figure_name "l_simbp1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "416";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "384";
\end_figure\begin_figure {XmLabel}
\figure_name "l_simdp2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "864";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "832";
\end_figure\begin_figure {XmLabel}
\figure_name "l_simdp1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "448";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "416";
\end_figure\begin_figure {XmLabel}
\figure_name "l_curstate2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "960";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "928";
\end_figure\begin_figure {XmLabel}
\figure_name "l_btob2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "928";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "896";
\end_figure\begin_figure {XmLabel}
\figure_name "l_balks2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "896";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "864";
\end_figure\begin_figure {XmLabel}
\figure_name "l_curstate1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "544";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "512";
\end_figure\begin_figure {XmLabel}
\figure_name "l_btob1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "512";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "480";
\end_figure\begin_figure {XmLabel}
\figure_name "l_balks1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "480";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "448";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "0";
bottomPosition "704";
fontList "8x13bold";
labelString "Simulation Results:";
leftPosition "512";
rightPosition "688";
topPosition "672";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
borderWidth "0";
bottomPosition "288";
fontList "8x13bold";
labelString "Simulation Results:";
leftPosition "512";
rightPosition "688";
topPosition "256";
\end_figure\begin_figure {XmPushButton}
\figure_name "untitled2_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"textbox32\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_okay\")"
bottomPosition "144";
fontList "*times-*-r-*-*-20-*";
labelString "What do the
stats mean?";
leftPosition "304";
rightPosition "432";
topPosition "48";
\end_figure\begin_figure {XmPushButton}
\figure_name "untitled2_XmPushButton0" 
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"textbox31\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"pb_okay\")"
bottomPosition "144";
fontList "*times-*-r-*-*-20-*";
labelString "How do I use
this screen?";
leftPosition "176";
rightPosition "304";
topPosition "48";
\end_figure\begin_figure {CmLabel}
\figure_name "textbox31" 
bottomPosition "992";
label "There are several pushbuttons and sliders available to aid you in running the experiments.  Here is a rundown of them:
      
A) @b(Run the Queue Simulator pushbutton).  Initializes many variables and allows you to access further pushbuttons. 
     Must be selected to start any experiments.  
      
B) @b(Reset the Queue and Run Experiments pushbuttons).  All three of these buttons initialize all of the queue 
     simulation variables to zero and clear the queue state distributions.  The reset button retains the current 
     experiment type while the other buttons change the experiment type as selected.
       
C) @b(Parameter Sliders).  The proper sliders are presented once the experiment type is selected.  The sum of the birth 
     and death probabilities for any one queue is not allowed to exceed one, and the birth probability must not equal or 
     exceed the death probability for any given queue because this would cause the queue length to blow up and the 
     queue state display, being limited to the first thirty states, is not equipped to show this.  Although these sliders 
     may be changed during an experiment, it is advised that they be set only once per experiment before any trials 
     are run.
        
D) @b(Maximum queue length slider and pushbuttons).  These allow either an infinite queue or one restrained in 
     length between one and twenty-nine.  Again, it is advised that this parameter is set only at the beginning of an 
     experiment.
      
E) @b(Trial pushbuttons).  These buttons run a batch of up to 100,000 simulated trials.  ";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "992";
topPosition "0";
\end_figure\begin_figure {CmLabel}
\figure_name "textbox32" 
bottomPosition "992";
label "Here is a rundown of the various stats and their signifigance:
         
A) @b(Birth-Death Ratio).  The ratio of birth probability over death probability for the queue.  This stat is constantly 
     updated whenever the sliders are adjusted.
     
B) @b(Expected Queue State).  The @i(simulated) expected state of the queue.
               
C) @b(Expected Queue Length).  The @i(simulated) expected length of the queue.
      
D) @b(P(empty server)).  The @i(simulated) probability of arriving into the queue when the server is unoccupied.  This is 
      equivalent to the value of the queue state barchart, which is simply the probability that the queue is in state zero.
      
E) @b(Simulated P(birth)).  The @i(simulated) probability of birth.  It should be very close to the value shown on the slider.
        
F) @b(Simulated P(death)).  The @i(simulated)  probability of death.  Note that it never exceeds P(birth).  This is because 
     the accumulated number of deaths in an experiment of this nature cannot exceed the number of births because 
     deaths cannot occur when the queue is empty.  The value on the slider represents the probability of death for one 
     trial, but this statistic is  calculated using the observed number of deaths that have occurred.
        
G) @b(Number of Balks).  Only relevent in the finite queue case, this number represents the number of births that 
     were prevented because the queue was already at its maximum length.
         
H) @b(Balks/Births).  This number represents additional percentage of customers that would have arrived if the 
     queue was of infinite length.
         
I) @b(Current Queue State).  The current state (not length) of the queue.
       
J) @b(Maximum Q2 S.T.V. / Q1 S.T.V.).  Only shown for queue #2 when the service time variance
      experiment is being run, this number is the maximum allowable ratio of queue #2 service 
      time variance over queue #1 service time variance.  This restriction is due to the manner in 
      which this experiment is constructed.  If the slider for this parameter is set higher than this
      value, then the program defaults to this value.";
leftPosition "0";
mappedWhenManaged "False";
rightPosition "992";
topPosition "0";
\end_figure\begin_figure {XmLabel}
\figure_name "l_ratio" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "992";
fontList "7x13bold";
labelString "Max. Q2 S.T.V./Q1 S.T.V.:";
leftPosition "496";
mappedWhenManaged "False";
rightPosition "688";
topPosition "960";
\end_figure\begin_figure {XmLabel}
\figure_name "l_maxratio" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "992";
fontList "7x13bold";
labelString "0";
leftPosition "688";
mappedWhenManaged "False";
rightPosition "752";
topPosition "960";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "320";
fontList "7x13bold";
labelString "Expected Queue State:";
leftPosition "512";
rightPosition "688";
topPosition "288";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "768";
fontList "7x13bold";
labelString "Expected Queue Length:";
leftPosition "512";
rightPosition "688";
topPosition "736";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
alignment "ALIGNMENT_END";
borderWidth "0";
bottomPosition "352";
fontList "7x13bold";
labelString "Expected Queue Length:";
leftPosition "512";
rightPosition "688";
topPosition "320";
\end_figure\begin_figure {XmLabel}
\figure_name "l_exlen2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "768";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "736";
\end_figure\begin_figure {XmLabel}
\figure_name "l_exlen1" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "352";
fontList "7x13bold";
labelString "0";
leftPosition "688";
rightPosition "752";
topPosition "320";
\end_figure

\end_screen
\end_page

\begin_page{the_end}
\title{The End!}
\begin_screen
\begin_figure {CmLabel}
\figure_name "credits" 
\mapping "True"
borderWidth "0";
bottomPosition "928";
fontSize "big";
label "@c[
@b(CDS) is the result of years of hard work by students,
staff, and faculty.   Members of @b(Project CDS)  are:
@b( )
Al Drake,
Ed Moriarty,  
Dept. of Electrical Engineering & Computer Science
@b()
Jon C. Haass   
Dept. of Mathematics
@b( )
Joe Wang
Sourabh Niyogi
Marc Schaub
John Piscitello
Jason Beardsley
Jeff Turcotte
Adam Feder
@b( )
A special thanks is extended to the @b(UROP) 
office, whose funding and support is 
greatly appreciated.]";
leftPosition "160";
rightPosition "880";
topPosition "32";
xFlag "left";
yFlag "top";
\end_figure

\end_screen
\end_page

\begin_page{three_main_screens}
\title{three main screens}
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
bottomPosition "992";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Three Main Screens:
      
1)  Basic Queuing System
      
2)  Queue Convergence
      
3)  Queue Simulator";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure
\end_screen
\end_page

\begin_page{queue_convergence_info}
\title{queue convergence info}
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled2_XmLabel0" 
bottomPosition "992";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Queue Convergence:
       
1)  It Takes A LOT of Trials to Converge
     
2)  Transient and Steady States Displayed
     
3)  Barchart Display Has Many Features";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure
\end_screen
\end_page

\begin_page{basic_queuing_system_info}
\title{basic queuing system info}
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled3_XmLabel0" 
bottomPosition "992";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Basic Queuing System:
     
1)  Shows A Physical Queuing System
    
2)  Supplies Basic Background
      
3)  Introduces Queue Type Used in Program";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure
\end_screen
\end_page

\begin_page{queue_simulator_info}
\title{queue simulator info}
\begin_screen
\begin_figure {XmLabel}
\figure_name "untitled4_XmLabel0" 
bottomPosition "992";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Queue Simulator:
      
1)  Runs Two Queues Simultaneously for Comparison
     
2)  Birth-Death Ratio and Service Time Variance Experiments
     
3)  Variable Parameters:  Maximum Length, Probabilities
        
4)  Many Simulation Statistics Are Displayed";
leftPosition "0";
rightPosition "992";
topPosition "0";
\end_figure

\end_screen
\end_page
