%{ 
/* $Date: 91/07/18 17:43:21 $    $Revision: 1.3 $  by $Author: joe $ */
/*
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.
*/
%}

%token BEGIN_PAGE END_PAGE
%token BEGIN_OUTLINE END_OUTLINE
%token SCREEN_TEXT VERSION_TOKEN
%token NAME_TOKEN TITLE_TOKEN KEYWORD_TOKEN
%token PAGE_CONSTRUCTOR_TEXT_TOKEN PAGE_ENTRY_TEXT_TOKEN PAGE_EXIT_TEXT_TOKEN
%token GROUP STRING_TOKEN

%start nav_parser

%{
#include <CDS.h>
#include <CmPage.h>
#include <CmCDS.h>
#include <CmNavigatorParser.h>
#include <CmNavigatorOutliner.h>
#include <CmNavigatorHeap.h>

static void handle_quote(CmString &string);
%}

%%

nav_parser	:  version
		   outline
                   pages;


version 	: | VERSION_TOKEN  STRING_TOKEN
	 	{ 
			if (CDSPtr->Version != ((CmString) string_token)) {
			cmdebug << "Attempting to load version " << string_token
			  << " with CDS version " << 
			  CDSPtr->Version  << "\n";
			cmdebug << "Attempting to run cds_converter\n";
			CmString str = "cds_converter ";
			str += current_filename; str += " ";
			str += string_token; str += " ";
			str += CDSPtr->Version;
			system(str.Chars()); }
		};

outline		: BEGIN_OUTLINE
                  outline_items
                  END_OUTLINE {
	cmdebug << "Finishing loading outline";
};

outline_items	: outline_item
		| outline_items outline_item;

outline_item	: STRING_TOKEN {
			outliner->AppendItemToOutline(string_token);
			cmdebug << "Appending: " << string_token 
				<< " to outliner";
			};	

pages		: page
        	| pages page;

page		: BEGIN_PAGE GROUP {
			current_page = new CmPage(string_token);
		}
		  page_items
		  END_PAGE {
			heap->AppendPageToHeap(current_page);
		}
                | error END_PAGE {
                        cerr << "Error loading page";
                };

page_items	: page_item
            	| page_items page_item;

page_item	: title 

		| keywords 
                | page_constructor_text
		| page_entry_text	
		| page_exit_text

           	| SCREEN_TEXT {
		  current_page->ScreenDefinitionString = 
			 string_token;
		}
		| error;
  
title		: TITLE_TOKEN
		  GROUP { 
			current_page->Title =
			 string_token; 
		};

page_constructor_text	: PAGE_CONSTRUCTOR_TEXT_TOKEN
                  STRING_TOKEN
		{ 
			current_page->PageConstructorText =
				 string_token; 
			handle_quote(current_page->PageConstructorText);
		};

page_entry_text	: PAGE_ENTRY_TEXT_TOKEN
                  STRING_TOKEN
		{ 
			current_page->PageEntryText =
				 string_token; 
			handle_quote(current_page->PageEntryText);

		};

page_exit_text	: PAGE_EXIT_TEXT_TOKEN
                  STRING_TOKEN
		{ 
			current_page->PageExitText =
				 string_token; 
			handle_quote(current_page->PageExitText);
		};

keywords	: KEYWORD_TOKEN 
		  GROUP
		| keywords GROUP;


%%

CmNavigatorParser::CmNavigatorParser(CmCDS* cds,
				     CmNavigatorOutliner *out,
				     CmNavigatorHeap *hea) {
   CDSPtr = cds; outliner = out; heap = hea;
}

CmVoid CmNavigatorParser::ParseFile(const CmString & filename) {
  FILE *file_ptr;

  current_filename = filename;  
  file_ptr = fopen(filename.Chars(), "r");

  if (file_ptr) {	
    SetParserInput(file_ptr);
    yyparse();
  } else
    cerr << "File not found\n";

  fclose(file_ptr);
}

static void handle_quote(CmString &string) {
   string.Gsub("\\\"", "\"");
}
