/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/parameter/RCS/ParameterP.h,v 3.1 91/01/03 17:51:36 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtParameterP_h
#define _AtParameterP_h

#include <Xm/XmP.h>

#ifdef _AtDevelopment_
#include "Parameter.h"
#else
#include <At/Parameter.h>
#endif

/*  The Parameter Widget Class and instance records  */

typedef struct {int foo;} AtParameterClassPart;

/*  Full class record declaration        */

typedef struct _AtParameterClassRec
{
    CoreClassPart           core_class;
    XmPrimitiveClassPart    primitive_class;
    AtParameterClassPart    parameter_class;
} AtParameterClassRec;

extern AtParameterClassRec atParameterClassRec;

/*  The Parameter instance record  */

typedef struct _AtParameterPart
{
    /* resources */
    char            *labelString;
    char            *unitString;
    char            *fontFamily;
    int             fontSize; 
    double          value;
    double          min;
    double          max;
    double          increment;
    Boolean         integerMode;
    Boolean         geometricMode;
    String          format;
    double          multiplier;
    XtCallbackList  valueChangedCallback;
    int             initialDelay;
    int             repeatDelay;
    
    /* PRIVATE members -- values computed by ParameterWidgetClass methods */
    XmArrowButtonWidget    up_arrow_child;
    XmArrowButtonWidget    down_arrow_child;
    XmTextWidget           text_child;
    char                   valuestring[20];
    
    Pixmap                 stipple_pm;
    GC                     normal_GC;
    GC                     insensitive_GC;
    AtText                 *unit;
    AtText                 *label;                 
    AtFontFamily           *at_font_family;
    int                    label_xpos;
    int                    label_ypos;
    int                    unit_xpos;
    int                    unit_ypos;
    XtIntervalId           timer;
} AtParameterPart;

typedef struct _AtParameterRec
{
   CorePart           core;
   XmPrimitivePart    primitive;
   AtParameterPart    parameter;
} AtParameterRec;

#endif _AtParameterP_h
/* DON'T ADD ANYTHING AFTER THIS #endif */













