(define top 460)
(define bottom 992)
(define height 1)
(define numa 2)
(define numb 4)
(define temp 0)
(define suma 1)
(define sumb 1)
(define pmfa_list '(0.7 0.3 0 0))
(define pmfb_list '(0 0.5 0.3 0.2))
(define pmfc_list '(0 0 0 0))

(define plus "@#+@#")
(define pls "_+_")
(define equals "@#=@#")
(define times "@#*@#")
(define newline "@.")
(define space "@#")
(define open_center "@c{")
(define close_center "}")

(define (update-border name)
  (define sum 0)
  (if (eq? name "pmfa_text") (set! sum suma) (set! sum sumb))  
  (if (= sum 1)
      (cds-figure-set-resource "$CDS_THIS_PAGE" name "borderWidth" 6)
      (if (= (get-resource name "borderWidth")6)
	  (cds-figure-set-resource "$CDS_THIS_PAGE" name "borderWidth" 1))))

(define pmfa_scale_list (list "scale_Pa"[0] "scale_Pa"[1] "scale_Pa"[2]
			      "scale_Pa"[3]))
(define pmfb_scale_list (list "scale_Pb"[0] "scale_Pb"[1] "scale_Pb"[2]
			      "scale_Pb"[3]))

(define (extend l a)
   (if (null? (cdr l))
       (cons (car l) (cons a nil))
       (cons (car l) (extend (cdr l) a))))

(define (dindex l i j )
  (if (or (= i 0) (null? (cdr l)))
      (nth (car l) j)
      (dindex (cdr l) (- i 1) j)))

(define (nth l i)
  (if (or (= i 0) (null? (cdr l)))
      (car l) 
      (nth (cdr l) (- i 1))))

(define (length l)
  (if (atom? l)
      0
      (+ (length (cdr l)) 1)))

(define (total l i)
  (if (or (null? l) (= i 0))
      0
      (+ (total (cdr l) (- i 1)) (car l))))

(define (max l)
  (define (iter lst max)
    (if (null? lst) 
        max
        (if (> (car lst) max)
	    (iter (cdr lst) (car lst))
	    (iter (cdr lst) max))))
  (iter l (car l)))


(define (min l)
  (define (iter lst min)
    (if (null? lst) 
        min
        (if (< (car lst) min)
	    (iter (cdr lst) (car lst))
	    (iter (cdr lst) min))))
  (iter l (car l)))


(define (replace-nth lst num newitem)
  (cond ((null? lst) lst)
        ((< num 0) lst)
        ((= num 0) (cons newitem (cdr lst)))
        ((> num 0) (cons (car lst)
                         (replace-nth (cdr lst) (- num 1) newitem)))))

(define (sublist l i)
    (if (or (<= i 0) (null? l))
	"nil"
	(cons (car l) (sublist (cdr l) (- i 1)))))

(define (head l i)
  (if (null? (cdr l))
      (if (= i 0)       
	  (list 0)
	  l)
      (if (= i 0)
	  (cons 0 (head (cdr l) 0))
	  (cons (car l) (head (cdr l) (- i 1))))))

(define (vector-multiply a b)
  (if (or (null? (cdr a)) (null? (cdr b)))
      (cons (* (car a) (car b)) "nil")
      (cons (* (car a) (car b)) (vector-multiply (cdr a) (cdr b)))))

(define (reverse l)
  (define (iter l n)
    (if (null? l) 
	n
	(iter (cdr l) (cons (car l) n))))
  (iter l "nil"))

(define (update-pmfa-text num)
  (define text (nth pmfa_list 0))
  (for (i 1 num)
       (if (< i num)
	   (set! text (string-append text plus (nth pmfa_list i)))
	   (set! text (string-append text equals suma))))
  (cds-figure-set-resource "$CDS_THIS_PAGE" "pmfa_text" "label" text))

(define (update-pmfb-text num)
  (define text (nth pmfb_list 0))
  (for (i 1 num)
       (if (< i num)
	   (set! text (string-append text plus (nth pmfb_list i)))
	   (set! text (string-append text equals sumb))))
  (cds-figure-set-resource "$CDS_THIS_PAGE" "pmfb_text" "label" text))

(define (make-label-box a b offset ht)
  (define name (string-append "["
			      (number->string a) ","
			      (number->string b) "]"))
  (create-figure name "CmLabel")
  (place-figure name 0 (+ top (* ht offset)) 220 ht)
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "fontSize" "medbig")
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "label" name))

(define (make-sum-box a b offset ht)
  (define name (string-append "sum" a b))
  (create-figure name "CmLabel")
  (place-figure name 440 (+ top (* ht offset)) 220 ht)
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "fontSize" "medbig")
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "label" 
		(string-append "@^6[@b{"
			       a plus b equals (+ a b) '}])))
  
(define (make-prob-box a b offset ht)
  (define name (string-append "prob" a b))
  (create-figure name "CmLabel")
  (place-figure name 220 (+ top (* ht offset)) 220 ht)
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "fontSize" "medbig")
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "label" 
		(string-append '@^6[@b{ (nth pmfa_list a) times (nth pmfb_list b)
		 equals (* (nth pmfa_list a) (nth pmfb_list b)) '}])))

(define (make-csum-box a offset ht)
  (define name (string-append "C" a))
  (create-figure name "CmLabel")
  (place-figure name 660 (+ top (* ht offset)) 316 ht)
  (define first "t")
  (define csum 0)
  (define label "nil")
  (for (i 0 (- numa 1))
       (for (j 0 (- numb 1))
	    (if (= a (+ i j)) (for (k 0 0)
		(set! temp (* (nth pmfa_list i) (nth pmfb_list j)))
		(if first (for (l 0 0)
		    (set! label temp) (set! first "nil"))
		    (set! label (string-append label plus temp)))
		(set! csum (+ csum temp))))))
  (set! label 
	(string-append "@^6{@b{P@-{c}["
		       (number->string a)
		       "]" equals label equals csum "}}"))
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "fontSize" "medbig")
  (cds-figure-set-resource "$CDS_THIS_PAGE" name "label" label))

(define (convolve-ith a b i)
  (define temp 0)
  (for (j 0 (- (length a) 1))
       (for (k 0 (- (length b) 1))
	    (if (= i (+ j k))
		(set! temp (+ temp (* (nth a j) (nth b k)))))))
  temp)
	    
(define (rest a l)
  (define ln (length a))
  (cond ((< l 0) "nil")
	((= ln l) a)
	((> ln l) (rest (cdr a) l))
	((< ln l) (rest (cons 0 a) l))))

(define (Convolve a b)
  (define out_list "nil")
  (define rb (reverse b))
  (for (tmp 1 (- (+ (length a) (length b)) 1))
    (set! out_list
      (cons (total (vector-multiply a (rest rb tmp)) tmp) out_list)))
  (reverse out_list))

(define (append l1 l2)
  (if (null? l1)
      l2
      (cons (car l1) (append (cdr l1) l2))))

(define (map proc lst)
  (cond ((null? lst) "nil")
        ((= 1 1) (cons (proc (car lst)) (map proc (cdr lst))))))

(define (list-to-string l)
  (if (null? (cdr l))
      (car l)
      (string-append (car l) "___" (list-to-string (cdr l)))))

(define prec2 (lambda (x) (precision x 2)))

(define (position-pmfa-label i)
  (if (< i 0)
      (place-figure "pmfa_label" 88 800 308 48)
      (place-figure "pmfa_label" (+ 136 (* 86 i)) 800 308 48)))

(define (position-pmfb-label i)
  (if (< i 0)
      (place-figure "pmfb_label" 88 848 308 48)
      (place-figure "pmfb_label" (+ 136 (* 86 i)) 848 308 48)))

(define (list-to-sum l)
 (define (iter lst string total)
   (if (null? (cdr lst)) 
       (string-append string (car lst) equals (+ total (car lst)))
       (iter (cdr lst) (string-append string (car lst) pls) (+ total (car lst)))))
  (iter l ' 0))

(define (update-ith-sum-label i)
  (if (eq? slid_pmf "b")
      (cds-figure-set-resource "$CDS_THIS_PAGE" "ith_sum_label" "label"
	       (string-append '@b{ (list-to-sum (map prec2 (vector-multiply pmfa_list 
			    (rest (reverse pmfb_list) (+ 1 i))))) '} ))
      (cds-figure-set-resource "$CDS_THIS_PAGE" "ith_sum_label" "label"
	       (string-append '@b{ (list-to-sum (map prec2 (vector-multiply pmfb_list 
			    (rest (reverse pmfa_list) (+ 1 i))))) '}))))

(define (update-pmfc-label i)
  (if (< i 0)
      (cds-figure-set-resource "$CDS_THIS_PAGE" "pmfc_label" "label" '@b{0.00})
      (cds-figure-set-resource "$CDS_THIS_PAGE" "pmfc_label" "label"
		    (string-append '@b{ (list-to-string 
			  (map prec2 (sublist pmfc_list (+ 1 i)))) '}))))

(define (set-bernoulli)
  (cds-figure-show "$CDS_THIS_PAGE" "define_a")
  (cds-figure-show "$CDS_THIS_PAGE" "define_b")
  (cds-figure-set-resource "$CDS_THIS_PAGE" (string-append "define_" current_pmf) "set" "true")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_p")
  (cds-figure-show "$CDS_THIS_PAGE" "label_bernoulli")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_binomial")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_geometric")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_pascal")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_PMFC")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_random")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_n")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_num_points")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_start_at")
  (cds-figure-hide "$CDS_THIS_PAGE" "set_to_this")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_r")
  (set! pmf_type "bernoulli"))

(define (set-binomial)
  (cds-figure-show "$CDS_THIS_PAGE" "define_a")
  (cds-figure-show "$CDS_THIS_PAGE" "define_b")
  (cds-figure-set-resource "$CDS_THIS_PAGE" (string-append "define_" current_pmf) "set" "true")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_p")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_n")
  (cds-figure-show "$CDS_THIS_PAGE" "label_binomial")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_bernoulli")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_geometric")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_pascal")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_PMFC")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_random")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_num_points")
  (cds-figure-hide "$CDS_THIS_PAGE" "set_to_this")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_start_at")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_r")
  (set! pmf_type "binomial"))

(define (set-geometric)
  (cds-figure-show "$CDS_THIS_PAGE" "define_a")
  (cds-figure-show "$CDS_THIS_PAGE" "define_b")
  (cds-figure-set-resource "$CDS_THIS_PAGE" (string-append "define_" current_pmf) "set" "true")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_p")
  (cds-figure-show "$CDS_THIS_PAGE" "label_geometric")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_bernoulli")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_binomial")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_pascal")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_PMFC")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_random")
  (cds-figure-hide "$CDS_THIS_PAGE" "set_to_this")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_num_points")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_start_at")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_r")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_n")
  (set! pmf_type "geometric"))

(define (set-pascal)
  (cds-figure-show "$CDS_THIS_PAGE" "define_a")
  (cds-figure-show "$CDS_THIS_PAGE" "define_b")
  (cds-figure-set-resource "$CDS_THIS_PAGE" (string-append "define_" current_pmf) "set" "true")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_p")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_r")
  (cds-figure-show "$CDS_THIS_PAGE" "label_pascal")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_bernoulli")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_binomial")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_geometric")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_PMFC")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_random")
  (cds-figure-hide "$CDS_THIS_PAGE" "set_to_this")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_num_points")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_start_at")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_n")
  (set! pmf_type "pascal"))

(define (set-c)
  (set! pmf_type "pmfc")
  (cds-figure-show "$CDS_THIS_PAGE" "set_to_this")
  (cds-figure-show "$CDS_THIS_PAGE" "define_a")
  (cds-figure-show "$CDS_THIS_PAGE" "define_b")
  (cds-figure-set-resource "$CDS_THIS_PAGE" (string-append "define_" current_pmf) "set" "true")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_num_points")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_start_at")
  (cds-figure-show "$CDS_THIS_PAGE" "label_PMFC")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_bernoulli")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_binomial")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_geometric")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_pascal")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_random")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_r")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_n")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_p"))

(define (set-random)
  (set! pmf_type "random")
  (cds-figure-show "$CDS_THIS_PAGE" "define_a")
  (cds-figure-show "$CDS_THIS_PAGE" "define_b")
  (cds-figure-set-resource "$CDS_THIS_PAGE" (string-append "define_" current_pmf) "set" "true")
  (cds-figure-show "$CDS_THIS_PAGE" "scale_num_points")
  (cds-figure-show "$CDS_THIS_PAGE" "label_random")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_bernoulli")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_binomial")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_geometric")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_pascal")
  (cds-figure-hide "$CDS_THIS_PAGE" "label_PMFC")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_n")  
  (cds-figure-hide "$CDS_THIS_PAGE" "set_to_this")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_p")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_r")
  (cds-figure-hide "$CDS_THIS_PAGE" "scale_start_at"))





