/* c formating of numbers */
/* This object file defines an elk primitive (number->fstring) which
   allows C-like formatting of floating point numbers */

#include <stdio.h>
#include <scheme.h>

Object P_Number_To_Fstring(Object format, Object number) {
  char *buf;
  char *str;
  double value;

  Check_Type(format, T_String);
  Check_Number(number);

  switch (TYPE(number)) {
  case T_Fixnum: case T_Bignum:
    value = (double) Get_Integer(number);
    break;
  case T_Flonum:
    value = (double) FLONUM(number)->val;
    break;
  }

  str = Get_Bytes(STRING(format)->size + 1);
  bcopy(STRING(format)->data, str, STRING(format)->size);
  str[STRING(format)->size] = '\000';
  buf = Get_Bytes(STRING(format)->size + 32);
  sprintf (buf, str, value);
  return Make_String (buf, strlen (buf));
}



void init_number_to_fstring () {
  Define_Primitive(P_Number_To_Fstring, "number->fstring", 2, 2, EVAL);
}

