/* $Date: 91/12/11 15:46:08 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*******************************************************************
 CmCDS.h - CDS Encapsulating Object (Courseware Development System)
 Contact: sniyogi, maschaub

 CmCDS:
  Widget structure:
      form - sole purpose is to organize its children:
       workarea - where lecture file widgets are displayed
       collections - contains trashcan and clipboard
       CmMenu - menubar

  Constructor:
   Creates all widgets above.
   Creates global model. ls
   Creates navigator, which sets up the initial widgets.
   Creates editor.

  Destructor: 
   Destroys all CDS objects created in the constructor.
 *******************************************************************/
#ifndef _CMCDS
#define _CMCDS

#include <CDS.h>

class CmFigureEditor;
class CmNavigator;
class CmModel;
class CmMenu;

class CmCDS {
 private:
  // CmCDS Widgets
  Widget toplevel;
  Widget pane_widget;
  Widget workarea;
  Widget collections;
  CmMenu* menu;
  
  // CmCDS Objects
  CmFigureEditor* editor;
  CmNavigator* navigator;
  CmModel* model;

  CmBool keep_looping;
  XtAppContext app_context;
 public:
  CmCDS(int*, char**); // Constructor
  ~CmCDS();            // Destructor

  // Selectors:
  Widget TopLevel()   { return(toplevel); }
  Widget Collections() { return(collections); }
  CmString Version;
  CmString ConfigDir;

  CmMenu* Menu() { return(menu); }
  CmFigureEditor* Editor() { return(editor); }
  CmNavigator* Navigator() { return(navigator); }
  CmModel* Model() { return(model); }
  XtAppContext AppContext() {return(app_context);}
  void StartEventLoop();
  void StopEventLoop();
  void Error(const CmString &);
  void ShowWaitCursor();
  void ShowNormCursor();
  CmString NextToken(const char * &);
};
#endif


