/* $Date: 91/12/11 16:46:43 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
#include <CDS.h>

#define MAXITEMS 30
#define MAXARGS 20
#define MAXOPTIONS 50
#define CMDIALOG_PANE_WIDTH 10
#define CMDIALOG_PANE_HEIGHT 10

/* #define's for arguments */
#define CMDIALOG_ALIGNMENT 0
#define CMDIALOG_PIXMAP 1
#define CMDIALOG_SELECTION_POLICY 2
#define CMDIALOG_NUMVISIBLE 3
#define CMDIALOG_VALUE 4
#define CMDIALOG_DECIMAL_POINTS 5
#define CMDIALOG_MAX 6
#define CMDIALOG_MIN 7
#define CMDIALOG_ORIENTATION 8
#define CMDIALOG_PROCESS_DIRECTION 9
#define CMDIALOG_SHOW_VALUE 10
#define CMDIALOG_SEPARATOR_TYPE 11
#define CMDIALOG_MAX_LENGTH 12
#define CMDIALOG_VALUE_POINTER 13
#define CMDIALOG_MODAL 14
#define CMDIALOG_MODELESS 15
#define CMDIALOG_OPTION 16
#define CMDIALOG_RADIOBUTTON 17
#define CMDIALOG_INCREMENT 18
#define CMDIALOG_FORMAT 19
#define CMDIALOG_SELECTED 20
#define CMDIALOG_EDITMODE 21
#define CMDIALOG_ROWS 22
#define CMDIALOG_COLUMNS 23
#define CMDIALOG_UNITS 24
#define CMDIALOG_SCROLLED_TEXT 25

/* #define's for options to arguments */
#define CMDIALOG_LEFT 0 
#define CMDIALOG_CENTER 1
#define CMDIALOG_RIGHT 2
#define CMDIALOG_TRUE 3
#define CMDIALOG_FALSE 4
#define CMDIALOG_SINGLE 5
#define CMDIALOG_MULTIPLE 6
#define CMDIALOG_VERTICAL 7
#define CMDIALOG_HORIZONTAL 8
#define CMDIALOG_LEFT_TO_RIGHT 9
#define CMDIALOG_RIGHT_TO_LEFT 10
#define CMDIALOG_SINGLE_LINE 11
#define CMDIALOG_DOUBLE_LINE 12
#define CMDIALOG_SINGLE_DASHED_LINE 13
#define CMDIALOG_DOUBLE_DASHED_LINE 14
#define CMDIALOG_NO_LINE 15
#define CMDIALOG_SHADOW_ETCHED_IN 16
#define CMDIALOG_SHADOW_ETCHED_OUT 17
#define CMDIALOG_ON 18
#define CMDIALOG_OFF 19
#define CMDIALOG_MULTI_LINE 20
  
/* attach methods */
enum CmDialogAttachMethod {
  CMDIALOG_ATTACH_NONE,
  CMDIALOG_ATTACH_LEFT,
  CMDIALOG_ATTACH_TOP
};

/* item types */
enum CmDialogItemType {
  CMDIALOG_LABEL,
  CMDIALOG_LIST,
  CMDIALOG_PUSHBUTTON,
  CMDIALOG_RADIOBOX,
  CMDIALOG_SCALE,
  CMDIALOG_SEPARATOR,
  CMDIALOG_TEXTSTRING,
  CMDIALOG_TOGGLEBUTTON
  };

// definitions for convenience routines
enum CmDialogXmDialogType {
  CMDIALOG_ERROR,
  CMDIALOG_INFORMATION,
  CMDIALOG_MESSAGE,
  CMDIALOG_QUESTION,
  CMDIALOG_WARNING,
  CMDIALOG_WORKING
};
#define CMDIALOG_OK 6
# define CMDIALOG_CANCEL 7
#define CMDIALOG_HELP 8

// needed for data_pack and other classes 
class CmDialog;
class CmDialogItem;

typedef void (*ReceiverPtr)(const CmString&);

/************************** Pane Class  **************************/

class CmDialogPane {
public:
  CmDialogPane(Widget,const CmString&,Widget,char, Boolean);
  ~CmDialogPane();
  CmString PaneName;
  Widget BasePane, Title;
  CmString AttachPane;
  CmDialogAttachMethod AttachMethod;
};

/*************************** Item Classes *************************/

/*********************** Item class used by Dialog ****************/
class CmDialogItem {
public:
  Widget ItemWidget;
  CmDialogItem() {}
  ~CmDialogItem();
  CmDialog *Dialog;
  CmString PaneName, ItemName;
  CmDialogItemType ItemType;
  virtual void AddOption(char,XtArgVal);
  virtual void ManageItem();
  virtual CmString GetValue();
  virtual void SetValue(const CmString&);
  virtual Widget GetWidget();
  Widget GetBasePane() const;
  void AddCallback(Widget, String);
};


class CmDialogLabel:public CmDialogItem {
private:
  CmString default_value;
  Arg labelargs[MAXARGS];
  int count;
  CmString widget_name;
public:
  CmDialogLabel() {count = 0; widget_name = "CmDialogLabel";};
  ~CmDialogLabel();
  void AddOption(char,XtArgVal);
  void ManageItem();
  void SetValue(const CmString &);
};

class CmDialogList:public CmDialogItem  {
private:
  Widget rowcol,label;
  CmString default_value;
  Arg listargs[MAXARGS];
  CmString selected, widget_name, options[MAXOPTIONS];
  int count, num_options;
public:
  CmDialogList() {
    count = 0; 
    num_options = 0; 
    widget_name = "CmDialogList";
    };
  ~CmDialogList();
  void AddOption(char,XtArgVal);
  void ManageItem();
  CmString GetValue();
  void SetValue(const CmString&);
};


class CmDialogPushButton:public CmDialogItem  {
private:
  CmString default_value;
  Arg pbargs[MAXARGS];
  int count;
  CmString widget_name;
public:
  CmDialogPushButton() {count = 0;
		      widget_name = "CmDialogPushButton";
		      };
  ~CmDialogPushButton();
  void AddOption(char,XtArgVal);
  void ManageItem();
};

class CmDialogRadioBox:public CmDialogItem  {
private:
  Widget rbutton[MAXOPTIONS];
  CmString selected;
  int num_rbuttons;
  CmString widget_name, rbname, rbuttonname;
  CmString rbutton_name[MAXOPTIONS];
public:
  CmDialogRadioBox() {num_rbuttons= 0; 
		      widget_name = "CmDialogRadioBox";};
  ~CmDialogRadioBox();
  void AddOption(char,XtArgVal);
  void ManageItem();
  CmString GetValue();
};
 
class CmDialogScale:public CmDialogItem  {
private:
  CmString default_value;
  Arg scaleargs[MAXARGS];
  int count;
  CmString widget_name;
public:
  CmDialogScale() {count = 0; widget_name = "CmDialogScale";};
  ~CmDialogScale();
  void AddOption(char,XtArgVal);
  void ManageItem();
  CmString GetValue();
};

class CmDialogSeparator:public CmDialogItem  {
private:
  CmString default_value;
  Arg separgs[MAXARGS];
  int count;
  CmString widget_name;
public:
  CmDialogSeparator() {count = 0; widget_name = "CmDialogSeparator";};
  ~CmDialogSeparator();
  void AddOption(char,XtArgVal);
  void ManageItem();
};

class CmDialogTextString:public CmDialogItem  {
private:
  Widget rowcol,label,text;
  CmString default_value;
  Arg rowcolargs[MAXARGS],labelargs[MAXARGS], textargs[MAXARGS];
  int rowcolcount, labelcount, textcount;
  CmString widget_name, rowcolname, labelname, textname;
  Boolean ScrollBars;
public:
  CmDialogTextString() {rowcolcount = 0; 
			labelcount = 0; 
			textcount = 0;
		        ScrollBars = False;
		        widget_name = "CmDialogTextString";};
  ~CmDialogTextString();
  void AddOption(char,XtArgVal);
  void ManageItem();
  CmString GetValue();
  void SetValue(const CmString&);
};

class CmDialogToggleButton:public CmDialogItem  {
private:
  CmString default_value;
  CmString widget_name;
  Boolean button_set;
public:
  CmDialogToggleButton() {button_set = False; widget_name = "CmDialogToggleButton";};
  ~CmDialogToggleButton();
  void AddOption(char,XtArgVal);
  void ManageItem();
  CmString GetValue();
};
  

/***************************  Dialog Class **********************/
  
class CmDialog {
 private: 
  Widget parent, shell, helpshell;
  Widget base_form, work_area, button_area;
  Widget ok_pbutton, cancel_pbutton, help_pbutton;
  ReceiverPtr receiver;
  int helpdisplayed;
  char dialog_state;
  CmList pane_list;
  CmDialogPane* pane;
  CmList item_list;
  CmDialogItem* item;
  Boolean display_pane;
  Widget xm_dialog;
  char xm_dialog_type;

  Arg arglist[MAXARGS];
  int count;
  CmString widgetname;
  CmString initval;
  CmString help;

 public:
  CmDialog(Widget, const CmString&, char);      // constructor
  ~CmDialog();                  // destructor

  void PopupDialog(void);   // put the dialog box on the screen
  void PopdownDialog(void); // take the dialog box off the screen
  void DisplayPane(Boolean); // sets display of pane names

  // Item manipulation
  CmDialogItem *
    AddItem(const CmDialogItemType, const CmString&,const CmString&);
  void AddPane(const CmString&,const CmString&, CmDialogAttachMethod);
  void AddOption(const CmString&,const CmString&,char,XtArgVal);
  void ManageItems();
  CmString GetValue(const CmString&,const CmString&);
  void SetValue(const CmString&, const CmString&,const CmString&);
  int GetInteger(const CmString&,const CmString&);
  float GetFloat(const CmString&,const CmString&);
  double GetDouble(const CmString&,const CmString&);
  CmString GetString(const CmString&,const CmString&);
  void RemoveItem(const CmString&,const CmString&);
  void GreyItem(const CmString&,const CmString&);
  void UnGreyItem(const CmString&,const CmString&);
  void SetCallbacks(XtCallbackProc, XtPointer, XtCallbackProc, XtPointer);
  void SetHelp( const CmString& );
  Widget GetWidget( const CmString&, const CmString& );

  CmDialogItem* GetItem(const CmString&, const CmString&);
  CmDialogPane* GetPane(const CmString&);

  // dialog convienience routines
  void XmDialogCreate(CmDialogXmDialogType, const CmString&);
  void XmDialogRemoveButton(char);
  Widget XmDialogGetWidget();
  void XmDialogManage();

/* methods that should be private but can't */
  void ValueChanged( const CmString& );
  void DisplayHelp();
  void UnDisplayHelp();
  Widget AddItemBase(CmDialogPane*,CmString,WidgetClass,ArgList,int);
};





