/* $Date: 91/12/11 17:42:12 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/****************************************************************************
 CmFigureClass.h - Figure Class (under CmFigureRegistrar)
 Contact: sniyogi, maschaub
 ****************************************************************************/

#ifndef _CMFigureCLASS
#define _CMFigureCLASS
#include <CDS.h>

class CmFigure;

struct CmResource {
    CmString ResourceString;        // List of editable keywords
    CmString DialogText;   // prompt in dialog box
    CmString DefaultValue; // default value
    int EditMode;         // and the manner they are to be edited via CmDialog
    Boolean IsCommon;
    
    CmList OptionList;
    CmString* Option;
};

  
struct CmCallback {
    CmString CallbackName;
    CmString Callback;
};

class CmFigureClass {
 private:
  CmString class_name;
  WidgetClass widget_class;            // Class type: XmLabel, XmText, etc.  
  CmFigureClass *super_cm_class;
  CmList resource_list;  // list of resources
  CmList callback_list; // list of possible callbacks
 public:
  CmFigureClass(CmFigureClass *, WidgetClass);
                                        // Constructor
  ~CmFigureClass();                     // Destructor

  // Adding keyword, dialog text, and method of editing
  void AddResource(const CmString &, const CmString &, 
		   const CmString &, const int, const Boolean);   
  void AddOptionToResource(const CmString &, const CmString &);
  void AddCallback(const CmString &, const CmString &);
  WidgetClass GetWidgetClass() const {return (widget_class);}
  int NumberOfResources();
  CmString ClassName() const {return (class_name);}
  CmString Resource(const int);
  CmString DialogText(const int);
  CmString Default(const int );  
  CmString Default( const CmString &);
  int EditMode(const int);
  Boolean IsCommon(const int);
  int NumOptions(const int );
  CmString Option(const int, const int );
  CmString CallbackName( const int );
  const char *Callback( const int );
  int NumCallbacks();
  CmFigureClass *SuperCmClass() {return super_cm_class; };
  void (* UpdateCallbackProc)(CmFigure *, CmString, XtPointer);
};
#endif


