/* $Date: 91/12/13 10:01:02 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*******************************************************************************
 CmFigureHandler.h - Figure Handler (under CmFigureEditor)
 Contact: sniyogi

  CmFigureHandler: The editing (double click, drag, etc.) of a figure is done 
    by adding an XtAddEventHandler to each editable figure on the display.
    If activated, CmFigureActivated is called, and all resizing, 
    moving, and editing options is done by a CmFigureHandler, which
    goes ahead and asks CmFigureParser to change the parameter as necessary.
 *******************************************************************************/
#ifndef _CMFIGUREHANDLER
#define _CMFIGUREHANDLER
#include <CDS.h>

class CmDialog;
class CmFigure;
class CmFigureClass;
class CmFigureEditor;
class CmFigureHandler;

void CmFigureActivated(Widget, CmFigureHandler*, XEvent*);

class CmHandlerWad {
 public:
  CmFigureHandler* handler;





  CmDialog* dialog;
  CmHandlerWad();
  ~CmHandlerWad();
};

class CmFigureHandler {
 private:
  CmFigure* highlighted;
  CmFigure* old_highlighted;
  Time timePrevPress;

  Display *display;
  GC workarea_gc;
  Cursor Move, Norm;
  Cursor top_left_corner, top_side, top_right_corner;
  Cursor left_side, right_side;
  Cursor bottom_left_corner, bottom_side, bottom_right_corner;

  Boolean left, right, top, bottom;
  Boolean dragging, resizing;
  Boolean button_pressed;
  
  // Dragging/resizing
  Dimension parent_width, parent_height; // parent dimensions
  float abs_to_xposition, xposition_to_abs,abs_to_yposition, yposition_to_abs;
  Position abs_x, abs_y; // absolute coordinates of the figure in parent (pixels)
  Dimension abs_width, abs_height, border_width;
  Position mouse_x, mouse_y;  // pixel coordinate relative to clicked figure
  Position drag_x, drag_y; /// pixel coordinates for dragging
  // Figure Handling routines
  void setup(const Widget);
  void get_absolute_geometry(const Widget);
  void set_position_geometry(const Widget);
  Boolean should_we_resize(const Widget w, XEvent *e);

  void handle_drag(const Widget, XEvent*);
  void finish_drag(const Widget, XEvent*);

  void handle_resize(const Widget, XEvent*);
  void finish_resize(const Widget, XEvent*);

  int round_to_nearest(int, int);
public:
  CmFigureEditor* editor;
  int Xscale, Yscale;

  CmFigureHandler(CmFigureEditor*);
  ~CmFigureHandler();
  void FigureActivated(Widget w, XEvent *event);
  CmFigure* GetHighlightedCmFigure();
  void SetHighlightedCmFigure(CmFigure*);
  CmFigure* GetOldHighlightedCmFigure();
  Boolean Snap;
 };
#endif

