/* $Date: 91/12/13 13:35:06 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*************************************************************************
 CmFigureRegistrar.cc - Figure Registrar Definition (under CmFigureEditor)
 Contact: sniyogi, maschaub

 CmFigureRegistrar: 

 *************************************************************************/

#include <CDS.h>
#include <CmCDS.h>
#include <CmFigureClass.h>
#include <CmFigureEditor.h>
#include <CmFigureRegistrar.h>
#include <CmDialog.h> 
#include <CmModel.h>
#include <CmMenu.h>
#include <CmFigure.h>
#include <CmPage.h>
#include <X11/Shell.h>
#include <Xm/PushBG.h> 
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>

extern "C" {
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
}

#define REG_CODE_COLUMNS 80
#define REG_CODE_ROWS 24

static CmFigureClass *figure_class;

struct CmRegWad {
  CmFigureRegistrar* wr;
  CmDialog* dialog;
  CmFigure* cmfigure; 
  CmString tmp_string;
  CmString tmp_string2;

  CmRegWad(CmFigureRegistrar* widreg, CmDialog* d, CmFigure* cw) {
    wr = widreg; dialog = d; cmfigure = cw; 
  }
  ~CmRegWad() {
    delete dialog;
  }
};

static void CmPopdownDialog(Widget, CmRegWad* regwad, XtPointer) {
  delete regwad;
}

void CmFigureRegistrar::ShowPalette() {
  XtPopup(palette_shell, XtGrabNone);
  XRaiseWindow(XtDisplay(palette_shell), XtWindow(palette_shell));
}

void CmFigureRegistrar::HidePalette() {
  XtPopdown(palette_shell); 
}

void CmPopdownPalette(Widget, CmFigureRegistrar *wr, XtPointer) {
  wr->HidePalette();  
}

// palette callbacks
void CmPopupPalette(Widget, CmFigureRegistrar* wr, XtPointer) {
  wr->ShowPalette();
}

/*******************************
 CmFigureRegistrar Constructor
  copies the editor into a local variable and modifies the menu
 *******************************/
CmFigureRegistrar::CmFigureRegistrar(CmFigureEditor *e) {
  figure_editor = e;
  toplevel = e->CDSPtr()->TopLevel();

  figure_editor->CDSPtr()->Menu()->AddItem("Edit","figure_edit",
					   (XtCallbackProc)CmEditCodeBox,
					   (XtPointer)this);
  palette_shell = 
    XtVaCreatePopupShell("palette_shell",topLevelShellWidgetClass, toplevel,
			 XmNallowShellResize, True, NULL);

  // Create Pane
  Widget palette_form = 
    XtVaCreateManagedWidget("palette_form", xmPanedWindowWidgetClass, 
			    palette_shell, NULL);

  // Create close button
  Widget palette_close = 
    XtVaCreateManagedWidget("palette_close", xmPushButtonGadgetClass,
			    palette_form, NULL);

  XtAddCallback(palette_close, XmNactivateCallback, 
		(XtCallbackProc) CmPopdownPalette, (XtPointer) this);

  // create row column that is the palette

  widget_palette = 
    XtVaCreateManagedWidget("widget_palette", xmRowColumnWidgetClass,
			    palette_form, NULL);

  cmdebug << "   Figure Palette created.\n";
}
     
/*******************************
 CmFigureRegistrar Destructor
  Effects:
 *******************************/
CmFigureRegistrar::~CmFigureRegistrar(){
  XtDestroyWidget(palette_shell);
}

/*******************************
 CmFigureRegistrar AddFigureClass
   Adds a new figure class to the array of CmFigureClasses
 *******************************/

CmFigureClass *CmFigureRegistrar::RegisterWidgetClass(const WidgetClass wc) {
  WidgetClass super_class = wc;
  CmFigureClass *cm_super_class = NULL;
  super_class = super_class->core_class.superclass;
  if (super_class && !(cm_super_class = GetCmFigureClass(super_class)))
    cm_super_class = RegisterWidgetClass(super_class);

  return((CmFigureClass *) figure_class_list.Append(new CmFigureClass(cm_super_class, wc)));
}

void CmFigureRegistrar::AddToPalette(CmFigureClass *cwc) {
  CmString class_name = cwc->GetWidgetClass()->core_class.class_name;
  CmString palette_button_name = class_name + "Icon";
  Widget icon = XmCreatePushButtonGadget(widget_palette, 
				   (char *) palette_button_name.Chars(), 
				   NULL, 0);
  XtManageChild(icon);
  
  CmEditorCmFigureClassWad *figure_class_wad = new CmEditorCmFigureClassWad;
  figure_class_wad->Editor = figure_editor;
  figure_class_wad->CmClass = cwc;
  
  XtAddCallback(icon, XmNactivateCallback, 
		(XtCallbackProc)CmCreateFigure, (XtPointer) figure_class_wad);
}

/*********************************************
 CmFigureRegistrar GetCmFigureClass
  Selector for the CmFigureClass of a figure
 *********************************************/
CmFigureClass* CmFigureRegistrar::GetCmFigureClass(const WidgetClass wc) { 
  for (int i=0; i < figure_class_list.ListSize(); i++) {
    figure_class = (CmFigureClass *) figure_class_list[i];
    if (figure_class->GetWidgetClass() == wc) 
      return(figure_class);
  }
  return(NULL);
}

/*********************************************
 CmFigureRegistrar GetCmFigureClass
  Called by CmFigureParser
  Converts a string resource to CmFigureClass
 *********************************************/
CmFigureClass* CmFigureRegistrar::GetCmFigureClass(const CmString &
						   string_token) { 
  for (int i=0; i < figure_class_list.ListSize(); i++) {
    figure_class = (CmFigureClass *) figure_class_list[i];
    if (figure_class->ClassName() == string_token)
      return(figure_class);
  }
  cerr << "GetCmFigureClass didn't find the class " << string_token
    << "\n";
  return(NULL);
}

/************** general routines for resources ****************************/

/*********************************************
 CmFigureRegistrar add_keywords_to_dialog
  Adds the keywords to the dialog box
 *********************************************/
void CmFigureRegistrar::add_keywords_to_dialog(CmFigure *editing_cw,
					       CmFigureClass *fc,
					       CmDialog *d,
					       CmString panename) {
  if (fc->SuperCmClass())
    add_keywords_to_dialog(editing_cw, fc->SuperCmClass(), d, panename);
  
  // add common resources
  for (int i=0; i < fc->NumberOfResources(); i++)
    if (fc->IsCommon(i)) {
      CmString rvalue = editing_cw->GetResource(fc->Resource(i));
      add_keyword_to_dialog(d, panename, rvalue, fc, i );    
    }
}


/*********************************************
CmFigureRegistrar add_keyword_to_dialog
called by add_keywords_to_dialog and create_uncommon_dialog
*********************************************/
void CmFigureRegistrar::add_keyword_to_dialog(CmDialog* const d,
					      const CmString & pane_name, 
					      const CmString & rvalue, 
					      CmFigureClass* const wc, 
					      const int i) {
  const CmString label_const = "Label:";
  const CmString text_const = "Text:";
  CmString dialog_text;
  CmDialogItem *item;

  switch ( wc->EditMode(i) ) {
  case CMDIALOG_LIST:
    item = d->AddItem(CMDIALOG_LIST,pane_name, wc->DialogText(i));
    item->AddOption(CMDIALOG_NUMVISIBLE, (XtArgVal)5 );
    item->AddOption(CMDIALOG_VALUE, (XtArgVal)rvalue.Chars() );
    for (int j = 0; j < wc->NumOptions(i); j++) {
      const CmString opt = wc->Option(i,j);
      item->AddOption(CMDIALOG_OPTION, (XtArgVal)opt.Chars() );}
    break;
  case CMDIALOG_RADIOBOX:
    item = d->AddItem(CMDIALOG_RADIOBOX,pane_name,wc->DialogText(i));
    for ( j = 0; j < wc->NumOptions(i); j++) {
      const CmString opt = wc->Option(i,j);
      item->AddOption(CMDIALOG_RADIOBUTTON, (XtArgVal)opt.Chars() );
    }
    item->AddOption(CMDIALOG_SELECTED, (XtArgVal)rvalue.Chars() );
    break;
  case CMDIALOG_TEXTSTRING:
    item = d->AddItem(CMDIALOG_TEXTSTRING,pane_name, wc->DialogText(i));
    item->AddOption(CMDIALOG_VALUE, (XtArgVal)( rvalue.Chars() ));
    dialog_text = wc->DialogText(i);
    if ( (dialog_text == label_const) || (dialog_text == text_const) ) {
      item->AddOption(CMDIALOG_EDITMODE, (XtArgVal) CMDIALOG_MULTI_LINE);
      item->AddOption(CMDIALOG_ROWS, (XtArgVal) 5);
      item->AddOption(CMDIALOG_COLUMNS, (XtArgVal) 30);
    }
    break;
  case CMDIALOG_TOGGLEBUTTON:
    CmDialogItem *item =
      d->AddItem(CMDIALOG_TOGGLEBUTTON,pane_name, wc->DialogText(i));
    if ( rvalue == "True" )
      item->AddOption(CMDIALOG_VALUE, (XtArgVal)CMDIALOG_TRUE);
    break;
  }
}

/*********************** uncommon dialog rountines ***************************/

/*********************************************
 CmFigureRegistrar update_figure
  Copies the modified values from the dialog box to the CmFigure
 *********************************************/
void CmFigureRegistrar::update_figure(CmRegWad* regwad) {
  CmFigureClass* wc = regwad->cmfigure->GetCmFigureClass();
  const CmString pane_name = wc->ClassName();
  // update resources
  
  while (wc) {
    for (int i=0; i < wc->NumberOfResources(); i++) 
      if ( wc->IsCommon(i) ) {
	regwad->dialog->GetString(pane_name,wc->DialogText(i));
	regwad->cmfigure->ChangeResource(wc->Resource(i), 
					 regwad->dialog->GetString(pane_name,wc->DialogText(i)));
      }
    wc = wc->SuperCmClass();
  }
  // update name
  regwad->cmfigure->Name = regwad->dialog->GetString(pane_name,"Figure Name");
  cmdebug << "changed figure name to " << regwad->dialog->GetString(pane_name, "Figure Name") << "\n";
}

/**************************************************************
 CmFigureRegistrar add_uncommons_to_list
 called by edit figure to add the uncommon resources to the list box
****************************************************************/
void CmFigureRegistrar::add_uncommons_to_list(CmFigureClass* const wc,
					      CmDialogItem* const item) {
  if (wc->SuperCmClass())
    add_uncommons_to_list(wc->SuperCmClass(), item);
  for ( int i=0; i < wc->NumberOfResources(); i++) 
    if ( !(wc->IsCommon(i)) ) { 
      const CmString text = wc->DialogText(i);
      item->AddOption(CMDIALOG_OPTION,(XtArgVal)( text.Chars() ));
    }
}

void CmUpdateUncommon(Widget, CmRegWad* regwad, XtPointer) {
  regwad->wr->update_uncommon_resource(regwad); 
}

/**************************************************************
 CmFigureRegistrar create_uncommon_dialog
 called by EditUncommonResources to create the uncommon dialog box
 and add the callbacks to it.
 **************************************************************/
void CmFigureRegistrar::create_uncommon_dialog(CmRegWad* regwad,
					 const CmString & selected_resource) {
 CmFigureClass* wc = regwad->cmfigure->GetCmFigureClass();
 while (wc) {
   for ( int i=0; i < wc->NumberOfResources(); i++) 
     if ( wc->DialogText(i) == selected_resource ) {
       CmDialog* uncommon_dialog = 
	 new CmDialog(toplevel, "Uncommon Resource", CMDIALOG_MODELESS);
       uncommon_dialog->SetHelp("Edit the resources \n and click ok or cancel when finished");
       uncommon_dialog->DisplayPane(False);
       uncommon_dialog->AddPane("uncommon_resource","", CMDIALOG_ATTACH_NONE);
       CmString rvalue = regwad->cmfigure->GetResource(wc->Resource(i));
       add_keyword_to_dialog(uncommon_dialog, 
			     "uncommon_resource", rvalue, wc, i );
       uncommon_dialog->ManageItems();
       uncommon_dialog->PopupDialog();
       CmRegWad* rwad = new CmRegWad(regwad->wr, 
				     uncommon_dialog, regwad->cmfigure);
       rwad->tmp_string = wc->Resource(i);
       rwad->tmp_string2 = wc->DialogText(i);
       uncommon_dialog->SetCallbacks((XtCallbackProc) CmUpdateUncommon, 
				     (XtPointer)rwad,
				     (XtCallbackProc) CmPopdownDialog,
				     (XtPointer)rwad);
       return;
     }
   wc = wc->SuperCmClass();
 }
}

/**************************************************************
 CmFigureRegistrar update_uncommon
   called when the user selects the ok button on the uncommon dialog box
**************************************************************/
void CmFigureRegistrar::update_uncommon_resource(CmRegWad* regwad) {
  regwad->cmfigure->ChangeResource(regwad->tmp_string, 
				   regwad->dialog->
				   GetString("uncommon_resource",
					     regwad->tmp_string2));
  CmPopdownDialog(NULL, regwad, NULL);
}

void CmEditUncommon(Widget, CmRegWad* regwad, XtPointer) {
  regwad->wr->edit_uncommon_resource(regwad); 
}

/**************************************************************
 CmFigureRegistrar EditUncommonResource
  called when user clicks in uncommon list of resources
 **************************************************************/
void CmFigureRegistrar::edit_uncommon_resource(CmRegWad* regwad) 
{
  CmString uncommon_resource = 
    regwad->dialog->GetString("Uncommon Resources","uncommon");
  regwad->tmp_string = uncommon_resource;
  create_uncommon_dialog(regwad, uncommon_resource);
}



/*************************** Activator dialog boxes ************************/

void CmUpdateActivator(Widget, CmRegWad* regwad, XtPointer) {
  regwad->wr->update_activator(regwad); 
}

/**************************************************************
 CmFigureRegistrar EditActivator
  called when user clicks an activator
 **************************************************************/
void CmEditActivator(Widget, CmRegWad* regwag, XtPointer) {
  regwag->wr->edit_activator(regwag); 
}

void CmFigureRegistrar::edit_activator(CmRegWad *regwad) {
  CmString activator = regwad->dialog->GetString("Callbacks","callback");
  regwad->dialog->PopdownDialog();  // close the editing window

  CmDialog* connect_dialog = new CmDialog(toplevel, 
					  figure_editor->Page->Title, 
					  CMDIALOG_MODELESS);
  connect_dialog->SetHelp("Activator help\n\n");
  connect_dialog->AddPane("Action Code","",CMDIALOG_ATTACH_NONE);
  CmDialogItem *item =
    connect_dialog->AddItem(CMDIALOG_TEXTSTRING,"Action Code","Code");
  item->AddOption(CMDIALOG_EDITMODE, (XtArgVal) CMDIALOG_MULTI_LINE);
  item->AddOption(CMDIALOG_ROWS, (XtArgVal)REG_CODE_ROWS);
  item->AddOption(CMDIALOG_COLUMNS, (XtArgVal)REG_CODE_COLUMNS);
  item->AddOption(CMDIALOG_SCROLLED_TEXT, (XtArgVal)0);
  
  cmdebug << "callback is " << activator << "\n";
  cmdebug << "Editing callback string " << regwad->cmfigure->GetCallbackString(activator) << "\n";
  const CmString callback_string =  regwad->cmfigure->GetCallbackString(activator);
  connect_dialog->AddOption("Action Code","Code",
		   CMDIALOG_VALUE, 
		   (XtArgVal)( callback_string.Chars() ));

  connect_dialog->ManageItems();
  connect_dialog->PopupDialog();

  // add callbacks
  CmRegWad* registwad = new CmRegWad(regwad->wr, connect_dialog, 
					   regwad->cmfigure);
  registwad->tmp_string = regwad->dialog->GetString("Callbacks","callback");
  connect_dialog->SetCallbacks((XtCallbackProc) CmUpdateActivator, 
			       (XtPointer)registwad,
			       (XtCallbackProc) CmPopdownDialog,
			       (XtPointer)registwad);

  finish_edit_figure(regwad);  // update resources and delete regwad
}
  
/**************************************************************
 CmFigureRegistrar update_activator
**************************************************************/
void CmFigureRegistrar::update_activator(CmRegWad* regwad) { 
  cmdebug << "Changing " << regwad->tmp_string << " to " << regwad->dialog->GetString("Action Code","Code") << "\n";
  regwad->cmfigure->ChangeCallback(regwad->tmp_string, 
			       regwad->dialog->GetString("Action Code",
							 "Code"));
  regwad->dialog->PopdownDialog();
  delete regwad;
}



/*************************** Main Editing dialog box *************************/

void  CmFinishEdit(Widget, CmRegWad* regwad, XtPointer) {
  regwad->wr->finish_edit_figure(regwad); 
}

/**************************************************************
  CmFigureRegistrar EditFigure
  Called by the figure handler when the figure is double clicked
  Creates the dialog box, adds keywords to it and brings it up
 **************************************************************/
void CmFigureRegistrar::EditFigure(const Widget w) {   
  CmFigure* editing_cw = figure_editor->Page->PageCmFigure->WidgetToCmFigure(w);
  CmFigureClass* editing_wc = editing_cw->GetCmFigureClass();
  CmDialogItem *callback_item;

  if ( !editing_cw ) cerr << "EditFigure had trouble creating dialog box\n";
  
  // change cursor to wait symbol
  figure_editor->CDSPtr()->ShowWaitCursor();
  
  CmString title = figure_editor->Page->Title;
  title += ":  "; title += editing_cw->Name;
  CmDialog* common_dialog = new CmDialog(toplevel, title, CMDIALOG_MODELESS);
  
  const CmString pane_name = editing_wc->ClassName();
  
  common_dialog->AddPane(pane_name,"",CMDIALOG_ATTACH_NONE);
  common_dialog->DisplayPane(True);
  
  // add figure name
  CmDialogItem *figure_name_item = 
    common_dialog->AddItem(CMDIALOG_TEXTSTRING, pane_name, "Figure Name");
  const CmString figure_name =  editing_cw->Name;
  figure_name_item->AddOption(CMDIALOG_VALUE, (XtArgVal) figure_name.Chars());
  cmdebug << editing_cw->Name << " is the old figure name\n";

  common_dialog->SetHelp("Edit the resources \n and click ok or cancel when finished\n\nDouble click on choice in the list of uncommon resources to edit them");
  // add push buttons to connect the two dialogs
  add_keywords_to_dialog(editing_cw, editing_wc, common_dialog, pane_name);
    
  // list of uncommon resources
  common_dialog->AddPane("Uncommon Resources", pane_name, 
			 CMDIALOG_ATTACH_LEFT);
  CmDialogItem *uncommon_item = 
    common_dialog->AddItem(CMDIALOG_LIST, "Uncommon Resources", "uncommon");
  uncommon_item->AddOption(CMDIALOG_NUMVISIBLE,(XtArgVal)10);
  add_uncommons_to_list(editing_wc, uncommon_item);

  // list of callbacks
  if ( editing_wc->NumCallbacks() !=0 ) {
    common_dialog->AddPane("Callbacks", "Uncommon Resources", 
			   CMDIALOG_ATTACH_TOP); 
    callback_item = 
      common_dialog->AddItem(CMDIALOG_LIST, "Callbacks", "callback");
    callback_item->AddOption(CMDIALOG_NUMVISIBLE,(XtArgVal)3);
    for (int i = 0; i < editing_wc->NumCallbacks(); i++) {
      const CmString callbacktext = editing_wc->CallbackName(i);
      callback_item->AddOption(CMDIALOG_OPTION,(XtArgVal)callbacktext.Chars());
    }
  }

  common_dialog->ManageItems();
  common_dialog->PopupDialog();

 // add callback for list of uncommon resources
  CmRegWad* regwad = new CmRegWad(this, common_dialog, editing_cw);
  XtAddCallback(uncommon_item->GetWidget(), XmNsingleSelectionCallback, 
		(XtCallbackProc) CmEditUncommon, (XtPointer)regwad );

  if (editing_wc->NumCallbacks() != 0)
    XtAddCallback(callback_item->GetWidget(), XmNsingleSelectionCallback, 
		  (XtCallbackProc) CmEditActivator, (XtPointer)regwad);

  common_dialog->SetCallbacks((XtCallbackProc) CmFinishEdit, 
			      (XtPointer)regwad,
			      NULL, NULL);

  // return cursor to orginal shape
  figure_editor->CDSPtr()->ShowNormCursor();
}

/**************************************************************
 CmFigureRegistrar FinishEditFigure
  Called when the ok button in the dialog box is activated
  Copies the modified keywords to the CmFigure through update_figure
  Redraws the figure
  Adds event handler to the new figure
 **************************************************************/
void CmFigureRegistrar::finish_edit_figure(CmRegWad* regwad) {  
  update_figure(regwad);
  cmdebug << "Figureizing\n";
  regwad->cmfigure->Widgetize();
  regwad->cmfigure->Map();
  delete regwad;
}

/*************************** Main Editing dialog box *************************/

// This mark is put next to actions with text inside 
#define CONTAINS_TEXT_MARK "*"

void  CmEditCodeBox(Widget w, CmFigureRegistrar* reg,  XtPointer) {
  reg->EditCode(w);
}

void  CmFigureSelected(Widget w, CmRegWad* regwad, XtPointer) {
  // save old action code if selected
  CmUpdateCodeBox(w,regwad, (XtPointer) NULL);

  regwad->dialog->SetValue("Code","Code Text","" );
  regwad->dialog->SetValue("Figures","Activator List","");
  // regwad->dialog->SetValue("Code","Figure:Action","");

  // get the cmfigure
  CmString figure_name = regwad->dialog->GetString("Figures","Figure List");
  if (figure_name.Empty())
    return;
  regwad->cmfigure = regwad->wr->figure_editor->
    Page->PageCmFigure->
      NameToCmFigure(figure_name.Chars());
  if (regwad->cmfigure == NULL)
    return;

  // reset activator list
  CmFigureClass* editing_wc = regwad->cmfigure->GetCmFigureClass();
  if ( editing_wc->NumCallbacks() !=0 ) 
    for (int i = 0; i < editing_wc->NumCallbacks(); i++) {
      CmString actiontext = editing_wc->CallbackName(i);
  // The next section checks if the figure has a callback for this string
      if (!regwad->cmfigure->GetCallbackString(actiontext).Empty())
	actiontext += CONTAINS_TEXT_MARK;
      regwad->dialog->SetValue("Figures","Activator List",
			       actiontext.Chars());
    } else
      regwad->dialog->SetValue("Figures", "Activator List", "<No Callbacks>");
}

void  CmExecuteCode(Widget, CmRegWad* regwad, XtPointer) {
  regwad->wr->figure_editor->CDSPtr()->Model()->
    Evaluate(regwad->dialog->GetString("Code","Code Text"));
}

void  CmCallEditFigure(Widget, CmRegWad* regwad, XtPointer) {
  CmString figure_name = regwad->dialog->GetString("Figures","Figure List");
 
  regwad->cmfigure = regwad->wr->figure_editor->
    Page->PageCmFigure->NameToCmFigure(figure_name.Chars());
  // check to see if the figure still exists
  if (regwad->cmfigure == NULL)
    return;
  regwad->cmfigure = regwad->wr->figure_editor->
    Page->PageCmFigure->
      NameToCmFigure(regwad->cmfigure->Name.Chars());
  if (regwad->cmfigure == NULL)
    return;
 
  regwad->wr->EditFigure(regwad->cmfigure->GetWidget());
}

void  CmActionSelected(Widget w, CmRegWad* regwad, XtPointer) {
  // update code box if a action has been selected
  CmUpdateCodeBox(w,regwad, NULL);

  // check to see if the figure still exists
  if (regwad->cmfigure == NULL)
    return;
  regwad->cmfigure = regwad->wr->figure_editor->
    Page->PageCmFigure->
      NameToCmFigure(regwad->cmfigure->Name.Chars());
  if (regwad->cmfigure == NULL)
    return;
 
  // set the text box to the code value
  CmString action = regwad->dialog->GetString("Figures","Activator List");
  action.Del(CONTAINS_TEXT_MARK);
  CmString action_code = regwad->cmfigure->GetCallbackString(action);
  regwad->dialog->SetValue("Code","Code Text",action_code );

  /* taken out because it causes seg faults, reason: unknown
  CmString code_title = regwad->dialog->GetString("Figures","Figure List");
  code_title += ":";
  code_title += action; 
  regwad->dialog->SetValue("Code","Figure:Action",code_title.Chars());
  */

  regwad->tmp_string = action;
}

void  CmOkCodeBox(Widget, CmRegWad* regwad, XtPointer) {
  CmUpdateCodeBox(NULL,regwad, NULL);
  delete regwad;
}

void  CmUpdateFigureList(Widget, CmRegWad* regwad, XtPointer) {
  CmUpdateCodeBox(NULL, regwad, NULL);
  regwad->dialog->SetValue("Code","Code Text","" );
  regwad->dialog->SetValue("Figures","Activator List","");
  //  regwad->dialog->SetValue("Code","Figure:Action","");

  regwad->dialog->SetValue("Figures","Figure List","");
  int num_cmfigures = regwad->wr->figure_editor->Page->PageCmFigure->
    NumCmFigures();
  for (int i=0; i < num_cmfigures ; i++) 
    regwad->dialog->SetValue("Figures","Figure List",
			     regwad->wr->figure_editor->Page->PageCmFigure->
			     GetCmFigure(i)->Name.Chars());
  
}

void  CmUpdateCodeBox(Widget, CmRegWad* regwad, XtPointer) {
  // check to see if the figure still exists
  if (regwad->cmfigure == NULL)
    return;
  regwad->cmfigure = regwad->wr->figure_editor->
    Page->PageCmFigure->
      NameToCmFigure(regwad->cmfigure->Name);
  if (regwad->cmfigure == NULL)
    return;
 
  if (regwad->tmp_string != "") {
    CmString newcode = regwad->dialog->GetString("Code","Code Text");
    regwad->cmfigure->ChangeCallback(regwad->tmp_string,newcode);
    regwad->tmp_string = "";
  }
}

/**************************************************************
  CmFigureRegistrar EditCode
 **************************************************************/
void CmFigureRegistrar::EditCode(const Widget w) {   
  CmDialog* code_dialog = new CmDialog(toplevel, 
				       figure_editor->Page->Title, 
				       CMDIALOG_MODELESS);
  CmDialogItem *item;
  code_dialog->SetHelp("Click on a figure name and then an action\nto see the code associated with that action\n");
  // figures pane
  code_dialog->AddPane("Figures","",CMDIALOG_ATTACH_NONE);
  item = code_dialog->AddItem(CMDIALOG_LIST,"Figures","Figure List");
  item->AddOption(CMDIALOG_NUMVISIBLE,(XtArgVal)10);

  code_dialog->AddItem(CMDIALOG_PUSHBUTTON,"Figures","Edit Figure");
  code_dialog->AddItem(CMDIALOG_PUSHBUTTON,"Figures","Reread Figures");

  item = code_dialog->AddItem(CMDIALOG_LIST,"Figures","Activator List");
  item->AddOption(CMDIALOG_NUMVISIBLE,(XtArgVal)3);
  
  // code pane
  
  code_dialog->DisplayPane(False);
  code_dialog->AddPane("Code", "Figures", CMDIALOG_ATTACH_LEFT);
  code_dialog->DisplayPane(True);

  item = code_dialog->AddItem(CMDIALOG_TEXTSTRING,"Code","Code Text");
  item->AddOption(CMDIALOG_EDITMODE, (XtArgVal) CMDIALOG_MULTI_LINE);
  item->AddOption(CMDIALOG_ROWS, (XtArgVal)REG_CODE_ROWS);
  item->AddOption(CMDIALOG_COLUMNS, (XtArgVal)REG_CODE_COLUMNS);
  item->AddOption(CMDIALOG_SCROLLED_TEXT, (XtArgVal)0);

  item = code_dialog->AddItem(CMDIALOG_PUSHBUTTON,"Code","Execute");
  item->AddOption(CMDIALOG_ALIGNMENT,(XtArgVal)CMDIALOG_CENTER);
  
  code_dialog->ManageItems();
  code_dialog->PopupDialog();

  // add callbacks
  CmRegWad* registwad = new CmRegWad(this, code_dialog, NULL);
  registwad->tmp_string = "";

  XtAddCallback(code_dialog->GetWidget("Figures","Figure List"), 
		XmNsingleSelectionCallback, 
		(XtCallbackProc) CmFigureSelected, 
		(XtPointer)registwad);
  XtAddCallback(code_dialog->GetWidget("Code","Execute"), 
		XmNactivateCallback, 
		(XtCallbackProc) CmExecuteCode,
		(XtPointer)registwad);
  XtAddCallback(code_dialog->GetWidget("Figures","Edit Figure"), 
		XmNactivateCallback, 
		(XtCallbackProc) CmCallEditFigure,
		(XtPointer)registwad);
  XtAddCallback(code_dialog->GetWidget("Figures","Reread Figures"), 
		XmNactivateCallback, 
		(XtCallbackProc) CmUpdateFigureList,
		(XtPointer)registwad);
  XtAddCallback(code_dialog->GetWidget("Figures","Activator List"), 
		XmNsingleSelectionCallback, 
		(XtCallbackProc) CmActionSelected,
		(XtPointer)registwad);
  code_dialog->SetCallbacks((XtCallbackProc) CmOkCodeBox, 
			    (XtPointer)registwad,
			    (XtCallbackProc) CmPopdownDialog,
			    (XtPointer)registwad);
  CmUpdateFigureList(w,registwad,NULL);
}




