/* $Date: 91/12/13 13:45:40 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/****************************************************************************
 CmFigureRegistrar.h - Figure Class Registrar (under CmFigureEditor)
 Contact: sniyogi,maschaub
 ****************************************************************************/

#ifndef _CMFIGUREREGISTRAR
#define _CMFIGUREREGISTRAR
#include <CDS.h>

/* regwad is a general group of pointers that stays in the callbacks */

class CmDialog;
class CmDialogItem;
class CmFigure;
class CmFigureClass;
class CmRegWad;

class CmFigureRegistrar {
 private:
  CmFigureEditor* figure_editor;
  Widget toplevel, palette_shell, widget_palette;
  CmList figure_class_list;

  // Editing widget process
  CmString last_pane_name;

  void add_keywords_to_dialog(CmFigure *,CmFigureClass*, CmDialog*, CmString);
  void add_uncommons_to_list(CmFigureClass * const, CmDialogItem * const);
  void create_uncommon_dialog(CmRegWad*, const CmString &);
  void add_keyword_to_dialog(CmDialog * const, const CmString &,
			     const CmString &, CmFigureClass * const,const int);
  void update_figure(CmRegWad*);

  void edit_uncommon_resource(CmRegWad*);
  void update_uncommon_resource(CmRegWad*);
  void edit_activator(CmRegWad*);
  void update_activator(CmRegWad*);
  void edit_constructor_text(CmRegWad*);
  void update_constructor_text(CmRegWad*);
  void finish_edit_figure(CmRegWad*);

public:
  CmFigureRegistrar(CmFigureEditor*);   // Constructor
  ~CmFigureRegistrar();                  // Destructor

  CmFigureClass* RegisterWidgetClass(const WidgetClass);
  CmFigureClass* GetCmFigureClass(const WidgetClass);
  CmFigureClass* GetCmFigureClass(const CmString &);

  void EditFigure(const Widget);
  void EditCode(const Widget);

  void AddToPalette(CmFigureClass *);
  void ShowPalette();
  void HidePalette();
  friend void CmUpdateUncommon(Widget, CmRegWad*, XtPointer);
  friend void CmEditUncommon(Widget, CmRegWad*, XtPointer);
  friend void CmEditConstructorText(Widget, CmRegWad*, XtPointer);
  friend void CmUpdateConstructorText(Widget, CmRegWad*, XtPointer);
  friend void CmUpdateActivator(Widget, CmRegWad*, XtPointer);
  friend void CmEditActivator(Widget, CmRegWad*, XtPointer);
  friend void CmFinishEdit(Widget, CmRegWad*, XtPointer);
  friend void CmFigureSelected(Widget, CmRegWad*, XtPointer);
  friend void CmActionSelected(Widget, CmRegWad*, XtPointer);
  friend void CmCallEditFigure(Widget, CmRegWad*, XtPointer);
  friend void CmUpdateFigureList(Widget, CmRegWad*, XtPointer);
  friend void CmExecuteCode(Widget, CmRegWad*, XtPointer);
  friend void CmPopDownCodeBox(Widget, CmRegWad*, XtPointer);
  friend void CmUpdateCodeBox(Widget, CmRegWad*, XtPointer);
  friend void CmOkCodeBox(Widget, CmRegWad*, XtPointer);
  friend void CmEditCodeBox(Widget, CmFigureRegistrar*, XtPointer);
};

#endif
