/* $Date: 91/12/11 16:42:37 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*************************************************************************
 CmMenu.h - Menu Definitions
 Contact: sniyogi

 CmMenu: was created to avoid tedious Xt calls and merely encapsulate 
  all redundant information into a C++ object and its definitions.  
  Also, this abstraction can allow us to switch menu methods completely
  if we wish to do so.

   File  Edit    Options <-- these are all CmMenuPanes
  ------ ----    -------
   New   Create  <--- these are all CmMenuItems

 To use CmMenu:
   1. Create a CmMenu
   2. Add a pane to it         (AddPane)
   3. Add an item to the pane  (AddItem) with an optional callback
    (if a callback is not supplied, then one can obtain the menu 
     item with MenuItem(...) and add a callback with XtAddCallback)
 *************************************************************************/

#ifndef _CMMENU
#define _CMMENU  

#include <CDS.h>

#define MAXPANES  10
#define MAXMENUITEMS  15

// Accessory to CmMenuPane.
class CmMenuItem {
 private:
  Widget item;          // Actual widget item
  CmString itemname;    // String within item
 public:
  CmMenuItem(const CmString &, Widget, WidgetClass);  // Constructor
  ~CmMenuItem();                 // Destructor
  Widget ItemnameToWidget(const CmString &);  // returns item if CmString matchs itemname
};

// Accessory to CmMenu
class CmMenuPane {
 private:
  Widget pane;             // Actual widget
  CmString panewidgetname; // widget name
  CmString panename;       // actual string "file", "edit", etc.

  CmMenuItem *item[MAXMENUITEMS];  // items underneath pane
  int items;               // no of items underneath pane

  Widget cascade;        // Necessary for cascaded menus
  CmString cascadewidgetname;  // widget name

 public:
  CmMenuPane(const CmString &, Widget); // Constructor
  ~CmMenuPane();                // Destructor
    void AddItem(const CmString &);
  void AddItem(const CmString &, WidgetClass type); 
                                      // Add item to pane
  Widget ItemnameToWidget(const CmString &);  // returns widget item if match
  Widget Pane(); // returns pane widget
  CmMenuPane* PanenameToCmMenuPane(const CmString &);  // returns widget pane if match.
};

class CmMenu {
 private:
  Widget menubar;           // Menu core
  CmMenuPane *pane[MAXPANES];   // panes underneath menu
  int panes;                // no of panes underneath menu
  CmMenuPane* FindPane(const CmString &);  // convenience routine for AddItem
public:
  CmMenu(Widget); // Constructor
  ~CmMenu();      // Destructor

  // Selector
  Widget GetMenubar() {return menubar;};
  Widget GetItem(const CmString &, const CmString &);
  Widget GetPane(const CmString &);

  // Addition of panes
  void AddPane(const CmString &);   // Usage: AddPane("File");

  // Addition of items
  // Note overloading:
  // Usage: AddItem("File", "New", MenuNewCB, value); adds a callback
  // Usage: AddItem("File", "New"); doesn't add a callback.   
  //  but we can add it by using XtAddCallback(MenuItem("File", "Edit"), ...) 
  //  equally well.
  void AddItem(const CmString &, const CmString &); 
  void AddItem(const CmString &, const CmString &, XtCallbackProc, caddr_t);  
  void AddToggle(const CmString &, const CmString &);
  void AddToggle(const CmString &, const CmString &, XtCallbackProc, caddr_t);
  Boolean GetToggleState(const CmString &, const CmString &);
  void SetToggleState(const CmString &, const CmString &, Boolean);
  void SetSensitive(const CmString &, const CmString &, Boolean);
};
#endif



