/* $Date: 91/12/13 10:17:30 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*********************************************
 CmNavigator.cc - Navigator/Page code
 Contact: joe, maschaub
 *********************************************/
#include <CmPage.h>
#include <CmFigure.h>

/********************************
 CmPage constructor
  Called by CmNavigator
  Creates a file page
**********************************/
CmPage::CmPage(const CmString &name) {
  Name = name;
  Title = name;
  NumberKeywords = 0;
  PageCmFigure = NULL;
}

/********************************
 CmPage destructor
*********************************/
CmPage::~CmPage() {
  if (PageCmFigure)
    delete PageCmFigure;
}

/****************************************************************************
  CmPage copying constructor
   Makes a copied page of the given page, copying name, title, screen
   definition string, and model definition string only. All other private
   members are either inappropirate (i.e., like is_file_page or parent) to copy
   or unnecessary to copy now (like page_cm_figure, which can be initialized
   from the screen definition string.
****************************************************************************/
CmPage::CmPage(const CmString & name, CmPage *const n) {
  Name = name;
  Title = name;
  ScreenDefinitionString = "";
  n->PageCmFigure->GetCmFigureDefinition(ScreenDefinitionString, 1,0);
  PageConstructorText = n->PageConstructorText;
  PageEntryText = n->PageEntryText;
  PageExitText = n->PageExitText;
}


/********************************
 CmPage output
**********************************/

static CmString handle_quote(CmString &string) {
  CmString outstring = string;
  outstring.Gsub("\"", "\\\"");
  return outstring;
}

ostream& operator << (ostream &stream, CmPage *const page) {
  stream << "\n\\begin_page{" << page->Name << "}\n"
         << "\\title{" << page->Title << "}\n";
  if ( page->PageConstructorText != "" )
    stream << "\\page_constructor_text \"" 
      << handle_quote(page->PageConstructorText) << "\"\n";
  if ( page->PageEntryText != "" )
    stream << "\\page_entry_text \"" 
      << handle_quote(page->PageEntryText) << "\"\n";
  if ( page->PageExitText != "" )
    stream << "\\page_exit_text \"" 
      << handle_quote(page->PageExitText) << "\"\n";

  if (page->PageCmFigure)
    stream << "\\begin_screen\n" << page->PageCmFigure << "\\end_screen\n";
  else if (page->ScreenDefinitionString != "")
    stream << "\\begin_screen\n" << page->ScreenDefinitionString 
           << "\n\\end_screen\n";
  
  stream << "\\end_page\n";
  return (stream);
}





