/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/converters/RCS/AtConverters.c,v 3.1 91/01/03 17:33:04 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef _AtDevelopment_
#include "AtConverters.h"
#include "Text.h"
#include "FontFamily.h"
#include "Plot.h"
#include "Barchart.h"
#else
#include <At/AtConverters.h>
#include <At/Text.h>
#include <At/FontFamily.h>
#include <At/Plot.h>
#include <At/Barchart.h>
#endif

/**********************************************************************/

void AtCvtStringToDouble (args, num_args, from, to)
     XrmValue *args;
     Cardinal *num_args;
     XrmValue *from;
     XrmValue *to;
{
  static double value;
  extern double atof();

  if (*num_args != 0)
    XtErrorMsg("cvtStringToDouble","wrong Parameters","XtToolkitError",
	       "String to double conversion takes no arguments", 
	       (String *)NULL, (Cardinal *)NULL);
  
  value = atof(from->addr);
  to->size = (unsigned int) sizeof(double);
  to->addr = (caddr_t) &value;
}

void AtRegisterDoubleConverter()
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRDouble, AtCvtStringToDouble, NULL, 0);
    registered = True;
  }
}

/**********************************************************************/

void AtCvtStringToFontSize (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;
  
  result = AtFontStringToSize ((char*)fromVal->addr);
  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof (int);
}

void AtRegisterFontSizeConverter()
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRFontSize, AtCvtStringToFontSize, NULL, 0);
    registered = True;
  }
}

/**********************************************************************/
    
void AtCvtStringToFontStyle (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);

  if (!strcasecmp ((char*)fromVal->addr, "plain"))
    result =  AtFontPLAIN;
  else if (!strcasecmp ((char*)fromVal->addr, "bold"))
    result =  AtFontBOLD;
  else if (!strcasecmp ((char*)fromVal->addr, "italic"))
    result =  AtFontITALIC;
  else if (!strcasecmp ((char*)fromVal->addr, "bolditalic"))
    result =  AtFontBOLDITALIC;
  else {
    XtWarning("Illegal font style -- using AtFontPLAIN");
    result = AtFontPLAIN;
  }
}

void AtRegisterFontStyleConverter()
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRFontStyle, AtCvtStringToFontStyle, NULL, 0);
    registered = True;
  }
}

/**********************************************************************/
   
void AtCvtStringToJustify (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);

    if (!strcasecmp ((char*)fromVal->addr, "left"))
    result =  AtTextJUSTIFY_LEFT;
  else if (!strcasecmp ((char*)fromVal->addr, "top"))
    result =  AtTextJUSTIFY_TOP;
  else if (!strcasecmp ((char*)fromVal->addr, "center"))
    result =  AtTextJUSTIFY_CENTER;
  else if (!strcasecmp ((char*)fromVal->addr, "right"))
    result = AtTextJUSTIFY_RIGHT;
  else if (!strcasecmp ((char*)fromVal->addr, "bottom"))
    result = AtTextJUSTIFY_BOTTOM;
  else {
    XtWarning("Illegal justification");
    result = AtTextJUSTIFY_CENTER;
  }
}

void AtRegisterJustifyConverter()
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRAtJustify, AtCvtStringToJustify, NULL, 0);
    registered = True;
  }
}

/**********************************************************************/

void AtCvtStringToLinestyle (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);

  if (!strcasecmp ((char*)fromVal->addr, "linesolid"))
    result =  LineSolid;
  else if (!strcasecmp ((char*)fromVal->addr, "linedoubledash"))
    result =  LineDoubleDash;
  else if (!strcasecmp ((char*)fromVal->addr, "lineonoffdash"))
    result =  LineOnOffDash;
  else {
    XtWarning("Illegal linestyle -- using LineSolid");
    result = LineSolid;
  }
}

void AtRegisterLinestyleConverter()
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRLinestyle, AtCvtStringToLinestyle, NULL, 0);
    registered = True;
  }
}

/**********************************************************************/

void AtCvtStringToMarker (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);
  
  if (!strcasecmp ((char*)fromVal->addr, "circle"))
    result =  AtMarkerCIRCLE;
  else if (!strcasecmp ((char*)fromVal->addr, "square"))
    result =  AtMarkerSQUARE;
  else if (!strcasecmp ((char*)fromVal->addr, "triangle"))
    result =  AtMarkerTRIANGLE;
  else if (!strcasecmp ((char*)fromVal->addr, "cross"))
    result =  AtMarkerCROSS;
  else if (!strcasecmp ((char*)fromVal->addr, "star"))
    result =  AtMarkerSTAR;
  else if (!strcasecmp ((char*)fromVal->addr, "diamond"))
    result =  AtMarkerDIAMOND;
  else if (!strcasecmp ((char*)fromVal->addr, "point"))
    result =  AtMarkerPOINT;
  else {
    XtWarning("Illegal marker -- using AtMarkerCIRCLE");
    result = AtMarkerCIRCLE;
  }
}

void AtRegisterMarkerConverter()
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRAtMarker, AtCvtStringToMarker, NULL, 0);
    registered = True;
  }
}

/**********************************************************************/

void AtCvtStringToPattern (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);


  if (!strcasecmp ((char*)fromVal->addr, "gray0"))
    result =  AtGRAY0;
  else if (!strcasecmp ((char*)fromVal->addr, "gray1"))
    result =  AtGRAY1;
  else if (!strcasecmp ((char*)fromVal->addr, "gray2"))
    result =  AtGRAY2;
  else if (!strcasecmp ((char*)fromVal->addr, "gray3"))
    result =  AtGRAY3;
  else if (!strcasecmp ((char*)fromVal->addr, "gray4"))
    result =  AtGRAY4;
  else if (!strcasecmp ((char*)fromVal->addr, "gray5"))
    result =  AtGRAY5;
  else {
    XtWarning("Illegal Pattern");
    result = AtGRAY0;
  }
}

void AtRegisterPatternConverter()
{
  static Boolean registered = False;
  
  if (registered == False) {
    XtAddConverter(XtRString, XtRPattern, AtCvtStringToPattern, NULL, 0);
    registered = True;
  }
}



