/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/Axis.h,v 3.2 91/03/17 19:57:27 crcraig Exp Locker: crcraig $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtAxis_h
#define _AtAxis_h

#include <stdio.h>
    
#define XtNlabel "label"
#define XtNlabelFontFamily "labelFontFamily"
#define XtNnumberFontFamily "numberFontFamily"
#define XtNlabelSize "labelSize"
#define XtNnumberSize "numberSize"
#define XtNnumberStyle "numberStyle"
#define XtNaxisColor "axisColor"
#define XtNnumberColor "numberColor"
#define XtNlabelColor "labelColor"
#define XtNmin "min"
#define XtNmax "max"    
#define XtNpixmin "pixmin"
#define XtNpixmax "pixmax"    
#define XtNtransform "transform"
#define XtNvertical "vertical"
#define XtNmirror "mirror"
#define XtNdrawNumbers "drawNumbers"    
#define XtNdrawGrid "drawGrid"
#define XtNticsOutside "ticsOutside"
#define XtNnumbersOutside "numbersOutside"
#define XtNautoNumber "autoNumber"
#define XtNticInterval "ticInterval"
#define XtNsubtics "subtics"    
#define XtNticDensity "ticDensity"
#define XtNsubticDensity "subticDensity"
#define XtNticMultiplier "ticMultiplier"
#define XtNticFormat "ticFormat"
#define XtNticsOutside "ticsOutside"
#define XtNticsInside "ticsInside"
#define XtNticLength "ticLength"
#define XtNsubticLength "subticLength"   
#define XtNaxisNeedsRedraw "axisNeedsRedraw"    
#define XtNticLabels "ticLabels"
#define XtNerrorCallback "errorCallback"
    
#define XtCLabel "Label"
#define XtCMin "Min"
#define XtCMax "Max"    
#define XtCPixmin "Pixmin"
#define XtCPixmax "Pixmax"    
#define XtCTransform "Transform"
#define XtCVertical "Vertical"
#define XtCMirror "Mirror"
#define XtCDrawNumbers "DrawNumbers"    
#define XtCDrawGrid "DrawGrid"
#define XtCTicsOutside "TicsOutside"
#define XtCNumbersOutside "NumbersOutside"
#define XtCAutoNumber "AutoNumber"
#define XtCTicInterval "TicInterval"
#define XtCSubtics "Subtics"    
#define XtCTicDensity "TicDensity"
#define XtCSubticDensity "SubticDensity"
#define XtCTicMultiplier "TicMultiplier"
#define XtCTicFormat "TicFormat"
#define XtCTicsOutside "TicsOutside"
#define XtCTicsInside "TicsInside"    
#define XtCTicLength "TicLength"
#define XtCaxisNeedsRedraw "AxisNeedsRedraw"    
#define XtCTicLabels "TicLabels"
#define XtCErrorCallback "ErrorCallback"

/* Class record constants */

extern WidgetClass atAxisObjectClass;

typedef struct _AtAxisClassRec * AtAxisObjectClass;
typedef struct _AtAxisRec      * AtAxisObject;

extern void AtAxisComputeTicSpacing(AtAxisObject, int);
extern void AtAxisChangeNumbering(AtAxisObject, double, int);
extern int AtAxisWidth(AtAxisObject);
extern void AtAxisChangeBounds(AtAxisObject, double, double);
extern void AtAxisGetBounds(AtAxisObject, double *, double *);
extern void AtAxisSetLocation(AtAxisObject, int, int, int, int);
extern void AtAxisGetLocation(AtAxisObject, int *, int *, int *, int *);
extern void AtAxisDraw(Display *, Window, AtAxisObject, Pixel);
extern void AtAxisDrawGrid(Display *, Window, AtAxisObject, int, int);
extern void AtAxisDrawGridRegion(Display *, Window, AtAxisObject,
				 int, int, Region);

extern int AtAxisWidthPS(AtAxisObject);
extern void AtAxisDrawPS(FILE *,AtAxisObject, int, int, int, int, int, int);
#endif /* _AtAxis_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */

