/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/AxisP.h,v 3.3 91/07/15 23:16:11 crcraig Exp Locker: dot $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AxisP_h
#define _AxisP_h    

#include <X11/IntrinsicP.h>
#include <X11/ObjectP.h>

#ifdef _AtDevelopment_
#include "Text.h"
#include "Scale.h"    
#include "Axis.h"
#else
#include <At/Text.h>
#include <At/Scale.h>    
#include <At/Axis.h>
#endif    
/*
 * define an Xt Object named Axis.  It will have resources settable by
 * XtSetValues.  The plotter widget will have three instances of this object,
 * for the x, y, and y2 axes.  This object really does nothing but
 * act as a container for resources.
 */

typedef struct _AtAxisPart {
    /* resources */
    String label;
    String labelFontFamily;
    String numberFontFamily;
    int labelSize;
    int numberSize;
    int numberStyle;
    Pixel axisColor;
    Pixel numberColor;
    Pixel labelColor;

    double axis_min,axis_max;
    short transform;

    Boolean vertical;
    Boolean mirror;
    Boolean drawNumbers;
    Boolean drawGrid;
    Boolean autoNumber;
    double ticInterval;
    short subtics;
    short ticDensity;
    short subticDensity;
    double ticMultiplier;
    String ticFormat;
    Boolean ticsOutside;
    Boolean ticsInside;
    Boolean numbersOutside;
    short ticLength;
    short subticLength;
    String ticLabels;
    XtCallbackList axisNeedsRedraw;
    XtCallbackList errorCallback;

    /* private state */
    AtScale *scale;
    AtText *labelText;
    AtFontFamily *labelFF, *numberFF;
    XFontStruct *numberFont;
    GC axisGC, numberGC, labelGC, dottedGC;

    short x1,y1,x2,y2;           /* where to draw the axis */
    Boolean valid;               /* Is info in display valid? */
    XSegment *lines;             /* Solid lines */
    XSegment *dlines;            /* Dotted lines */
    char **ticlabels;            /* Pointer to array of tic label pointers */
    short *ticcoords;           /* array of coordinates for each tic label */
    double *ticvalues;           /* pointer to array of tic values used */
    short *subticcoords;        /* array of coordinates for each subtic */
    short nlines;                /* Number of solid segments */
    short ndlines;               /* Number of dotted segments */
    short nticlabels;            /* Number of tic-labels */
    short ntics;                 /* number of tic values */
    short labelX, labelY;        /* coordinates of the axis label */
    double origin;
    short maxnumwidth;
    short totalsubtics;
    String ticlabelcpy;
    String *userticlabels;
    int nuserticlabels;
} AtAxisPart;

typedef struct _AtAxisRec {
    ObjectPart object;
    AtAxisPart axis;
} AtAxisRec;

typedef struct _AtAxisClassPart {
    int nothing_here;
} AtAxisClassPart;

typedef struct _AtAxisClassRec {
    ObjectClassPart object_class;
    AtAxisClassPart axis_class;
} AtAxisClassRec;

extern AtAxisClassRec atAxisClassRec;

#define MIN_MARGIN       5

#endif
