/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/BarchartP.h,v 3.2 91/03/17 19:57:47 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */


#ifndef _AtBarchartP_h
#define _AtBarchartP_h

#include <X11/IntrinsicP.h>

#ifdef _AtDevelopment_
#include "PlotP.h"
#include "Barchart.h"
#else
#include <At/PlotP.h>
#include <At/Barchart.h>
#endif

typedef struct _AtBarchartClassPart {
  void (*getrects)(AtPlotWidget, AtScale *, AtScale *, Region,
		   XRectangle **, int *);
  void (*redraw)(Display *, Window, AtPlotWidget, XRectangle *);
  void (*drawinc)(Display *, Window, AtPlotWidget, AtScale *, AtScale *,
		  Region);
} AtBarchartClassPart;

typedef struct _AtBarchartClassRec {
  ObjectClassPart object_class;
  AtPlotClassPart plot_class;
  AtBarchartClassPart barchart_class;
} AtBarchartClassRec;

extern AtBarchartClassRec atBarchartClassRec;

typedef struct _AtBarchartPart {
    /* resources */
  double xMin;
  double xMax;
  double *yPoints;
  int numPoints;
  double density;  /* ranges between 0 - 1.0, for bar thickness. */
  int position;
  Boolean shading; /* fill bars with a pixmap pattern */
  int pattern;     /* if shading, specify pixmap pattern, from a
		      predefined set. default 0, no pixmap */

  /* private state */

  double xIncrement;
  double *xpts;
  double *ypts;
  XPoint *pixpts;
  XPoint *oldpixpts;
  short zeroxpt;
  short zeroypt;
  double halfdensity;
  Boolean valid;
  GC fillGc;
  Boolean refreshBars; /* if true, refresh only this barchart */
  Boolean firstRead; 
} AtBarchartPart;

typedef struct _AtBarchartRec {
    ObjectPart object;
    AtPlotPart plot;
    AtBarchartPart barchart;
} AtBarchartRec;

#define XtInheritGetRects ((XtProc) _XtInherit)
#define XtInheritRedraw ((XtProc) _XtInherit)
#define XtInheritDrawInc ((XtProc) _XtInherit)

#endif /* _AtBarchartP_h */
