/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/cli/RCS/CliP.h,v 3.2 91/05/09 14:52:00 dot Exp $ */

/* 
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */

#ifndef _AtCliP_h
#define _AtCliP_h    

#include <Xm/XmP.h>
#include <Xm/TextP.h>
#include <X11/StringDefs.h>
#include <setjmp.h>    

#ifdef _AtDevelopment_
#include "Cli.h"
#else
#include <At/Cli.h>
#endif

typedef struct {
    int unused; /* to satisfy the compiler */
} AtCliClassPart;

typedef struct _AtCliClassRec {
    CoreClassPart core_class;
    XmPrimitiveClassPart primitive_class;
    XmTextClassPart text_class;
    AtCliClassPart cli_class;
} AtCliClassRec;

extern AtCliClassRec atCliClassRec;

typedef struct _AtCliPart {
    /* resources */
    int numHistoryItems;
    Boolean grabStdout;
    Boolean grabStderr;
    Boolean pageMode;
    XtCallbackList *inputCallback;
    int saveLines;

    /* private state */
    XmTextPosition inputpos;
    Boolean doing_modal_input;
    jmp_buf mark;
    char **history;
    int historypos;
    int fildes[2];
    int stderr_fildes[2];
} AtCliPart;

typedef struct _AtCliRec {
    CorePart core;
    XmPrimitivePart primitive;
    XmTextPart text;
    AtCliPart cli;
} AtCliRec;

#endif

    
