/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/ContourPlotP.h,v 3.2 91/03/17 19:58:06 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtContourPlotP_h
#define _AtContourPlotP_h    

#include <X11/IntrinsicP.h>

#ifdef _AtDevelopment_
#include "PlotP.h"
#include "ContourPlot.h"
#else
#include <At/PlotP.h>
#include <At/ContourPlot.h>
#endif 

/* structs for private resources and such */
typedef struct _MidPoint {
  double x,y,z;
} MidPoint;

typedef struct _RealSegment {
  double x1, x2, y1, y2;
} RealSegment;

typedef struct _AtContourPlotClassPart {
  int ack_pppth;
} AtContourPlotClassPart;

typedef struct _AtContourPlotClassRec {
  ObjectClassPart object_class;
  AtPlotClassPart plot_class;
  AtContourPlotClassPart contourplot_class;
} AtContourPlotClassRec;

extern AtContourPlotClassRec atContourPlotClassRec;

typedef struct _AtContourPlotPart {
  /* resources */
  int contours;
  int xNumPoints, yNumPoints;
  double xMin, xMax, yMin, yMax;
  double *xPoints, *yPoints, *zPoints;
  /* private state */
  Boolean valid;
  Boolean contour_valid;
  double *xpts, *ypts, *zpts;
  double xinterval, yinterval;
  double minz, maxz, interval;
  RealSegment *realsegs;
  int nsegs, seglistsize;
  XSegment *segments;
} AtContourPlotPart;

typedef struct _AtContourPlotRec {
  ObjectPart object;
  AtPlotPart plot;
  AtContourPlotPart contourplot;
} AtContourPlotRec;

#endif /* _AtContourPlotP_h */
