/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/FBarchart.c,v 3.3 91/03/22 13:36:13 crcraig Exp Locker: dot $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.
***************************************************************** */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef _AtDevelopment_
#include "Scale.h"
#include "AtConverters.h"
#include "BarchartP.h"
#include "FBarchartP.h"
#else
#include <At/Scale.h>
#include <At/AtConverters.h>
#include <At/BarchartP.h>
#include <At/FBarchartP.h>
#endif

#define offset(field) XtOffset(AtFBarchartWidget, field)

static XtResource resources[] = {
  {XtNdataFile, XtCDataFile, XtRString,
     sizeof(String), offset(fbarchart.dataFile),
     XtRString, NULL}
};
#undef offset

static void Initialize(AtFBarchartWidget, AtFBarchartWidget);
static void Destroy(AtFBarchartWidget);
static Boolean SetValues(AtFBarchartWidget, AtFBarchartWidget, AtFBarchartWidget);

AtFBarchartClassRec atFBarchartClassRec = {
{ /* core part */
    /* superclass         */    (WidgetClass)&atBarchartClassRec,
    /* class_name         */    "AtFBarchart",
    /* widget_size        */    sizeof(AtFBarchartRec),
    /* class_initialize   */    NULL,
    /* class_part_initialize*/  NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    (XtInitProc) Initialize,
    /* initialize_hook    */    NULL,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* pad                */    0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* pad                */    FALSE,
    /* pad                */    FALSE,
    /* pad                */    FALSE,
    /* pad                */    FALSE,
    /* destroy            */    (XtWidgetProc) Destroy,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* set_values         */    (XtSetValuesFunc) SetValues,
    /* set_values_hook    */    NULL,
    /* pad                */    NULL,
    /* get_values_hook    */    NULL,
    /* pad                */    NULL,
    /* version            */    XtVersion,
    /* callback_offsets   */    NULL,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* extension            */  NULL
},

/* AtPlotClassPart initialization */
{
    /* draw()       */   XtInheritDraw,
    /* drawIcon()   */   XtInheritDrawIcon,
    /* resize()     */   XtInheritRescale,
    /* rescale()    */   XtInheritRescale,
    /* drawPS()     */   XtInheritDrawPS, /* change to DrawPS later */
    /* drawIconPS() */   XtInheritDrawIconPS,
    /* checkhit()   */   NULL,
},
{
/* AtBarchartClassPart initialization */
    /* getrects()   */   XtInheritGetRects,
    /* redraw()     */   XtInheritRedraw,
    /* drawinc()    */   XtInheritDrawInc,
}
};

WidgetClass atFBarchartWidgetClass = (WidgetClass) &atFBarchartClassRec;

#define AtWarning(w,msg) XtWarning(msg)


#define NEW new->fbarchart

static void Initialize(AtFBarchartWidget request, AtFBarchartWidget new)
{
  NEW.firsttime = True;
  if(NEW.dataFile != NULL)  /* read data from file */
    ReadFile (new);
  else
    fprintf(stderr, "No data file given\n");
  NEW.firsttime = False;
  new->plot.redisplay = False; 
}


#define Changed(field) (strcmp(new->fbarchart.field, current->fbarchart.field))
static Boolean SetValues(AtFBarchartWidget current,
                         AtFBarchartWidget request,
                         AtFBarchartWidget new)
{
  Arg a;

  if (Changed(dataFile)) {
    ReadFile (new);
  }
  if ((new->plot.redisplay) && /* redisplay all plots */
      (new->object.widget_class == atFBarchartWidgetClass) &&
      (!NEW.firsttime)) {
    new->plot.redisplay = False;
    XtSetArg(a, XtNneedsRedraw, True);
    XtSetValues(new, &a, 1);        /* set a constraint resource */
  }
  else if ((new->barchart.refreshBars) &&
	   (new->object.widget_class == atFBarchartWidgetClass) &&
	   (!NEW.firsttime))  {
    new->barchart.refreshBars = False;
    XtSetArg(a, XtNneedsRefresh, True);
    XtSetValues(new, &a, 1);        /* set a constraint resource */    
  }
  return False;
}

void ReadFile (AtFBarchartWidget bcw)
{
  FILE *f;
  char line[100];
  int i, nump;
  Arg args[5];

  f = fopen(bcw->fbarchart.dataFile, "r");
  if (f == NULL) {
    fprintf(stderr, "can not open %s\n", bcw->fbarchart.dataFile);
    return;
  }

  i = 0;
  while (fgets(line,99, f) && line[0] != '\n') {
    i++;
  }
  nump = i;
  fclose(f);

  if (bcw->fbarchart.firsttime)
    bcw->fbarchart.y = (double *)XtMalloc(sizeof(double) * nump);
  else 
    bcw->fbarchart.y = (double *) 
      XtRealloc (bcw->fbarchart.y, sizeof(double) * nump);

  f = fopen(bcw->fbarchart.dataFile, "r");
  if (f == NULL) {
    fprintf(stderr, "can not open %s\n", bcw->fbarchart.dataFile);
    return;
  }

  i = 0;
  while (fgets(line,99, f) && i<nump) {
    sscanf(line, "%lf", &bcw->fbarchart.y[i]);
    i++;
  }
  fclose(f);

  i = 0;
  XtSetArg(args[i], XtNnumPoints, nump); i++;
  XtSetArg(args[i], XtNyPoints, bcw->fbarchart.y); i++;
  XtSetValues(bcw, args, i);
}


static void Destroy (AtFBarchartWidget w)
{
  XtFree (w->fbarchart.y);
}





