/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/text/RCS/FontFamily.h,v 3.3 91/01/03 20:11:52 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _At_FontFamily_h
#define _At_FontFamily_h    

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
/* have to include Intrinsic.h to get definition
   of Cardinal for type converter */    

/* type faces */
#define AtFontPLAIN       0
#define AtFontBOLD        1      /* set and clear these two bits to get */
#define AtFontITALIC      2      /* the 4 possible typefaces */
#define AtFontBOLDITALIC  3

/* point sizes */
#define AtFontSMALLEST 0 
#define AtFontSMALL    1 
#define AtFontMEDIUM   2 
#define AtFontNORMAL   3 
#define AtFontBIG      4 
#define AtFontBIGGEST  5

typedef struct _AtFontFamily {
    Display *dpy;
    short refcount;
    int num;
    XFontStruct **cache;
    struct _AtFontFamily *next;
} AtFontFamily;

extern AtFontFamily *AtFontFamilyGet(Display *, char *);
extern void AtFontFamilyRelease(AtFontFamily *);
extern XFontStruct *AtFontFetch(AtFontFamily *, int, int);
extern int AtFontPointSize(AtFontFamily *, int);
extern int AtFontPixelSize(AtFontFamily *, int);
extern int AtFontStringToSize(char *);
extern void AtCvtStringToFontSize(XrmValue*, Cardinal *, XrmValue *, XrmValue *);
extern void AtRegisterFontSizeConverter();

extern char *AtFontFamilyGetName(AtFontFamily *);
#define AtFontFamilyGetDisplay(family) ((family)->dpy)
#define AtFontBigger(size) ((size<AtFontBIGGEST) ? (size+1) : (size))
#define AtFontSmaller(size) ((size>AtFontSMALLEST) ? (size-1) : (size))
#define AtFontEmphasize(face) (face | AtFontBOLD)
#define AtFontDeemphasize(face) (face & ~AtFontBOLD)
#define AtFontItalicize(face) (face | AtFontITALIC)
#define AtFontDeitalicize(face) (face & ~AtFontITALIC)

extern int AtFontPSTextWidth(AtFontFamily *, int, int, char *, int);
extern int AtFontPSAscent(AtFontFamily *, int, int);
extern int AtFontPSDescent(AtFontFamily *, int, int);
extern char *AtFontPSName(AtFontFamily *, int);

/* Resource classes and types for use with the X Toolkit */
#define XtCFontFamily "FontFamily"
#define XtCFontSize   "FontSize"
#define XtCFontStyle  "FontStyle"
#define XtRFontSize   "FontSize"
#define XtRFontStyle  "FontStyle"



#endif
