/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/help/RCS/HelpP.h,v 3.1 91/01/03 17:40:12 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _HelpP_h
#define _HelpP_h

#include <X11/IntrinsicP.h>
#include <X11/CompositeP.h>

#ifdef _AtDevelopment_
#include "Help.h"
#else
#include <At/Help.h>
#endif

typedef struct _AtHelpPart {
    /* resources */
    String filename;
    String fontFamily;
    int fontSize;
    String title;
    String doneLabel;
    String tocHeading;
    String indexHeading;
    XtCallbackList doneCallback;
    /* private state */
    String text;
    AtFontFamily *ff;
    XFontStruct *font;
    Widget titlew;
    Widget donew;
    Widget toclabel;
    Widget indexlabel;
    Widget paned;
    Widget indexsw;
    Widget index;
    Widget tocsw;
    Widget toc;
    Widget displayersw;
    Widget displayer;
    char **sectionNames;
    int *sectionOffsets;
    int numSections;
    int maxSections;
    char **citeNames;
    int *citeOffsets;
    int numCites;
    int maxCites;
    int sectionNum;
    int subsectionNum;
    int subsubsectionNum;
    XmString *sections;
    XmString *citations;
} AtHelpPart;

typedef struct _AtHelpRec {
    CorePart core;
    CompositePart composite;
    AtHelpPart help;
} AtHelpRec;

typedef struct {
    int mumbo_jumbo;
} AtHelpClassPart;

typedef struct _AtHelpClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    AtHelpClassPart help_class;
} AtHelpClassRec;

extern AtHelpClassRec atHelpClassRec;

#endif /* _HelpP_h */
