/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/text/RCS/LabelP.h,v 3.1 91/01/03 17:54:42 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _LabelP_h
#define _LabelP_h

#include <X11/CoreP.h>

#ifdef _AtDevelopment_
#include "Label.h"
#include "Text.h"
#else
#include <At/Label.h>
#include <At/Text.h>
#endif

typedef struct {
    int empty;
} AtLabelClassPart;

typedef struct _AtLabelClassRec {
    CoreClassPart       core_class;
    AtLabelClassPart    label_class;
} AtLabelClassRec;

extern AtLabelClassRec AtlabelClassRec;

typedef struct {

/* resources */

  String     label_string;
  String     font_family;
  int        font_size;
  Pixel      foreground;
  int        horizontal_justify; 
  int        vertical_justify;   
  Boolean    rotate;         /* rotate text 90 degree, counter clockwise */  
  Dimension  margin_width;    
  Dimension  margin_height;   

/* private state */

  Dimension  text_w, text_h; /* width and height of the label string */
  Position   text_a, text_d; /* ascent and descent of the label string */
  Position   x, y; /* coordinates of the statrt of the text used 
		      by AtTextDraw */
  AtFontFamily *family;
  AtText     *formated_text; /* created by AtTextCreate() */
  GC       label_gc;
} AtLabelPart;

typedef struct _AtLabelRec {
    CorePart            core;
    AtLabelPart         label;
} AtLabelRec;

#endif /* _LabelP_h */
