/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/layout/RCS/LayoutP.h,v 3.1 91/01/03 17:44:44 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtLayoutP_h
#define _AtLayoutP_h
    
#include <X11/IntrinsicP.h>    
#include <X11/CompositeP.h>

#ifdef _AtDevelopment_
#include "Layout.h"
#else
#include <At/Layout.h>
#endif

/* internal data structures */

typedef struct _Layout {
    short type;
    XrmQuark name;
    Widget widget;
    short x,y,w,h;
    short stretch, shrink;
    struct _Layout *items;
    struct _Layout *next;
    short num;
} Layout;

/* values of the type field */
#define ROWTYPE     1
#define COLTYPE     2
#define WIDGETTYPE  3
#define SPACETYPE   4

/* tokens for the parser */
#define END      0
#define LBRACKET 1
#define RBRACKET 2
#define LPAREN   3
#define RPAREN   4
#define PLUS     5
#define MINUS    6
#define ROW      7  
#define COL      8
#define SPACE    9
#define FILL     10
#define NUMBER   11
#define IDENT    12
#define ERROR    13

typedef struct {
    int zip_iddy_doo_dah;
} AtLayoutClassPart;

typedef struct _AtLayoutClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    AtLayoutClassPart layout_class;
} AtLayoutClassRec;

extern AtLayoutClassRec atLayoutClassRec;

typedef struct {
    /* resource */
    String layout;
    int defaultSpacing;
    /* private state */
    Layout *lo;
    /* used by the lexer and parser */
    char *nextc;
    char *idval;
    int numval;
    int curtok;
} AtLayoutPart;

typedef struct _AtLayoutRec {
    CorePart core;
    CompositePart composite;
    AtLayoutPart layout;
} AtLayoutRec;

#endif /* _AtLayoutP_h */
