/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/msgline/RCS/MessageLineP.h,v 3.1 91/01/03 17:47:41 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtMessageLineP_h
#define _AtMessageLineP_h    

#include <Xm/XmP.h>
#include <Xm/TextP.h>
#include <setjmp.h>    

#ifdef _AtDevelopment_
#include "MessageLine.h"
#else
#include <At/MessageLine.h>
#endif

typedef struct {
    int unused; /* to satisfy the compiler */
} AtMessageLineClassPart;

typedef struct _AtMessageLineClassRec {
    CoreClassPart core_class;
    XmPrimitiveClassPart primitive_class;
    XmTextClassPart text_class;
    AtMessageLineClassPart MessageLine_class;
} AtMessageLineClassRec;

extern AtMessageLineClassRec atMessageLineClassRec;

typedef struct _AtMessageLinePart {
    /* resources */
    XtCallbackList *inputCallback;

    /* private state */
    XmTextPosition inputpos;
    Boolean doing_sync_input;
    jmp_buf mark;
} AtMessageLinePart;

typedef struct _AtMessageLineRec {
    CorePart core;
    XmPrimitivePart primitive;
    XmTextPart text;
    AtMessageLinePart messageline;
} AtMessageLineRec;

#endif

    
