/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/Plot.c,v 3.3 91/01/28 17:09:04 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef _AtDevelopment_
#include "PlotP.h"
#include "AtConverters.h"
#else
#include <At/PlotP.h>
#include <At/AtConverters.h>
#endif

#define offset(field) XtOffset(AtPlotWidget, field)
static XtResource resources[] = {
  {XtNforeground, XtCForeground, XtRPixel,
     sizeof(Pixel), offset(plot.foreground),
     XtRString, XtDefaultForeground},
  {XtNbackground, XtCBackground, XtRPixel,
     sizeof(Pixel), offset(plot.background),
     XtRString, XtDefaultBackground},
  {XtNlineWidth, XtCLineWidth, XtRInt,
     sizeof(int), offset(plot.lineWidth),
     XtRImmediate, (caddr_t)0},
  {XtNlineStyle, XtCLineStyle, XtRLinestyle,
     sizeof(int), offset(plot.lineStyle),
     XtRImmediate, (caddr_t)LineSolid},
  {XtNdashLength, XtCDashLength, XtRInt,
     sizeof(int), offset(plot.dashLength),
     XtRImmediate, (caddr_t)4},
  {XtNfastUpdate, XtCFastUpdate, XtRBoolean,
     sizeof(Boolean), offset(plot.fastUpdate),
     XtRImmediate, (caddr_t)False},
};
#undef offset

static void Initialize(AtPlotWidget, AtPlotWidget);
static void Destroy(AtPlotWidget);
static Boolean SetValues(AtPlotWidget, AtPlotWidget, AtPlotWidget);
static void ClassPartInitialize(WidgetClass);

AtPlotClassRec atPlotClassRec = {
{ /* core part */
    /* superclass         */    (WidgetClass) &objectClassRec,
    /* class_name         */    "AtPlot",
    /* widget_size        */    sizeof(AtPlotRec),
    /* class_initialize   */    NULL,
    /* class_part_initialize*/  ClassPartInitialize,
    /* class_inited       */    FALSE,
    /* initialize         */    (XtInitProc) Initialize,
    /* initialize_hook    */    NULL,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* pad                */    0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* pad                */    FALSE,
    /* pad                */    FALSE,
    /* pad                */    FALSE,
    /* pad                */    FALSE,
    /* destroy            */    (XtWidgetProc)Destroy,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* set_values         */    (XtSetValuesFunc) SetValues,
    /* set_values_hook    */    NULL,
    /* pad                */    NULL,
    /* get_values_hook    */    NULL,
    /* pad                */    NULL,
    /* version            */    XtVersion,
    /* callback_offsets   */    NULL,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* pad                */    NULL,
    /* extension            */  NULL
},
/* AtPlotClassPart initialization */
{
    /* draw()       */   NULL,
    /* drawIcon()   */   NULL,
    /* resize()     */   NULL,
    /* rescale()    */   NULL,
    /* drawPS()     */	 NULL,
    /* drawIconPS() */   NULL,
    /* checkhit()   */   NULL,
}
};

WidgetClass atPlotWidgetClass = (WidgetClass)&atPlotClassRec;

static void GetGC(AtPlotWidget w)
{
  XGCValues gcv;
  XtGCMask gcmask;

  if (w->plot.fastUpdate)  {
    gcv.foreground = w->plot.background ^ w->plot.foreground;
    gcv.function = GXxor;
    gcmask = GCForeground | GCFunction;
  }
  else {
    gcv.foreground = w->plot.foreground;
    gcv.background = w->plot.background;
    gcmask = GCForeground | GCBackground;
  }
  gcv.line_width = w->plot.lineWidth;
  gcv.line_style = w->plot.lineStyle;
  gcv.dashes = (char) w->plot.dashLength;

  gcmask |= GCLineWidth | GCLineStyle | GCDashList;
  w->plot.gc = XtGetGC(XtParent((Widget)w), gcmask, &gcv);
}

static void FreeGC(AtPlotWidget w)
{
    XtReleaseGC(XtParent((Widget)w), w->plot.gc);
}

static void Initialize(AtPlotWidget request, AtPlotWidget new)
{
  GetGC(new);
  new->plot.redisplay = False;
}

static void Destroy(AtPlotWidget w)
{
  FreeGC(w);
}

static Boolean SetValues(AtPlotWidget current,
			 AtPlotWidget request,
			 AtPlotWidget new)
{
#define Changed(field) (new->plot.field != current->plot.field)

  if (Changed(foreground) || Changed(background) ||
      Changed(lineWidth) || Changed(lineStyle) || Changed(dashLength) ||
      Changed(fastUpdate)) {
    FreeGC(new);
    GetGC(new);
    new->plot.redisplay = True;
  }

  /* nothing to redisplay */
  return False;
#undef Changed    
}

static void ClassPartInitialize(WidgetClass class)
{
  AtPlotWidgetClass plot, super;

  AtRegisterLinestyleConverter();
  AtRegisterMarkerConverter();

  plot = (AtPlotWidgetClass) class;
  super = (AtPlotWidgetClass) plot->object_class.superclass;

#define CheckInherit(proc) \
  if (plot->plot_class.proc == _XtInherit)\
    plot->plot_class.proc = super->plot_class.proc

  CheckInherit(draw);
  CheckInherit(drawIcon);
  CheckInherit(resize);
  CheckInherit(rescale);
  CheckInherit(drawPS);
  CheckInherit(drawIconPS);

#undef CheckInherit
}
