/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/PlotP.h,v 3.2 91/01/28 17:09:13 crcraig Exp Locker: dot $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtPlotP_h
#define _AtPlotP_h    

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/ObjectP.h>

#ifdef _AtDevelopment_
#include "Scale.h"
#include "Plotter.h"
#include "Plot.h"    
#else
#include <At/Scale.h>
#include <At/Plotter.h>
#include <At/Plot.h> 
#endif
/*
 * this widget serves as the base class for any plot type to
 * be displayed in the AtPlotter widget.
 * It is never intended to be instantiated itself.  Only subclasses
 * of it are.
 */

typedef struct _AtPlotClassPart {
#ifdef _NO_PROTO
    void (*draw)();
    void (*drawIcon)();
    void (*resize)();
    void (*rescale)();
    void (*drawPS)();
    void (*drawIconPS)();
    Boolean (*checkhit)();
#else
    void (*draw)(Display *, Window, AtPlotWidget, AtScale *, AtScale *, 
		 Region);
    void (*drawIcon)(Display *, Window, AtPlotWidget, int, int, int, int);
    void (*resize)(AtPlotWidget, AtScale *, AtScale *);
    void (*rescale)(AtPlotWidget, AtScale *, AtScale *);
    void (*drawPS)(FILE *, AtPlotWidget, AtScale *, AtScale *);
    void (*drawIconPS)(FILE*, AtPlotWidget, int, int, int, int);
    Boolean (*checkhit)(AtPlotWidget, int, int);
#endif
} AtPlotClassPart;

typedef struct _AtPlotClassRec {
    ObjectClassPart object_class;
    AtPlotClassPart plot_class;
} AtPlotClassRec;

extern AtPlotClassRec atPlotClassRec;

typedef struct _AtPlotPart {
    /* resources */
    Pixel foreground;
    Pixel background;
    int lineWidth;
    int lineStyle;
    int dashLength;
    Boolean fastUpdate;
    /* private state */
    GC gc;
    Boolean redisplay;
} AtPlotPart;

typedef struct _AtPlotRec {
    ObjectPart object;
    AtPlotPart plot;
} AtPlotRec;

typedef struct {
    double xmin, xmax, ymin, ymax;
} BoundingBox;


#define XtInheritDraw ((XtProc) _XtInherit)
#define XtInheritDrawIcon ((XtProc) _XtInherit)
/* #define XtInheritResize ((XtProc) _XtInherit) */
#define XtInheritRescale ((XtProc) _XtInherit)
#define XtInheritDrawPS ((XtProc) _XtInherit)
#define XtInheritDrawIconPS ((XtProc) _XtInherit)
#define XtInheritCheckHit ((XtProc) _XtInherit)

#endif /* _AtPlotP_h */
