/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/PlotterPS.c,v 3.4 91/07/15 15:15:52 dot Exp Locker: dot $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#include <stdio.h>
#include <X11/Intrinsic.h>

#ifdef _AtDevelopment_
#include "Text.h"
#include "PlotterP.h"
#include "AxisP.h"
#include "PlotP.h"
#else
#include <At/Text.h>
#include <At/PlotterP.h>
#include <At/AxisP.h>
#include <At/PlotP.h>
#endif

#define NUMCHILDREN(w) (w->composite.num_children)
#define CHILD(w,i) (w->composite.children[i])
#define CONSTRAINT(w,i) ((AtPlotterConstraints)(CHILD(w,i)->core.constraints))
#define CHILDCONSTRAINTS(cw) ((AtPlotterConstraints)(cw)->core.constraints)
#define NTHCHILDISDISPLAYED(w, i) (CONSTRAINT(w, i)->plotter.displayed)
#define ISDISPLAYED(cw) (CHILDCONSTRAINTS(cw)->plotter.displayed)
#define DRAWPS(w,i) (*((AtPlotWidgetClass)CHILD(w,i)->core.widget_class)->plot_class.drawPS)
#define DRAWPSCHILD(cw) (*((AtPlotWidgetClass)(cw)->core.widget_class)->plot_class.drawPS)
#define LEGENDICON(f,w,i,x,y,width,height) (*((AtPlotWidgetClass)CHILD(w,i)->core.widget_class)->plot_class.drawIconPS)(f, (AtPlotWidget)CHILD(w,i),x,y,width,height)

#define height(x) AtTextPSAscent(x) + AtTextPSDescent(x)
    
static void drawlegend(FILE *f, AtPlotterWidget w,
		       int x1, int y1, int x2, int y2)
{
    int x, y, h;
    int i;
    AtText *t;

    fprintf(f, "%%%%BeginObject: AtPlotter legend\ngsave\n");
    
    h = height(w->plotter.legendTitleText) + w->plotter.marginWidth;
    for(i=FIRST_PUBLIC_CHILD; i < NUMCHILDREN(w); i++) {
      if (NTHCHILDISDISPLAYED(w, i)) {
	t = CONSTRAINT(w,i)->plotter.legendText;
	if (t != NULL) h += height(t) + w->plotter.legendSpacing;
      }
    }
    
    y = y2 - ((y2 - y1) - h)/2;
    x = x1 + ((x2 - x1) - AtTextPSWidth(w->plotter.legendTitleText))/2;
    AtTextPSDraw(f, w->plotter.legendTitleText, x,
		 y - AtTextPSAscent(w->plotter.legendTitleText));
    y -= height(w->plotter.legendTitleText) + w->plotter.marginWidth;

    for(i = FIRST_PUBLIC_CHILD; i < NUMCHILDREN(w); i++ ) {
	t = CONSTRAINT(w,i)->plotter.legendText;
	if (NTHCHILDISDISPLAYED(w, i) && t != NULL) {
	    h = height(t);
	    LEGENDICON(f,w,i, x1, y, 16, h);
	    AtTextPSDraw(f, t, x1+16+w->plotter.marginWidth,
			 y - AtTextPSAscent(t));
	    y -= h + w->plotter.legendSpacing;
	}
    }
    
    fprintf(f, "grestore\n%%%%EndObject\n");
}    
#undef height


void AtPlotterDrawPS(FILE *f, AtPlotterWidget w,
		     int xll, int yll, int xur, int yur)
{
    int height, width;
    int xaxiswidth, yaxiswidth, y2axiswidth;
    int i;
    int x1, y1, x2, y2;
    int titleX, titleY, legendX;
    Boolean floatx, floaty;
    int originx, originy;
    AtScale *xscale, *yscale, *y2scale;

    fprintf(f, "%%%% BeginObject: AtPlotter\ngsave\n");
    
    x1 = xll;
    y1 = yll;
    x2 = xur;
    y2 = yur;

    if (w->plotter.showLegend) {
	x2 -= w->plotter.legendWidth +
	    w->plotter.marginWidth;
	legendX = x2 +
	    w->plotter.marginWidth;
    }
    
    if (w->plotter.titleText != NULL) {
	titleY = y2 - AtTextPSAscent(w->plotter.titleText);
	y2 -= AtTextPSAscent(w->plotter.titleText) +
	      AtTextPSDescent(w->plotter.titleText) + w->plotter.marginHeight;
    }

    if ((w->plotter.floatingX) && (!w->plotter.framedAxes) &&
        (w->plotter.yaxis->axis.axis_min < 0.0) &&
	(w->plotter.yaxis->axis.axis_max > 0.0))
        floatx = True;
    else
        floatx = False;
    
    if ((w->plotter.floatingY) && (!w->plotter.framedAxes) &&
        (w->plotter.xaxis->axis.axis_min < 0.0) &&
	(w->plotter.xaxis->axis.axis_max))
        floaty = True;
    else
        floaty = False;

    xaxiswidth = yaxiswidth = y2axiswidth = 0;
    
    if (NTHCHILDISDISPLAYED(w, CHILD_XAXIS))
      xaxiswidth = AtAxisWidthPS(w->plotter.xaxis);
    if (NTHCHILDISDISPLAYED(w, CHILD_YAXIS))
      yaxiswidth = AtAxisWidthPS(w->plotter.yaxis);
    if (NTHCHILDISDISPLAYED(w, CHILD_Y2AXIS))
      y2axiswidth = AtAxisWidthPS(w->plotter.y2axis);

    if (!floaty) x1 += yaxiswidth;
    if (!floatx) y1 += xaxiswidth;
    x2 -= y2axiswidth;
    if (w->plotter.framedAxes) {
      int ydisp = NTHCHILDISDISPLAYED(w, CHILD_YAXIS);
      int y2disp = NTHCHILDISDISPLAYED(w, CHILD_Y2AXIS);
      
      if (ydisp && !y2disp)
	x2 -= AtAxisWidth(w->plotter.yframeAxis);
      if (y2disp && !ydisp)
	x1 += AtAxisWidth(w->plotter.y2frameAxis);
      y1 += AtAxisWidth(w->plotter.xframeAxis);
    }

    width = x2 - x1;
    height = y2 - y1;

    if (w->plotter.titleText != NULL)  {
      titleX = x1 + (width - AtTextPSWidth(w->plotter.titleText))/2;
      AtTextPSDraw(f, w->plotter.titleText, titleX, titleY);
    }

    if (w->plotter.showLegend)
	drawlegend(f, w, legendX, yll, legendX + w->plotter.legendWidth, yur);

    if(w->plotter.forceAspect){
      double xmin = w->plotter.xaxis->axis.axis_min;
      double xmax = w->plotter.xaxis->axis.axis_max;
      double ymin = w->plotter.yaxis->axis.axis_min;
      double ymax = w->plotter.yaxis->axis.axis_max;
      int extraw,extrah;
      if((xmax-xmin)/(ymax-ymin)>(double)width/height){
	double xr = (xmax-xmin)/width;
	int new_height = (ymax-ymin)/xr;
	extrah = height - new_height;
	y1 += extrah/2;
	y2 -= extrah/2;
      }
      else {
	double yr = (ymax-ymin)/height;
	int new_width = (xmax-xmin)/yr;
	extraw = width - new_width;
	x1 += extraw/2;
	x2 -= extraw/2;
      }
    }

    /* set up scales */
    xscale = AtScaleCreate(w->plotter.xaxis->axis.axis_min,
			   w->plotter.xaxis->axis.axis_max,
			   x1, x2,
			   w->plotter.xaxis->axis.transform);
    yscale = AtScaleCreate(w->plotter.yaxis->axis.axis_min,
			   w->plotter.yaxis->axis.axis_max,
			   y1, y2,
			   w->plotter.yaxis->axis.transform);
    y2scale = AtScaleCreate(w->plotter.y2axis->axis.axis_min,
			   w->plotter.y2axis->axis.axis_max,
			   y1, y2,
			   w->plotter.y2axis->axis.transform);

    /* draw the axes */
    if (NTHCHILDISDISPLAYED(w, CHILD_XAXIS)) {
      if (floatx) {
	originy = AtScaleUserToPixel(yscale, 0.0);
	AtAxisDrawPS(f, w->plotter.xaxis, x1, originy, x2, originy, y1, y2);
      }
      else
	AtAxisDrawPS(f, w->plotter.xaxis, x1, y1, x2, y1, y1, y2);
    }
    
    if (NTHCHILDISDISPLAYED(w, CHILD_YAXIS)) {
      if (floaty) {
	originx = AtScaleUserToPixel(xscale, 0.0);
	AtAxisDrawPS(f, w->plotter.yaxis, originx, y1, originx, y2, x1, x2);
      }
      else 
	AtAxisDrawPS(f, w->plotter.yaxis, x1, y1, x1, y2, x1, x2);
    }
    
    if (NTHCHILDISDISPLAYED(w, CHILD_Y2AXIS))
	AtAxisDrawPS(f, w->plotter.y2axis, x2, y1, x2, y2, x1, x2);

    if (w->plotter.framedAxes) {
	AtAxisDrawPS(f, w->plotter.xframeAxis, x1, y2, x2, y2, 0, 0);
	if (!NTHCHILDISDISPLAYED(w, CHILD_Y2AXIS))
	  AtAxisDrawPS(f, w->plotter.yframeAxis, x2, y1, x2, y2, 0, 0);
	if (!NTHCHILDISDISPLAYED(w, CHILD_YAXIS))
	  AtAxisDrawPS(f, w->plotter.y2frameAxis, x1, y1, x1, y2, 0, 0);
    }

    /* set up clipping */
    /* since this is right before a grestore, we don't need to gsave here. */
    fprintf(f, "%d %d M %d %d L %d %d L %d %d L clip newpath\n",
	    x1, y1, x1, y2, x2,y2, x2, y1);

    /* draw each of the plots */
    if (w->plotter.rankChildren) {
      Rank *tmp = w->plotter.ordered_children;
      while (tmp) {
	if (ISDISPLAYED(tmp->child))
	  if (CHILDCONSTRAINTS(tmp->child)->plotter.useY2Axis)
	    DRAWPSCHILD(tmp->child)(f, (AtPlotWidget)tmp->child, 
				    xscale, y2scale);
	  else
	    DRAWPSCHILD(tmp->child)(f, (AtPlotWidget)tmp->child, 
				    xscale, yscale);
	tmp = tmp->next;
      }
    } else {
      for(i=FIRST_PUBLIC_CHILD; i<NUMCHILDREN(w); i++) {
	if (NTHCHILDISDISPLAYED(w, i))
	  if (CONSTRAINT(w,i)->plotter.useY2Axis)
	    DRAWPS(w,i)(f, (AtPlotWidget)CHILD(w,i), xscale, y2scale);
	  else
	    DRAWPS(w,i)(f, (AtPlotWidget)CHILD(w,i), xscale, yscale);
      }
    }
    
    /* finish up */
    fprintf(f, "grestore\n%%%%EndObject\n");
}

static char prolog[] =
"/F {findfont exch scalefont setfont} bind def\n\
/S {moveto show} bind def\n\
/L {lineto} bind def\n\
/M {moveto} bind def\n\
/RM { rmoveto } bind def\n\
/RL { rlineto } bind def\n\
/CP { closepath } bind def\n\
/ST { stroke } bind def\n\
/CIR { 4 0 360 arc ST} bind def\n\
/SQR { M 4 4 RM -8 0 RL 0 -8 RL 8 0 RL CP ST } bind def\n\
/TRI { M 0 3.46 RM 4 -8 RL -8 0 RL CP ST } bind def\n\
/CRO { M 0 4 RM 0 -8 RL 4 4 RM -8 0 RL ST } bind def\n\
/STA { M 0 4 RM 0 -8 RL 4 4 RM -8 0 RL\n\
       1.17 2.83 RM 5.66 -5.66 RL 0 5.66 RM -5.66 -5.66 RL ST} bind def\n\
/DIA {M 0 5.66 RM 5.66 -5.66 RL -5.66 -5.66 RL -5.66 5.66 RL CP ST} bind def\n\
/DOT { 1 0 360 arc fill} bind def\n";
    
#include <sys/types.h>
#ifndef VMS
#include <pwd.h>
#endif

void AtPlotterGeneratePostscript(char *filename,AtPlotterWidget w, char *title,
				 int x1, int y1, int x2, int y2,
				 Boolean landscape)
{
    FILE *f;
    struct timeval tv;
    char *asctime();
#ifdef VMS
    char *user_name;
#endif

    f = fopen(filename, "w+");
    if (f == NULL) {
	perror("fopen");
	return;
    }

#ifdef VMS
#include <time.h>
    time((time_t *) &tv.tv_sec);
#else
    if (gettimeofday(&tv,(struct timezone *)0)) {
	perror("gettimeofday");
    }
#endif

    /* do header info */
    fprintf(f,"%%!PS-Adobe-2.0\n");
    fprintf(f,"%%%%Title: %s\n", title);
    fprintf(f,"%%%%Creator: the Athena Tools plotter widget\n");
    fprintf(f,"%%%%CreationDate: %s",asctime(localtime((time_t *)&tv.tv_sec)));
#ifndef VMS
    fprintf(f,"%%%%For: %s\n", getpwuid(getuid())->pw_name);
#else
    fprintf(f, "%%%%For: %s\n", cuserid(user_name));
#endif
    fprintf(f,"%%%%BoundingBox: %d %d %d %d\n", x1, y1, x2, y2);
    fprintf(f,"%%%%Pages: 1\n");
    fprintf(f,"%%%%EndComments\n");
    
    /* do prolog */
    fprintf(f, prolog);
    fprintf(f, "%%%%EndProlog\n");

    if (landscape) {

	fprintf(f, "90 rotate\n");
	fprintf(f, "0 -612 translate\n");
    }
    /* do the body of the postscript */
    AtPlotterDrawPS(f, w, x1, y1, x2, y2);

    /* finish up */
    fprintf(f, "showpage\n");

    fclose(f);
}

/*
 * Local Variables:
 * eval: (set-c-style 'GNU)
 * End:
 */
