/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/text/RCS/Text.h,v 3.1 91/01/03 17:54:51 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtText_h
#define _AtText_h

#include <stdio.h>

#ifdef _AtDevelopment_
#include "FontFamily.h"
#else
#include <At/FontFamily.h>
#endif
    
typedef struct _AtTextToken {
    struct _AtTextToken *next;
    int type;
    int code;
    char *str;

    /* formatting information */
    XFontStruct *font;          /* what font to draw it in */
    short width;       /* bounding box info */
    short ascent;
    short descent;
    short baseline;
} AtTextToken;

typedef struct _AtTextPSFormat {
    struct _AtTextPSFormat *next;
    char *font;
    short size;
    short width;
    short ascent;
    short descent;
    short baseline;
} AtTextPSFormat;

typedef struct _AtText {
    AtFontFamily *family;
    int size;
    char *str;
    AtTextToken *parsed;
    short width;       /* bounding box info */
    short ascent;
    short descent;
    Boolean rotated;
    XImage *rotated_image;
    unsigned int rotated_depth;
    AtTextPSFormat *psformat;
} AtText;

#define AtTextJUSTIFY_LEFT      0
#define AtTextJUSTIFY_TOP       0    
#define AtTextJUSTIFY_CENTER    1
#define AtTextJUSTIFY_RIGHT     2
#define AtTextJUSTIFY_BOTTOM    2

extern AtText* AtTextCreate(char *, AtFontFamily *, int);
extern void AtTextDestroy(AtText *);
extern void AtTextFormat(AtText *, AtFontFamily *, int);
extern void AtTextReformat(AtText *, AtFontFamily *, int);
extern void AtTextRotate(AtText *);
extern void AtTextDraw(Display *, Drawable, GC, AtText *, int, int);
extern void AtTextDrawImage(Display *, Drawable, GC, AtText *, int, int);
extern void AtTextDrawJustified(Display *, Drawable, GC, AtText *, int, int,
				int, int, int, int);

/* extern void AtTextOutputPostscript(AtText *, FILE *); */

#define AtTextWidth(t) ((t)->width)
#define AtTextAscent(t) ((t)->ascent)
#define AtTextDescent(t) ((t)->descent)
#define AtTextHeight(t) ((t)->ascent + (t)->descent)

extern int AtTextPSWidth(AtText *);
extern int AtTextPSAscent(AtText *);
extern int AtTextPSDescent(AtText *);
extern void AtTextPSDraw(FILE *, AtText *, int, int);
extern void AtTextWritePostscriptProlog(FILE *);
#endif
