
/*
 * CmLabel.c - CmLabel widget
 *
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <Xm/XmP.h>
#include <Xm/Xm.h>

#include <CmLabelP.h>

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

#define offset(field) XtOffset(CmLabelWidget, field)
static XtResource resources[] = {
    {XtNlabel,  XtCLabel, XtRString, sizeof(String),
	offset(cmlabel.label), XtRImmediate, NULL},
    {XtNsmallLabel, XtCLAS, XtRString, sizeof(String),
        offset(cmlabel.small_label), XtRImmediate, (caddr_t) NULL},
    {XtNresize, XtCResize, XtRBoolean, sizeof(Boolean),
	offset(cmlabel.resize), XtRImmediate, (caddr_t)True},
    {XtNfontFamily, XtCLAS, XtRCmFontFamily, sizeof(int),
        offset(cmlabel.font_family), XtRImmediate, (caddr_t) TIMES},
    {XtNfontSize, XtCLAS, XtRCmFontSize, sizeof(int),
        offset(cmlabel.font_size), XtRImmediate, (caddr_t) MEDIUM},
    {XtNxFlag, XtCLAS, XtRCmHorizJustify, sizeof(int),
	offset(cmlabel.xflag), XtRImmediate, (caddr_t) H_CENTER},
    {XtNyFlag, XtCLAS, XtRCmVertJustify, sizeof(int),
	offset(cmlabel.yflag), XtRImmediate, (caddr_t) V_CENTER},
    {XtNtextMode, XtCLAS, XtRCmTextMode, sizeof(int),
        offset(cmlabel.text_mode), XtRImmediate, (caddr_t) VERBATIM},
    {XtNtextSmall, XtCLAS, XtRCmTextSmall, sizeof(int),
        offset(cmlabel.text_small), XtRImmediate, (caddr_t) CLIP_LEFT_BOT}
};

static void Initialize();
static void Resize();
static void Redisplay();
static void ClassInitialize();
static void Destroy();
static Boolean SetValues();

CmLabelClassRec cmLabelClassRec = {
  {
/* core_class fields */	
#define superclass		(&xmPrimitiveClassRec)
    /* superclass	  	*/	(WidgetClass) superclass,
    /* class_name	  	*/	"CmLabel",
    /* widget_size	  	*/	sizeof(CmLabelRec),
    /* class_initialize   	*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	XtInheritRealize,
    /* actions		  	*/	NULL,
    /* num_actions	  	*/	0,
    /* resources	  	*/	resources,
    /* num_resources	  	*/	XtNumber(resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	TRUE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	TRUE,
    /* destroy		  	*/	Destroy,
    /* resize		  	*/	Resize,
    /* expose		  	*/	Redisplay,
    /* set_values	  	*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	NULL,
    /* query_geometry		*/	NULL,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  }
};
WidgetClass cmLabelWidgetClass = (WidgetClass)&cmLabelClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void ClassInitialize()
{
  LTxRegisterCmFontFamilyConverter();
  LTxRegisterCmFontSizeConverter();
  LTxRegisterCmHorizJustifyConverter();
  LTxRegisterCmVertJustifyConverter();
  LTxRegisterCmTextModeConverter();
  LTxRegisterCmTextSmallConverter();
} /* ClassInitialize */



/* ARGSUSED */
static void Initialize(request, new)
 Widget request, new;
{
  CmLabelWidget lw = (CmLabelWidget) new;

  LTxLoadFont(XtDisplay(new));
  lw->cmlabel.text_info = LTxCreateInfo();
 
  if (!lw->cmlabel.label)
    lw->cmlabel.label = XtNewString(lw->core.name);
  else
    lw->cmlabel.label = XtNewString(lw->cmlabel.label);

  if (!lw->cmlabel.small_label)
    lw->cmlabel.small_label = XtNewString("");
  else
    lw->cmlabel.small_label = XtNewString(lw->cmlabel.small_label);

 (*XtClass(new)->core_class.resize) ((Widget)lw);
} /* Initialize */

/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void Redisplay(w, event, region)
    Widget w;
    XEvent *event;
    Region region;
{
   CmLabelWidget lw = (CmLabelWidget) w;

   if (!lw->core.visible) return;

   LTxSetX(lw->cmlabel.text_info, 0.0);
   LTxSetY(lw->cmlabel.text_info, 0.0);
   LTxSetWidth(lw->cmlabel.text_info, 1.0);
   LTxSetHeight(lw->cmlabel.text_info, 1.0);
   LTxSetBackgd(lw->cmlabel.text_info, lw->core.background_pixel);
   LTxSetForegd(lw->cmlabel.text_info, lw->primitive.foreground);
   LTxSetText(lw->cmlabel.text_info, lw->cmlabel.label);
   LTxSetFont(lw->cmlabel.text_info, lw->cmlabel.font_family);
   LTxSetSize(lw->cmlabel.text_info, lw->cmlabel.font_size);
   LTxSetXflag(lw->cmlabel.text_info, lw->cmlabel.xflag);
   LTxSetYflag(lw->cmlabel.text_info, lw->cmlabel.yflag);
   LTxSetMode(lw->cmlabel.text_info, lw->cmlabel.text_mode);
   LTxSetSmall(lw->cmlabel.text_info, lw->cmlabel.text_small);
   LTxSetShort(lw->cmlabel.text_info, lw->cmlabel.small_label);

   LTxWantStipple(lw->cmlabel.text_info, !XtIsSensitive(lw));
   LTxSetChangeTextFlag(lw->cmlabel.text_info, TRUE);
   LTxDrawText(XtWindow(w), lw->core.width, 
	       lw->core.height, lw->cmlabel.text_info);
 }


static void Resize(w)
    Widget w;
{
if (XtIsRealized(w)) {
  XClearWindow(XtDisplay(w), XtWindow(w));
  Redisplay(w, NULL, NULL);
}  
}

static void Destroy(w)
    Widget w;
{
  CmLabelWidget lw = (CmLabelWidget) w;

  XtFree(lw->cmlabel.label);
  XtFree(lw->cmlabel.small_label);
  XtFree(lw->cmlabel.text_info);
}

static Boolean SetValues(current, request, new, args, num_args)
    Widget current, request, new;
    ArgList args;
    Cardinal *num_args;
{
  CmLabelWidget curlw = (CmLabelWidget) current;
  CmLabelWidget reqlw = (CmLabelWidget) request;
  CmLabelWidget newlw = (CmLabelWidget) new;


  if (curlw->cmlabel.label != newlw->cmlabel.label) {
    XtFree( (char *)curlw->cmlabel.label );
    if (!newlw->cmlabel.label)
      newlw->cmlabel.label = XtNewString(newlw->core.name);
    else
      newlw->cmlabel.label = XtNewString(newlw->cmlabel.label );
  }

  if (curlw->cmlabel.label != newlw->cmlabel.small_label) {
    XtFree( (char *)curlw->cmlabel.small_label );
    if (!newlw->cmlabel.small_label)
      newlw->cmlabel.small_label = XtNewString("");
    else
      newlw->cmlabel.small_label = XtNewString(newlw->cmlabel.small_label );
  }
  return TRUE;
}

