/******************************************************************************

   Copyright 1991 McGill University

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose without fee is hereby granted without fee,
   provided that the above copyright notice appear in all copies and that
   both that copyright notice and this permission notice appear in
   supporting documentation, and that the name of McGill not be used in
   advertising or publicity pertaining to distribution of the software
   without specific, written prior permission.  McGill makes no
   representations about the suitability of this software for any purpose.
   It is provided "as is" without express or implied warranty.

   MCGILL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
   BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
   OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
   CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   Author:
     Lee Iverson <leei@mcrcim.mcgill.edu>,
     McGill Research Centre for Intelligent Machines (McRCIM)

******************************************************************************/

static char RCSid[] = "$Id: SimpleImage.c,v 1.2 91/04/28 18:39:59 joe Exp Locker: joe $";

#include <X11/copyright.h>

/* $XConsortium: SimpleImage.c,v 1.2 88/10/25 17:40:25 swick Exp $ */
/* Copyright	Massachusetts Institute of Technology	1987, 1988 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include <GenericImageP.h>
#include <SimpleImageP.h>

#include <readImage.h>

#include <math.h>

extern double rint(double);

#define MIN_PIXELS (4)
#define MIN_SIZE   (10)

static const float one = 1.0;

static XtResource resources[] = {
#define offset(field) XtOffset(SimpleImageWidget, simple_image.field)
    /* {name, class, type, size, offset, default_type, default_addr}, */
    { XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	  offset(foreground_pixel), XtRString, "XtDefaultForeground" },
    { XtNmagX, XtCMag, XtRFloat, sizeof(float),
	  offset(mag_x), XtRFloat, (float*) &one },
    { XtNmagY, XtCMag, XtRFloat, sizeof(float),
	  offset(mag_y), XtRFloat, (float*) &one },
    { XtNimage, XtCImage, XtRImage, sizeof(GenericImage),
	  offset(image), XtRImmediate, (XtPointer) NULL },
    { XtNimageFile, XtCString, XtRString, sizeof (String),
	  offset(image_file), XtRString, (XtPointer) NULL}
#undef offset
};

static void Initialize( SimpleImageWidget request, SimpleImageWidget new );
static XtGeometryResult
  QueryGeometry( SimpleImageWidget, XtWidgetGeometry*, XtWidgetGeometry*);
static Boolean
  SetValues( SimpleImageWidget w, SimpleImageWidget request, SimpleImageWidget new );

static void Redisplay( SimpleImageWidget w, XEvent *ev, Region region );
static void Resize( SimpleImageWidget );

SimpleImageWidgetClassRec simpleImageWidgetClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"SimpleImage",
    /* widget_size		*/	sizeof(SimpleImageWidgetRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	QueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* simpleImage fields */
    /* empty			*/	0
  }
};

WidgetClass simpleImageWidgetClass = (WidgetClass)&simpleImageWidgetClassRec;

static void
Initialize( SimpleImageWidget request, SimpleImageWidget new )
{
    XGCValues values;
    XtGCMask valueMask;
    SimpleImageWidgetPart *newim = &new->simple_image;

    if ( newim->image_file) {
        newim->image_file = XtNewString(newim->image_file);
        newim->image = readImage(newim->image_file);
    }
       
    if ( newim->image ) {
	newim->width  = newim->image->generic.width;
	newim->height = newim->image->generic.height;

	if ( !new->core.width )
	  new->core.width  = rint(newim->mag_x * newim->width);
	if ( !new->core.height )
	  new->core.height = rint(newim->mag_y * newim->height);
    }

    /* Size defaults. */
    if ( !new->core.width  ) new->core.width = 200;
    if ( !new->core.height ) new->core.height = 200;

    valueMask = GCForeground | GCBackground;
    values.background = new->core.background_pixel;
    values.foreground = newim->foreground_pixel;
    newim->annotateGC = XtGetGC( new, valueMask, &values );
}

static XtGeometryResult
QueryGeometry( SimpleImageWidget w, 
	      XtWidgetGeometry *request, XtWidgetGeometry *ret)
{
    XtGeometryResult result = XtGeometryYes;
    Dimension ideal_width, ideal_height;

    if ( w->simple_image.image ) {
	ideal_width  = rint(w->simple_image.mag_x * w->simple_image.width);
	ideal_height = rint(w->simple_image.mag_y * w->simple_image.height);

	if ( request->request_mode & CWWidth ) {
	    if ( request->width != ideal_width ) {
		ret->width = ideal_width;
		ret->request_mode |= CWWidth;
		result = XtGeometryAlmost;
	    }
	}
	if ( request->request_mode & CWHeight ) {
	    if ( request->height != ideal_height ) {
		ret->height = ideal_height;
		ret->request_mode |= CWHeight;
		result = XtGeometryAlmost;
	    }
	}
    }

    return result;
}

static void
ImageDisplay( SimpleImageWidget w, Region region, XRectangle *range )
{
    SimpleImageWidgetPart *ipart = &w->simple_image;

#define IM_X(i)  rint(mag_x*(i))
#define IM_Y(j)  rint(mag_y*(j))
#define IM_CX(i) rint(mag_x*((i)+0.5))
#define IM_CY(j) rint(mag_y*((j)+0.5))

    if ( ipart->image ) {
	DisplayParams dparams;
	dparams.w = (Widget) w;
	dparams.display = XtDisplay(w);
	dparams.screen = XtScreen(w);
	dparams.visual = DefaultVisualOfScreen(dparams.screen);
	dparams.win = XtWindow(w);
	dparams.region = region;
	dparams.mag_x = ipart->mag_x;
	dparams.mag_y = ipart->mag_y;
	dparams.range = range;
	ImAllocColors( ipart->image, &dparams );
	ImDisplay( ipart->image, &dparams );
    }
#undef IM_X
#undef IM_Y
#undef IM_CX
#undef IM_CY
}

static void
Redisplay( SimpleImageWidget w, XEvent *ev, Region region )
{
    if ( w->core.visible && w->simple_image.image ) {
	Display *dpy = XtDisplay((Widget)w);
	Window win = XtWindow((Widget)w);
	Cursor watch = XCreateFontCursor(dpy, XC_watch);
	XRectangle clip_rect;
	Dimension width = w->simple_image.width;
	Dimension height = w->simple_image.height;

	XDefineCursor(dpy,win,watch);
	XClipBox( region, &clip_rect );

	clip_rect.x = floor(clip_rect.x/w->simple_image.mag_x);
	clip_rect.y = floor(clip_rect.y/w->simple_image.mag_y);
	clip_rect.width  = ceil( clip_rect.width /w->simple_image.mag_x) + 1;
	if ( clip_rect.x + clip_rect.width > width ) {
	    if ( width <= clip_rect.x ) return;
	    clip_rect.width = width - clip_rect.x;
	}
	clip_rect.height = ceil( clip_rect.height/w->simple_image.mag_y) + 1;
	if ( clip_rect.y + clip_rect.height > height ) {
	    if ( height <= clip_rect.y ) return;
	    clip_rect.height = height - clip_rect.y;
	}

	ImageDisplay( w, region, &clip_rect );

	XUndefineCursor(dpy,win);
	XFreeCursor(dpy, watch);
    }
}

static Boolean
SetValues( SimpleImageWidget w, SimpleImageWidget request, SimpleImageWidget new )
{
    SimpleImageWidgetPart 
      *oldim = &w->simple_image, 
      *reqim = &request->simple_image, 
      *newim = &new->simple_image;
    Boolean resize = FALSE;

    if ( w->core.background_pixel != new->core.background_pixel ||
	 oldim->foreground_pixel != newim->foreground_pixel) {
	XGCValues values;
	XtGCMask valueMask;
	values.background = w->core.background_pixel;
	values.foreground = newim->foreground_pixel;
	newim->annotateGC = XtGetGC( new, valueMask, &values );
    }
    if ( oldim->mag_x != reqim->mag_x ) {
	newim->mag_x = reqim->mag_x; /**/
	resize = TRUE;
    }
    if ( oldim->mag_y != reqim->mag_y ) {
	newim->mag_y = reqim->mag_y; /**/
	resize = TRUE;
    }
    if ( oldim->image_file != reqim->image_file && 
	reqim->image_file != NULL) {
	newim->image = readImage(reqim->image_file);
	if ( newim->image) {
	  if (oldim->image_file)
	   ImDestroyImage(oldim->image);
	  newim->image_file = XtNewString(oldim->image_file);
	  newim->width  = ImWidth(newim->image);
	  newim->height = ImHeight(newim->image);
	  resize = TRUE;
	}
      }

    if ( oldim->image != reqim->image ) {
        if (oldim->image_file) {
	  ImDestroyImage(oldim->image);
	  XtFree(oldim->image_file);
	  newim->image_file = NULL;
	} else
	  if ( oldim->image ) ImFreeColors( oldim->image );
	newim->image = reqim->image;
	newim->width  = ImWidth(newim->image);
	newim->height = ImHeight(newim->image);
	resize = TRUE;
      }

    if ( resize && newim->image ) {
	new->core.width  = (Dimension) rint(newim->mag_x * newim->width);
	new->core.height = (Dimension) rint(newim->mag_y * newim->height);
    }

    return resize;
}


static void
Resize( SimpleImageWidget w)
{
  float mag_x = w->simple_image.mag_x;
  float mag_y = w->simple_image.mag_y;
  float mag_ratio = mag_x/mag_y;
  Dimension width, height;
  Dimension p_width  = w->core.width;
  Dimension p_height = w->core.height;
  
  if ( w->simple_image.image ) {
    width = ImWidth(w->simple_image.image);
    height = ImHeight(w->simple_image.image);
    if ( !width || !height ) return;
    mag_x = p_width/(float)width;
    mag_y = p_height/(float)height;
    
    if ( mag_x > mag_y*mag_ratio ) mag_x = mag_y*mag_ratio;
    if ( mag_y > mag_x/mag_ratio ) mag_y = mag_x/mag_ratio;
    
    w->simple_image.mag_x = mag_x;
    w->simple_image.mag_y = mag_y;
    if (XtIsRealized(w))
      XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, True);
  }
}

