/******************************************************************************

   Copyright 1991 McGill University

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose without fee is hereby granted without fee,
   provided that the above copyright notice appear in all copies and that
   both that copyright notice and this permission notice appear in
   supporting documentation, and that the name of McGill not be used in
   advertising or publicity pertaining to distribution of the software
   without specific, written prior permission.  McGill makes no
   representations about the suitability of this software for any purpose.
   It is provided "as is" without express or implied warranty.

   MCGILL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
   BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
   OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
   CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   Author:
     Lee Iverson <leei@mcrcim.mcgill.edu>,
     McGill Research Centre for Intelligent Machines (McRCIM)

   $Id: SimpleImage.h,v 1.2 91/04/28 18:40:31 joe Exp Locker: joe $

******************************************************************************/

/* Derived from */
/* $XConsortium: Template.h,v 1.4 89/07/21 01:41:49 kit Exp $ */
/* Copyright	Massachusetts Institute of Technology	1987, 1988 */

#ifndef _SimpleImage_h
#define _SimpleImage_h

/****************************************************************
 *
 * SimpleImage widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 font		     Font		XFontStruct	XtDefaultFont
 foreground	     Foreground		Pixel		XtDefaultForeground
 grid		     Grid		Boolean		False
 image		     Image		XtRImage	NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 verbose	     Verbose		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0
*/

/* define any special resource names here that are not in <X11/StringDefs.h> */
#define XtNgrid "grid"
#define XtNimage "image"
#define XtNmagX "magX"
#define XtNmagY "magY"
#define XtNverbose "verbose"
#define XtNimageFile "imageFile"

#define XtCGrid "Grid"
#define XtCMag "Magnification"
#define XtCImage "Image"
#define XtCVerbose "Verbose"

#define XtRImage "Image"

/* declare specific ImageWidget class and instance datatypes */

typedef struct _SimpleImageWidgetClassRec*	SimpleImageWidgetClass;
typedef struct _SimpleImageWidgetRec*		SimpleImageWidget;

/* declare the class constant */

extern WidgetClass simpleImageWidgetClass;

#endif /* _SimpleImage_h */
