/**********************************************************************
 * File: ltxo.h 
 * Public INCLUDE file holding macros needed for using LTxo.  All
 * other files should include this file to use LTxo routines.
 **********************************************************************/

#ifndef LTXO_H
#define LTXO_H 1

#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* Resource classes for X Toolkit */
/* Despite the inclusion of this routines, the text tool utilities should be
 * usable under ordinary X provided the following resource converter utilities
 * are not called.
 */

#define XtRCmFontFamily "CmFontFamily"
#define XtRCmFontSize "CmFontSize"
#define XtRCmHorizJustify "CmHorizJustify"
#define XtRCmVertJustify "CmVertJustify"
#define XtRCmTextMode "CmTextMode"
#define XtRCmTextSmall "CmTextSmall"

extern void LTxRegisterCmFontFamilyConverter();
extern void LTxRegisterCmFontSizeConverter();
extern void LTxRegisterCmHorizJustifyConverter();
extern void LTxRegisterCmVertJustifyConverter();
extern void LTxRegisterCmTextModeConverter();
extern void LTxRegisterCmTextSmallConverter();

/* Define fonts */

#define HELVET             0
#define HELVET_BOLD        1
#define HELVET_ITALICS     2
#define TIMES              3
#define TIMES_BOLD         4
#define TIMES_ITALICS      5
#define GREEK              6
#define FIXED              7
#define SYMBOL             8
#define FANCY              9

#define SMALLEST    0
#define SMALL       1
#define MEDSMALL    2
#define MEDIUM      3
#define MEDBIG      4
#define BIG         5
#define BIGGEST     6	     

#define H_LEFT    1
#define H_CENTER  2
#define H_RIGHT   4

#define V_CENTER  1
#define V_TOP     2
#define V_BOTTOM  4

#define VERBATIM   1
#define FILL       2
#define JUSTIFY    4

#define CLIP_RIGHT_BOT   1
#define CLIP_LEFT_BOT    2
#define CLIP_RIGHT_TOP   3
#define CLIP_LEFT_TOP    4
#define NO_SHOW          5
#define SHOW_SHORT       6

#define OFF       0
#define ON        1

/* LTxBox is the structure that holds information for bounding box of 
   the text output. */

typedef struct _LTxBox{
   float           x;		/* x,y of bounding box */
   float           y;
   float           height;	/* width of bounding box */
   float	   width;	/* height of bounding box */
   unsigned        border;	/* border width of bounding box */
   int             x_offset;    /* number of pixels to skip in X axis */
   int             y_offset;    /* number of pixels to skip in Y axis */
} LTxBox;

/* LTxInfo is the structure that holds all information necessary to 
   draw text with LTxDrawText. */

typedef struct _LTxInfo{
   LTxBox          box;	        /* bounding box */
   char		   *str;	/* text to be displayed */
   unsigned        font;	/* font for text */
   unsigned        size;	/* size for text */
   int   	   xflag;	/* horizontal alignment */
   int  	   yflag;	/* vertical alignment */
   int             mode;	/* verbatim, fill, or justify */
   Bool            resize;	/* allows LTxo to resize the font */
   int             too_small;	/* what to do when bounding box is too */
				/* small  */
   char            *short_str;	/* alternate text */
   unsigned long   foregd;	/* preferred background color*/
   unsigned long   backgd;	/* preferred foreground color */
   Bool            want_stipple; /* user whats stipple tiles in GC */
   Bool            change_text_flag; /* tell if text has been changed */
   char            *font_example_string; /* Tells the tex tool how to pick the font */
} LTxInfo;			


/* Public macros to get the entries of the LTtInfo structure.  Each 
   widget which wants to get an entry to the structure should use the
   macros. */

#define  LTxGetX(info)           ((info)->box.x)
#define  LTxGetY(info)           ((info)->box.y)
#define  LTxGetWidth(info)       ((info)->box.width)
#define  LTxGetHeight(info)      ((info)->box.height)
#define  LTxGetBorder(info)      ((info)->box.border)
#define  LTxGetXOffset(info)     ((info)->box.x_offset)
#define  LTxGetYOffset(info)     ((info)->box.y_offset)
#define  LTxGetText(info)        ((info)->str)
#define  LTxGetFont(info)        ((info)->font)
#define  LTxGetSize(info)        ((info)->size)
#define  LTxGetXflag(info)       ((info)->xflag)
#define  LTxGetYflag(info)       ((info)->yflag)
#define  LTxGetMode(info)        ((info)->mode)
#define  LTxGetResize(info)      ((info)->resize)
#define  LTxGetSmall(info)       ((info)->too_small)
#define  LTxGetShort(info)       ((info)->short_str)
#define  LTxGetBackgd(info)      ((info)->backgd)
#define  LTxGetForegd(info)      ((info)->foregd)
#define  LTxGetWantStipple(info)    ((info)->want_stipple)
#define  LTxGetChangeTextFlag(info)    ((info)->change_text_flag)
#define  LTxGetFontExampleString(info) ((info)->font_example_string)

extern void  LTxSetX();
extern void  LTxSetY();
extern void  LTxSetWidth();
extern void  LTxSetHeight();
extern void  LTxSetBorder();
extern void  LTxSetText();  
extern void  LTxSetFont();
extern void  LTxSetSize();
extern void  LTxSetXflag();
extern void  LTxSetYflag();
extern void  LTxSetMode();
extern void  LTxSetResize();
extern void  LTxSetSmall();
extern void  LTxSetShort(); 
extern void  LTxSetBackgd();
extern void  LTxSetForegd();
extern void  LTxSetWantStipple();
extern void  LTxSetChangeTextFlag();
extern void  LTxSetXoffset();
extern void  LTxSetYoffset();
extern void  LTxSetFontExampleString();

extern void LTxLoadFont();
extern LTxInfo *LTxCreateInfo();
extern void LTxFreeFont();
extern void LTxDrawText();
extern void LTxSetBoxWidth();
extern void LTxSetBoxHeight();
extern void LTxSelectSize();
extern LTxGetFontIdSizeId();
extern void LTxWantStipple();

#endif LTXO_H

/* DO NOT WRITE BELOW THIS LINE */
