#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <strings.h>
#include <ltxo.h>

void LTxCvtStringToCmFontFamily (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);


  if (!strcasecmp ((char*)fromVal->addr, "helvetica"))
    result =  HELVET;
  else if (!strcasecmp ((char*)fromVal->addr, "times"))
    result =  TIMES;
  else if (!strcasecmp ((char*)fromVal->addr, "greek"))
    result =  GREEK;
  else if (!strcasecmp ((char*)fromVal->addr, "fixed"))
    result = FIXED;
}

void LTxRegisterCmFontFamilyConverter() 
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRCmFontFamily, 
		   LTxCvtStringToCmFontFamily, NULL, 0);
    registered = True;
  }
}

void LTxCvtStringToCmFontSize (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);


  if (!strcasecmp ((char*)fromVal->addr, "smallest"))
    result =  SMALLEST;
  else if (!strcasecmp ((char*)fromVal->addr, "small"))
    result =  SMALL;
  else if (!strcasecmp ((char*)fromVal->addr, "medsmall"))
    result =  MEDSMALL;
  else if (!strcasecmp ((char*)fromVal->addr, "medium"))
    result = MEDIUM;
  else if (!strcasecmp ((char*)fromVal->addr, "medbig"))
    result =  MEDBIG;
  else if (!strcasecmp ((char*)fromVal->addr, "big"))
    result =  BIG;
}

void LTxRegisterCmFontSizeConverter() 
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRCmFontSize, 
		   LTxCvtStringToCmFontSize, NULL, 0);
    registered = True;
  }
}

void LTxCvtStringToCmHorizJustify (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);


  if (!strcasecmp ((char*)fromVal->addr, "left"))
    result =  H_LEFT;
  else if (!strcasecmp ((char*)fromVal->addr, "center"))
    result =  H_CENTER;
  else if (!strcasecmp ((char*)fromVal->addr, "right"))
    result =  H_RIGHT;
}

void LTxRegisterCmHorizJustifyConverter() 
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRCmHorizJustify, 
		   LTxCvtStringToCmHorizJustify, NULL, 0);
    registered = True;
  }
}

void LTxCvtStringToCmVertJustify (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);


  if (!strcasecmp ((char*)fromVal->addr, "center"))
    result =  V_CENTER;
  else if (!strcasecmp ((char*)fromVal->addr, "top"))
    result =  V_TOP;
  else if (!strcasecmp ((char*)fromVal->addr, "bottom"))
    result =  V_BOTTOM;
}

void LTxRegisterCmVertJustifyConverter() 
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRCmVertJustify, 
		   LTxCvtStringToCmVertJustify, NULL, 0);
    registered = True;
  }
}

void LTxCvtStringToCmTextMode (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);


  if (!strcasecmp ((char*)fromVal->addr, "verbatim"))
    result =  VERBATIM;
  else if (!strcasecmp ((char*)fromVal->addr, "fill"))
    result =  FILL;
  else if (!strcasecmp ((char*)fromVal->addr, "justify"))
    result =  JUSTIFY;
}

void LTxRegisterCmTextModeConverter() 
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRCmTextMode, 
		   LTxCvtStringToCmTextMode, NULL, 0);
    registered = True;
  }
}

void LTxCvtStringToCmTextSmall (args, nargs, fromVal, toVal)
     XrmValue *args;
     Cardinal *nargs;
     XrmValue *fromVal, *toVal;
{
  static int result;

  toVal->addr = (caddr_t) &result;
  toVal->size = (unsigned int) sizeof(int);


  if (!strcasecmp ((char*)fromVal->addr, "no_show"))
    result =  NO_SHOW;
  else if (!strcasecmp ((char*)fromVal->addr, "show_short"))
    result =  SHOW_SHORT;
  else if (!strcasecmp ((char*)fromVal->addr, "clip_left_bot"))
    result =  CLIP_LEFT_BOT;
  else if (!strcasecmp ((char*)fromVal->addr, "clip_right_bot"))
    result =  CLIP_RIGHT_BOT;
  else if (!strcasecmp ((char*)fromVal->addr, "clip_left_top"))
    result =  CLIP_LEFT_TOP;
  else if (!strcasecmp ((char*)fromVal->addr, "clip_right_bot"))
    result =  CLIP_RIGHT_BOT;
}


void LTxRegisterCmTextSmallConverter() 
{
  static Boolean registered = False;

  if (registered == False) {
    XtAddConverter(XtRString, XtRCmTextSmall, 
		   LTxCvtStringToCmTextSmall, NULL, 0);
    registered = True;
  }
}

