/********************************************************************** 
 * File: ltxo_tbl.c
 * This file holds the necessary tables mapping font and symbol
 * information for text formatting.
 **********************************************************************
 *  Changed to include new Athena fonts, ver 6.2A.  Jeff 6/9/89 *******
 **********************************************************************/

#include <X11/Xlib.h>           /* Xlib include files */
#include <X11/Xutil.h>

#include <ltxo_pri.h>		/* Private LTxo include file */

/* font_tbl is a  mapping of the fonts available to the actual font 
   files that exist in the Athena X-Window System.  Note that some 
   fontfiles used are the same.  Note comments on the initialization.
   font_map is defined in "ltxo_pri.h". This table is of course 
   expandible. */

font_map font_tbl[MAXFONT][MAXSIZE] = {
   /* [0][0] */ /* HELVET */
  {
   { "-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1", 0 },                   /*helvetica-medium10*/
   { "-adobe-helvetica-medium-r-normal--12-120-75-75-p-67-iso8859-1", 0 },                   /*helvetica-medium12*/
   { "-adobe-helvetica-medium-r-normal--14-140-75-75-p-77-iso8859-1", 0 },                   /*helvetica-medium14*/
   { "-adobe-helvetica-medium-r-normal--18-180-75-75-p-98-iso8859-1", 0 },                   /*helvetica-medium18*/
   { "-adobe-helvetica-medium-r-normal--24-240-75-75-p-130-iso8859-1", 0 },                   /*helvetica-medium24*/
   { "-adobe-helvetica-medium-r-normal--24-240-75-75-p-130-iso8859-1", 0 },                         /*vg-31 is not in new fonts -- use 24*/
   { "-bitstream-charter-medium-r-normal--33-240-100-100-p-183-iso8859-1", 0 }                         /*vg-40 is not in new fonts -- use 33*/
  },
/* [1][0] */  /* HELVET_BOLD */
  {
   { "-adobe-helvetica-bold-r-normal--10-100-75-75-p-60-iso8859-1", 0 },                         /*helvetica-bold10*/
   { "-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1", 0 },                         /*helvetica-bold12*/
   { "-adobe-helvetica-bold-r-normal--14-140-75-75-p-82-iso8859-1", 0 },                         /*helvetica-bold14*/
   { "-adobe-helvetica-bold-r-normal--18-180-75-75-p-103-iso8859-1", 0 },                         /*helvetica-bold18*/
   { "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1", 0 },                         /*helvetica-bold24*/
   { "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1", 0 },
                   /*vgb-31b is not in new fonts */
   { "-bitstream-charter-bold-r-normal--33-240-100-100-p-206-iso8859-1", 0 }	            /* no bold in vg-40 */ /*vg-40 is not in new fonts -- use 33*/
  },
/* [2][0] */ /* HELVET_ITALICS */
  {
   { "-adobe-helvetica-medium-o-normal--10-100-75-75-p-57-iso8859-1", 0 },                       /*helvetica-oblique10*/
   { "-adobe-helvetica-medium-o-normal--12-120-75-75-p-67-iso8859-1", 0 },                       /*helvetica-oblique12*/
   { "-adobe-helvetica-medium-o-normal--14-140-75-75-p-78-iso8859-1", 0 },                       /*helvetica-oblique14*/
   { "-adobe-helvetica-medium-o-normal--18-180-75-75-p-98-iso8859-1", 0 },                       /*helvetica-oblique18*/
   { "-adobe-helvetica-medium-o-normal--24-240-75-75-p-130-iso8859-1", 0 },                       /*helvetica-oblique24*/
   { "-adobe-helvetica-medium-o-normal--24-240-75-75-p-130-iso8859-1", 0 },                       /*vgi-31 is not in new fonts -- use 24*/                         /* no oblique in vg-40 */
   { "-bitstream-charter-medium-i-normal--33-240-100-100-p-179-iso8859-1", 0 }                       /*vgl-40 is not in new fonts -- use 33*/                         /* but vgl-40 will do */
  },
/* [3][0] */   /* TIMES */
  {
   { "-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1", 0 },                   /*times-roman10*/
   { "-adobe-times-medium-r-normal--12-120-75-75-p-64-iso8859-1", 0 },                   /*times-roman12*/
   { "-adobe-times-medium-r-normal--14-140-75-75-p-74-iso8859-1", 0 },                   /*times-roman14*/
   { "-adobe-times-medium-r-normal--18-180-75-75-p-94-iso8859-1", 0 },                   /*times-roman18*/
   { "-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1", 0 },                   /*times-roman24*/
   { "-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1", 0 },                   /*vr-31 is not in new fonts -- use 24*/
   { "-bitstream-charter-medium-r-normal--33-240-100-100-p-183-iso8859-1", 0 }                   /*vr-40 is not in new fonts -- use 33*/
  },
/* [4][0] */ /* TIMES_BOLD */
  {
   { "-adobe-times-bold-r-normal--10-100-75-75-p-57-iso8859-1", 0 },                   /*times-bold10*/
   { "-adobe-times-bold-r-normal--12-120-75-75-p-67-iso8859-1", 0 },                   /*times-bold12*/
   { "-adobe-times-bold-r-normal--14-140-75-75-p-77-iso8859-1", 0 },                   /*times-bold14*/
   { "-adobe-times-bold-r-normal--18-180-75-75-p-99-iso8859-1", 0 },                   /*times-bold18*/
   { "-adobe-times-bold-r-normal--24-240-75-75-p-132-iso8859-1", 0 },                   /*times-bold24*/
   { "-adobe-times-bold-r-normal--24-240-75-75-p-132-iso8859-1", 0 },                   /*vrb-31 is not in new fonts -- use 24*/
   { "-bitstream-charter-bold-r-normal--33-240-100-100-p-206-iso8859-1", 0 }                   /*vrb-37 is not in new fonts -- use 33*/               
             /* no bold in vr-40 */
  },
/* [5][0] */ /* TIMES_ITALICS */
  {
   { "-adobe-times-medium-i-normal--10-100-75-75-p-52-iso8859-1", 0 },                      /*times-italic10*/
   { "-adobe-times-medium-i-normal--12-120-75-75-p-63-iso8859-1", 0 },                      /*times-italic12*/
   { "-adobe-times-medium-i-normal--14-140-75-75-p-73-iso8859-1", 0 },                      /*times-italic14*/
   { "-adobe-times-medium-i-normal--18-180-75-75-p-94-iso8859-1", 0 },                      /*times-italic18*/
   { "-adobe-times-medium-i-normal--24-240-75-75-p-125-iso8859-1", 0 },                      /*times-italic24*/
   { "-adobe-times-medium-i-normal--24-240-75-75-p-125-iso8859-1", 0 },                   /*vri-31 is not in new fonts -- use 24*/
   { "-bitstream-charter-medium-i-normal--33-240-100-100-p-179-iso8859-1", 0 }	                  /*vri-40 is not in new fonts- use 33*/
  },
/* [6][0] */ /* GREEK */
  {
   { "-adobe-symbol-medium-r-normal--10-100-75-75-p-61-adobe-fontspecific", 0 },                  /*symbol-medium10*/
   { "-adobe-symbol-medium-r-normal--12-120-75-75-p-74-adobe-fontspecific", 0 },                  /*symbol-medium12*/
   { "-adobe-symbol-medium-r-normal--14-140-75-75-p-85-adobe-fontspecific", 0 },                  /*symbol-medium14*/
   { "-adobe-symbol-medium-r-normal--18-180-75-75-p-107-adobe-fontspecific", 0 },                  /*symbol-medium18*/
   { "-adobe-symbol-medium-r-normal--24-240-75-75-p-142-adobe-fontspecific", 0 },                  /*symbol-medium24*/
   { "-adobe-symbol-medium-r-normal--24-240-75-75-p-142-adobe-fontspecific", 0 },                      /*grk-s25 is not in new fonts -- use 24*/
   { "-adobe-symbol-medium-r-normal--24-240-75-75-p-142-adobe-fontspecific", 0 }                      /*grk-s30 is not in new fonts -- use 24*/
  },
/* [7][0] *//* FIXED - used mostly *//* for coordinates */
  {
   { "6x10", 0 },          /* was 'fixed'*/
   { "8x13", 0 },	   
   { "9x15", 0 },          
   { "-adobe-courier-medium-r-normal--18-180-75-75-m-110-iso8859-1", 0 },         /* was 'fg-18'*/
   { "-adobe-courier-medium-r-normal--18-180-75-75-m-110-iso8859-1", 0 },         /* was 'fg-20'*/
   { "-adobe-courier-medium-r-normal--24-240-75-75-m-150-iso8859-1", 0 },         /* was 'fg-22'*/
   { "-adobe-courier-medium-r-normal--24-240-75-75-m-150-iso8859-1", 0 }         /* was 'fg-25'*/
  },
/* [8][0] *//*SYMBOL - points to the same symbol-medium structures as GREEK */
  {
   { "-adobe-symbol-medium-r-normal--10-100-75-75-p-61-adobe-fontspecific", 0 },                  /*symbol-medium10*/
   { "-adobe-symbol-medium-r-normal--12-120-75-75-p-74-adobe-fontspecific", 0 },                  /*symbol-medium12*/
   { "-adobe-symbol-medium-r-normal--14-140-75-75-p-85-adobe-fontspecific", 0 },                  /*symbol-medium14*/
   { "-adobe-symbol-medium-r-normal--18-180-75-75-p-107-adobe-fontspecific", 0 },                  /*symbol-medium18*/
   { "-adobe-symbol-medium-r-normal--24-240-75-75-p-142-adobe-fontspecific", 0 },                  /*symbol-medium24*/
   { "sym-s25", 0 }, 

   { "sym-s53", 0 }                      /*Sym-s25 and sym-s53 are not in new
 fonts , but we will expect the user to enable old fonts (with xset) before 
 running the program. JeffS 6/13/89**/
  },
/**   { "symbol-medium10", 0 },      
 **   { "symbol-medium12", 0 },      
 **   { "symbol-medium14", 0 },      
 **   { "symbol-medium18", 0 },      
 **   { "symbol-medium24", 0 },
 **   { "sym-s25", 0 },
 **   { "sym-s53", 0 },             
 ***/ /* no sym-s30 */


/* [9][0] *//* FANCY - assume to be *//* rarely use */
  {
   /** Not so fancy any more **/
   { "-bitstream-charter-bold-r-normal--10-100-75-75-p-63-iso8859-1", 0 },          /* was 'vbee-36'*/
   { "-bitstream-charter-bold-r-normal--12-120-75-75-p-75-iso8859-1", 0 },          /* was 'vxms-37'*/
   { "-bitstream-charter-bold-r-normal--15-140-75-75-p-94-iso8859-1", 0 },          /* was 'vxms-43'*/
   { "-bitstream-charter-bold-r-normal--17-120-100-100-p-107-iso8859-1", 0 },          /* was 'vshd-40'*/
   { "-bitstream-charter-bold-r-normal--19-180-75-75-p-119-iso8859-1", 0 },          /* was 'vsgn-57'*/
   { "-bitstream-charter-bold-r-normal--25-240-75-75-p-157-iso8859-1", 0 },          /* was 'vsgn-57'*/
   { "-bitstream-charter-bold-r-normal--33-240-100-100-p-206-iso8859-1", 0 }          /* was 'vsg-114'*/ 
  }

 };

/* familynames holds the font family names that lecture files will use 
   to specify which font family is wanted. The table also holds the
   id_number that is the index to the 2-dimensional font_tbl array. */

family_map family_tbl[MAXFAMILY] = {
  { "helvetica10", 0, 0},
  { "helvetica12", 0, 1},
  { "helvetica14", 0, 2},
  { "helvetica18", 0, 3},
  { "helvetica24", 0, 4},
  { "helvetica30", 0, 5},
  { "helvetica40", 0, 6},
  
  { "times10", 3, 0},
  { "times12", 3, 1},
  { "times14", 3, 2},
  { "times18", 3, 3},
  { "times24", 3, 4},
  { "times30", 3, 5},
  { "times40", 3, 6},

  { "fixed10", 7, 0},
  { "fixed13", 7, 1},
  { "fixed15", 7, 2},
  { "fixed18", 7, 3},
  { "fixed20", 7, 4},
  { "fixed22", 7, 5},
  { "fixed25", 7, 6},

  { "fancy36", 9, 0},
  { "fancy37", 9, 1},
  { "fancy43", 9, 2},
  { "fancy40", 9, 3},
  { "fancy57", 9, 4},
  { "fancy57", 9, 5},
  { "fancy114", 9, 6}
};

/* sym_tbl holds the pixel width information of the symbols used in text 
   formatting.  The reason we need this table is because for some
   reason the "XTextWidth" routine does not give the right width of
   the symbols which was represented by an octal number.  Thus, I have
   to hack to make up this table so that we can get the width of a
   symbol while formatting.  Until we can figure out why the
   XTextWidth routine does not work for octal representations of
   symbols, we will use this table to get our widths. */

sym_map sym_tbl[MAXSYM][MAXSYMSTRUCT] = {
  8, 9, 11, 13, 16,		/* FORALL */  
  6, 7, 9, 11, 14,		/* EXISTS */  
  6, 7, 9, 11, 14,		/* SIMILIAR */  
  5, 6, 7, 8, 10,		/* AST */
  6, 8, 9, 11, 15,		/* LTE */
  6, 8, 10, 12, 16,	        /* INF */
  11, 13, 15, 18, 25,		/* LEFTARROW */
  6, 7, 8, 9, 11,		/* UPARROW */
  11, 13, 15, 18, 25,		/* RIGHTARROW */
  6, 7, 8, 9, 11,		/* DOWNARROW */
  6, 8, 9, 11, 15,		/* PM */
  6, 8, 9, 11, 15,		/* GTE */
  5, 6, 7, 8, 10,		/* MULT */
  6, 7, 9, 11, 16,		/* PAR */
  5, 6, 7, 8, 10,		/* BULLET */
  6, 7, 9, 11, 14,		/* NEQ */  
  7, 8, 10, 12, 15,		/* EQV */  
  6, 7, 9, 11, 14,		/* APPROX */  
  6, 8, 10, 12, 16,	        /* ALEPH */
  8, 10, 12, 15, 22,		/* EMPTYSET */
  8, 10, 11, 13, 17,		/* INTER */
  8, 10, 11, 13, 17,		/* UNION */
  8, 10, 11, 13, 17,		/* PRSUPSET */
  8, 10, 11, 13, 17,		/* SUPSET */
  8, 10, 11, 13, 17,		/* PRSUBSET */
  8, 10, 11, 13, 17,		/* SUBSET */
  8, 10, 11, 13, 17,		/* IN */
  8, 10, 11, 13, 17,		/* NOTIN */
  10, 12, 13, 15, 19,		/* ANGLE */
  11, 12, 13, 15, 19,		/* NABLA */
  7, 9, 10, 12, 16,		/* AND */
  6, 8, 9, 11, 15,		/* OR */
  11, 13, 15, 18, 25,		/* DBLEFTARROW */
  6, 7, 8, 9, 11,		/* DBUPARROW */
  11, 13, 15, 18, 25,		/* DBRIGHTARROW */
  6, 7, 8, 9, 11,		/* DBDOWNARROW */
  8, 9, 11, 13, 18,		/* PI */
  6, 7, 9, 11, 14,		/* SQRT */
  3, 4, 5, 6, 8,		/* DOT - for mult */
  5, 6, 8, 10, 13,		/* SIG */
  3, 4, 5, 6, 8		        /* INT */
 };

