#!/usr/bin/python

# This file generates the constants from discuss sources.
# The first argument is path to those sources.
#
# This is yet another part of Pymoira I wish I had never seen again

import sys, re, os, os.path

##### Constants #####

# This constant is generated by compile_et from 'sms' table name
et_base = 32201984

##### Read the file #####

basepath = sys.argv[1]
if not os.path.isdir(basepath):
    print "ERROR: the specified path is not a directory"
    exit()

with open(basepath + "/ets/dsc_et.et", "r") as et_file_handler:
    et_file = et_file_handler.read()
with open(basepath + "/include/rpc.h", "r") as header_file_handler:
    header_file = header_file_handler.read()

et_match_entries = re.findall( r'ec\s*([A-Z0-9_]+),\s*"([^"]+)"', et_file )
header_match_entries = re.findall( r'#define ([A-Z0-9_]+)\s+(".+"|[0-9x\-]+)', header_file )

if not et_match_entries:
    print "ERROR: unable to parse dsc_et file correctly"
    exit()
if not header_match_entries:
    print "ERROR: unable to parse rpc.h file correctly"
    exit()

##### Code file header #####
print "# Discuss status codes and other constants, generated from discuss sources"
print "#"
print "# NOTE: this file was autogenerated from the following files:"
print ""

##### Discuss error codes #####
print "# Error codes"
cur_code = et_base
for match in et_match_entries:
    print '%s = %s' % (match[0], repr(cur_code))
    cur_code += 1
print ""

print "# Error code descriptions"
print "errors = {"
for match in et_match_entries:
    print '    %s : "%s",' % match
print "}"
print ""

##### Constatns from rpc.h #####
print "# Definitions from rpc.h"
for match in header_match_entries:
    print '%s = %s' % match
print ""
