/*
 * zuser.c: Describe a single user
 * David Maze <dmaze@mit.edu>
 * $Id*
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "zuser.h"

struct _zuser
{
  GString *name;
  int numlocs;
  ZLocations_t *locs;
};

/* Zephyr...! */
Code_t ZGetLocations(ZLocations_t location[], int *numloc);

zuser *zuser_new(const GString *name)
{
  zuser *user = g_new(zuser, 1);
  user->name = g_string_new(name->str);
  user->numlocs = 0;
  user->locs = NULL;
  return user;
}

void zuser_delete(zuser *user)
{
  g_assert(user != NULL);
  g_assert(user->name != NULL);
  g_string_free(user->name, TRUE);
  user->name = NULL;
  g_free(user->locs);
  user->locs = NULL;
  user->numlocs = 0;
  g_free(user);
}

GString *zuser_name(const zuser *user)
{
  g_assert(user->name != NULL);
  return g_string_new(user->name->str);
}

void zuser_update(zuser *user)
{
  GString *fullname = g_string_new("");
  int cresult;

  g_assert(user->name != NULL);
  
  g_string_sprintf(fullname, "%s@%s", user->name->str, ZGetRealm());
  
  cresult = ZLocateUser(fullname->str, &user->numlocs, ZAUTH);
  if (cresult != ZERR_NONE)
  {
    user->numlocs = 0;
    g_free(user->locs);
    user->locs = NULL;
    g_error("Bad shit happened");
    /* Somehow present an error */
    return;
  }

  if (user->numlocs == 0)
  {
    /* Nothing to do */
    g_free(user->locs);
    user->locs = NULL;
    return;
  }

  g_free(user->locs);
  user->locs = g_new(ZLocations_t, user->numlocs);
  cresult = ZGetLocations(user->locs, &user->numlocs);
  switch (cresult)
  {
  case ZERR_NONE:
  case ZERR_NOLOCATIONS:
  case ZERR_NOMORELOCS:
    break; /* All is well */

  default:
    g_free(user->locs);
    user->locs = NULL;
    user->numlocs = 0;
    g_error("Slightly bad shit happened with %s", fullname->str);
    /* Present an error */
  }
}

int zuser_count_locs(const zuser *user)
{
  return user->numlocs;
}

const ZLocations_t *zuser_get_loc(const zuser *user, int n)
{
  g_assert(n >= 0);
  g_assert(n < user->numlocs);
  
  return user->locs + n;
}
